/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl;

import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.Consumer;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.ConsumerInterceptor;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.Message;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.MessageId;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.Reader;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.ReaderInterceptor;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.ConsumerInterceptors;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ReaderInterceptorUtil {
    public static <T> ConsumerInterceptors<T> convertToConsumerInterceptors(Reader<T> reader, List<ReaderInterceptor<T>> interceptorList) {
        if (interceptorList == null || interceptorList.isEmpty()) {
            return null;
        }
        ArrayList consumerInterceptorList = new ArrayList(interceptorList.size());
        for (ReaderInterceptor<T> readerInterceptor : interceptorList) {
            consumerInterceptorList.add(ReaderInterceptorUtil.getInterceptor(reader, readerInterceptor));
        }
        return new ConsumerInterceptors(consumerInterceptorList);
    }

    private static <T> ConsumerInterceptor<T> getInterceptor(final Reader<T> reader, final ReaderInterceptor<T> readerInterceptor) {
        return new ConsumerInterceptor<T>(){

            @Override
            public void close() {
                readerInterceptor.close();
            }

            @Override
            public Message<T> beforeConsume(Consumer<T> consumer, Message<T> message) {
                return readerInterceptor.beforeRead(reader, message);
            }

            @Override
            public void onAcknowledge(Consumer<T> consumer, MessageId messageId, Throwable exception) {
            }

            @Override
            public void onAcknowledgeCumulative(Consumer<T> consumer, MessageId messageId, Throwable exception) {
            }

            @Override
            public void onNegativeAcksSend(Consumer<T> consumer, Set<MessageId> set) {
            }

            @Override
            public void onAckTimeoutSend(Consumer<T> consumer, Set<MessageId> set) {
            }

            @Override
            public void onPartitionsChange(String topicName, int partitions) {
                readerInterceptor.onPartitionsChange(topicName, partitions);
            }
        };
    }
}

