/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl;

import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.PartitionedTopicProducerStats;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.ProducerStats;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.ProducerStatsRecorderImpl;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.DoubleAdder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionedTopicProducerStatsRecorderImpl
extends ProducerStatsRecorderImpl
implements PartitionedTopicProducerStats {
    private static final long serialVersionUID = 1L;
    private Map<String, ProducerStats> partitionStats = new ConcurrentHashMap<String, ProducerStats>();
    private final DoubleAdder sendMsgsRateAggregate = new DoubleAdder();
    private final DoubleAdder sendBytesRateAggregate = new DoubleAdder();
    private int partitions = 0;
    private static final Logger log = LoggerFactory.getLogger(PartitionedTopicProducerStatsRecorderImpl.class);

    @Override
    void reset() {
        super.reset();
        this.partitions = 0;
    }

    void updateCumulativeStats(String partition, ProducerStats stats) {
        super.updateCumulativeStats(stats);
        if (stats == null) {
            return;
        }
        this.partitionStats.put(partition, stats);
        this.sendMsgsRateAggregate.add(stats.getSendMsgsRate());
        this.sendBytesRateAggregate.add(stats.getSendBytesRate());
        ++this.partitions;
    }

    @Override
    public double getSendMsgsRate() {
        return this.sendMsgsRateAggregate.doubleValue() / (double)this.partitions;
    }

    @Override
    public double getSendBytesRate() {
        return this.sendBytesRateAggregate.doubleValue() / (double)this.partitions;
    }

    @Override
    public Map<String, ProducerStats> getPartitionStats() {
        return this.partitionStats;
    }
}

