/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl;

import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.MessageId;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.MessageIdAdv;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.MessageIdImpl;
import java.util.BitSet;

public class MessageIdAdvUtils {
    static int hashCode(MessageIdAdv msgId) {
        return (int)(31L * (msgId.getLedgerId() + 31L * msgId.getEntryId()) + 31L * (long)msgId.getPartitionIndex() + (long)msgId.getBatchIndex());
    }

    static boolean equals(MessageIdAdv lhs, Object o) {
        if (!(o instanceof MessageIdAdv)) {
            return false;
        }
        MessageIdAdv rhs = (MessageIdAdv)o;
        return lhs.getLedgerId() == rhs.getLedgerId() && lhs.getEntryId() == rhs.getEntryId() && lhs.getPartitionIndex() == rhs.getPartitionIndex() && lhs.getBatchIndex() == rhs.getBatchIndex();
    }

    static boolean acknowledge(MessageIdAdv msgId, boolean individual) {
        if (!MessageIdAdvUtils.isBatch(msgId)) {
            return true;
        }
        BitSet ackSet = msgId.getAckSet();
        if (ackSet == null) {
            return false;
        }
        int batchIndex = msgId.getBatchIndex();
        if (individual) {
            ackSet.clear(batchIndex);
        } else {
            ackSet.clear(0, batchIndex + 1);
        }
        return ackSet.isEmpty();
    }

    static boolean isBatch(MessageIdAdv msgId) {
        return msgId.getBatchIndex() >= 0 && msgId.getBatchSize() > 0;
    }

    static MessageIdAdv discardBatch(MessageId messageId) {
        MessageIdAdv msgId = (MessageIdAdv)messageId;
        return new MessageIdImpl(msgId.getLedgerId(), msgId.getEntryId(), msgId.getPartitionIndex());
    }

    static MessageIdAdv prevMessageId(MessageIdAdv msgId) {
        return new MessageIdImpl(msgId.getLedgerId(), msgId.getEntryId() - 1L, msgId.getPartitionIndex());
    }
}

