/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl;

import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.MessageIdAdv;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.MessageIdAdvUtils;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.MessageIdImpl;
import java.util.BitSet;

public class BatchMessageIdImpl
extends MessageIdImpl {
    private static final long serialVersionUID = 1L;
    private final int batchIndex;
    private final int batchSize;
    private final BitSet ackSet;

    private BatchMessageIdImpl() {
        this(-1L, -1L, -1, -1);
    }

    public BatchMessageIdImpl(long ledgerId, long entryId, int partitionIndex, int batchIndex) {
        this(ledgerId, entryId, partitionIndex, batchIndex, 0, null);
    }

    public BatchMessageIdImpl(long ledgerId, long entryId, int partitionIndex, int batchIndex, int batchSize, BitSet ackSet) {
        super(ledgerId, entryId, partitionIndex);
        this.batchIndex = batchIndex;
        this.batchSize = batchSize;
        this.ackSet = ackSet;
    }

    public BatchMessageIdImpl(MessageIdAdv other) {
        this(other.getLedgerId(), other.getEntryId(), other.getPartitionIndex(), other.getBatchIndex(), other.getBatchSize(), other.getAckSet());
    }

    @Override
    public int getBatchIndex() {
        return this.batchIndex;
    }

    @Override
    public int hashCode() {
        return MessageIdAdvUtils.hashCode(this);
    }

    @Override
    public boolean equals(Object o) {
        return MessageIdAdvUtils.equals(this, o);
    }

    @Override
    public String toString() {
        return this.ledgerId + ":" + this.entryId + ":" + this.partitionIndex + ":" + this.batchIndex;
    }

    @Override
    public byte[] toByteArray() {
        return this.toByteArray(this.batchIndex, this.batchSize);
    }

    @Deprecated
    public boolean ackIndividual() {
        return MessageIdAdvUtils.acknowledge(this, true);
    }

    @Deprecated
    public boolean ackCumulative() {
        return MessageIdAdvUtils.acknowledge(this, false);
    }

    @Deprecated
    public int getOutstandingAcksInSameBatch() {
        return 0;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Deprecated
    public int getOriginalBatchSize() {
        return this.batchSize;
    }

    @Deprecated
    public MessageIdImpl prevBatchMessageId() {
        return (MessageIdImpl)MessageIdAdvUtils.prevMessageId(this);
    }

    @Deprecated
    public MessageIdImpl toMessageIdImpl() {
        return (MessageIdImpl)MessageIdAdvUtils.discardBatch(this);
    }

    @Override
    public BitSet getAckSet() {
        return this.ackSet;
    }

    static BitSet newAckSet(int batchSize) {
        BitSet ackSet = new BitSet(batchSize);
        ackSet.set(0, batchSize);
        return ackSet;
    }
}

