/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api;

public enum SizeUnit {
    BYTES(1L),
    KILO_BYTES(1024L),
    MEGA_BYTES(0x100000L),
    GIGA_BYTES(0x40000000L);

    private final long bytes;

    private SizeUnit(long bytes) {
        this.bytes = bytes;
    }

    public long toBytes(long value) {
        return value * this.bytes;
    }

    public long toKiloBytes(long value) {
        return this.toBytes(value) / SizeUnit.KILO_BYTES.bytes;
    }

    public long toMegaBytes(long value) {
        return this.toBytes(value) / SizeUnit.MEGA_BYTES.bytes;
    }

    public long toGigaBytes(long value) {
        return this.toBytes(value) / SizeUnit.GIGA_BYTES.bytes;
    }
}

