/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api;

import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.MessageId;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.ProducerStats;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.PulsarClientException;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.Schema;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.TypedMessageBuilder;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.transaction.Transaction;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.classification.InterfaceAudience;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.classification.InterfaceStability;
import java.io.Closeable;
import java.util.concurrent.CompletableFuture;

@InterfaceAudience.Public
@InterfaceStability.Stable
public interface Producer<T>
extends Closeable {
    public String getTopic();

    public String getProducerName();

    public MessageId send(T var1) throws PulsarClientException;

    public CompletableFuture<MessageId> sendAsync(T var1);

    public void flush() throws PulsarClientException;

    public CompletableFuture<Void> flushAsync();

    public TypedMessageBuilder<T> newMessage();

    public <V> TypedMessageBuilder<V> newMessage(Schema<V> var1);

    public TypedMessageBuilder<T> newMessage(Transaction var1);

    public long getLastSequenceId();

    public ProducerStats getStats();

    @Override
    public void close() throws PulsarClientException;

    public CompletableFuture<Void> closeAsync();

    public boolean isConnected();

    public long getLastDisconnectedTimestamp();

    public int getNumOfPartitions();
}

