/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api;

import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.Message;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.MessagePayload;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.MessagePayloadContext;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.Schema;
import java.util.function.Consumer;

public interface MessagePayloadProcessor {
    public static final MessagePayloadProcessor DEFAULT = new MessagePayloadProcessor(){

        @Override
        public <T> void process(MessagePayload payload, MessagePayloadContext context, Schema<T> schema, Consumer<Message<T>> messageConsumer) {
            if (context.isBatch()) {
                int numMessages = context.getNumMessages();
                for (int i = 0; i < numMessages; ++i) {
                    messageConsumer.accept(context.getMessageAt(i, numMessages, payload, true, schema));
                }
            } else {
                messageConsumer.accept(context.asSingleMessage(payload, schema));
            }
        }
    };

    public <T> void process(MessagePayload var1, MessagePayloadContext var2, Schema<T> var3, Consumer<Message<T>> var4) throws Exception;
}

