/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api;

import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.Message;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.MessageId;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.Messages;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.PulsarClientException;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.transaction.Transaction;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public interface MessageAcknowledger {
    public void acknowledge(MessageId var1) throws PulsarClientException;

    default public void acknowledge(Message<?> message) throws PulsarClientException {
        this.acknowledge(message.getMessageId());
    }

    public void acknowledge(List<MessageId> var1) throws PulsarClientException;

    default public void acknowledge(Messages<?> messages) throws PulsarClientException {
        for (Message message : messages) {
            this.acknowledge(message.getMessageId());
        }
    }

    public void acknowledgeCumulative(MessageId var1) throws PulsarClientException;

    default public void acknowledgeCumulative(Message<?> message) throws PulsarClientException {
        this.acknowledgeCumulative(message.getMessageId());
    }

    public CompletableFuture<Void> acknowledgeAsync(MessageId var1, Transaction var2);

    default public CompletableFuture<Void> acknowledgeAsync(MessageId messageId) {
        return this.acknowledgeAsync(messageId, null);
    }

    public CompletableFuture<Void> acknowledgeAsync(List<MessageId> var1, Transaction var2);

    public CompletableFuture<Void> acknowledgeAsync(List<MessageId> var1);

    public CompletableFuture<Void> acknowledgeAsync(Message<?> var1);

    public CompletableFuture<Void> acknowledgeAsync(Messages<?> var1);

    public CompletableFuture<Void> acknowledgeAsync(Messages<?> var1, Transaction var2);

    public CompletableFuture<Void> acknowledgeCumulativeAsync(MessageId var1, Transaction var2);

    default public CompletableFuture<Void> acknowledgeCumulativeAsync(Message<?> message) {
        return this.acknowledgeCumulativeAsync(message.getMessageId());
    }

    default public CompletableFuture<Void> acknowledgeCumulativeAsync(MessageId messageId) {
        return this.acknowledgeCumulativeAsync(messageId, null);
    }
}

