/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api;

import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.Authentication;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.PulsarClientException;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.internal.DefaultImplementation;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.classification.InterfaceAudience;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.classification.InterfaceStability;
import java.util.Map;
import java.util.function.Supplier;

@InterfaceAudience.LimitedPrivate
@InterfaceStability.Stable
public final class AuthenticationFactory {
    public static Authentication token(String token) {
        return DefaultImplementation.getDefaultImplementation().newAuthenticationToken(token);
    }

    public static Authentication token(Supplier<String> tokenSupplier) {
        return DefaultImplementation.getDefaultImplementation().newAuthenticationToken(tokenSupplier);
    }

    public static Authentication TLS(String certFilePath, String keyFilePath) {
        return DefaultImplementation.getDefaultImplementation().newAuthenticationTLS(certFilePath, keyFilePath);
    }

    public static Authentication create(String authPluginClassName, String authParamsString) throws PulsarClientException.UnsupportedAuthenticationException {
        try {
            return DefaultImplementation.getDefaultImplementation().createAuthentication(authPluginClassName, authParamsString);
        }
        catch (Throwable t) {
            throw new PulsarClientException.UnsupportedAuthenticationException(t);
        }
    }

    public static Authentication create(String authPluginClassName, Map<String, String> authParams) throws PulsarClientException.UnsupportedAuthenticationException {
        try {
            return DefaultImplementation.getDefaultImplementation().createAuthentication(authPluginClassName, authParams);
        }
        catch (Throwable t) {
            throw new PulsarClientException.UnsupportedAuthenticationException(t);
        }
    }
}

