/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms.selectors;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.jms.Destination;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.filter.BooleanExpression;
import org.apache.activemq.filter.MessageEvaluationContext;
import org.apache.activemq.selector.SelectorParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SelectorSupport {
    private static final Logger log = LoggerFactory.getLogger(SelectorSupport.class);
    private final BooleanExpression expression;
    private final String selector;

    public static SelectorSupport build(String selector, boolean enabled) throws JMSException {
        if (selector == null || selector.isEmpty()) {
            return null;
        }
        if (!enabled) {
            throw new InvalidSelectorException("Client-Side selectors are not enabled, please set enableClientSideEmulation=true");
        }
        BooleanExpression parse = SelectorParser.parse(selector);
        if (log.isDebugEnabled()) {
            log.debug("parsed {} as {}", (Object)selector, (Object)parse);
        }
        return new SelectorSupport(parse, selector);
    }

    public boolean matches(Function<String, Object> messagePropertiesAccessor) throws JMSException {
        HashMap cache = new HashMap();
        final Function<String, Object> messageProperties = name -> cache.computeIfAbsent(name, messagePropertiesAccessor::apply);
        MessageEvaluationContext context = new MessageEvaluationContext(){

            @Override
            public boolean isDropped() {
                return false;
            }
        };
        ActiveMQMessage toMessage = new ActiveMQMessage(){

            @Override
            public int incrementReferenceCount() {
                return 0;
            }

            @Override
            public int decrementReferenceCount() {
                return 0;
            }

            @Override
            public int getSize() {
                return 0;
            }

            @Override
            public int getReferenceCount() {
                return 0;
            }

            @Override
            public String getJMSMessageID() {
                return (String)messageProperties.apply("JMSMessageID");
            }

            @Override
            public MessageId getMessageId() {
                return new MessageId(this.getJMSMessageID());
            }

            @Override
            public Destination getJMSReplyTo() {
                return (Destination)messageProperties.apply("JMSReplyTo");
            }

            @Override
            public ActiveMQDestination getReplyTo() {
                return (ActiveMQDestination)messageProperties.apply("JMSReplyTo");
            }

            @Override
            public ActiveMQDestination getOriginalDestination() {
                return (ActiveMQDestination)messageProperties.apply("JMSDestination");
            }

            @Override
            public String getJMSCorrelationID() {
                return (String)messageProperties.apply("JMSCorrelationID");
            }

            @Override
            public String getCorrelationId() {
                return (String)messageProperties.apply("JMSCorrelationID");
            }

            @Override
            public long getJMSTimestamp() {
                return (Long)messageProperties.apply("JMSTimestamp");
            }

            @Override
            public long getTimestamp() {
                return (Long)messageProperties.apply("JMSTimestamp");
            }

            @Override
            public String getGroupID() {
                return (String)messageProperties.apply("JMSXGroupID");
            }

            @Override
            public int getGroupSequence() {
                return (Integer)messageProperties.apply("JMSXGroupSeq");
            }

            @Override
            public boolean isRedelivered() {
                return false;
            }

            @Override
            public long getJMSExpiration() {
                return (Long)messageProperties.apply("JMSExpiration");
            }

            @Override
            public long getExpiration() {
                return (Long)messageProperties.apply("JMSExpiration");
            }

            @Override
            public int getJMSPriority() {
                return (Integer)messageProperties.apply("JMSPriority");
            }

            @Override
            public byte getPriority() {
                return (byte)((Integer)messageProperties.apply("JMSPriority")).intValue();
            }

            @Override
            public int getJMSDeliveryMode() {
                return (Integer)messageProperties.apply("JMSDeliveryMode");
            }

            @Override
            public boolean isPersistent() {
                return (Integer)messageProperties.apply("JMSDeliveryMode") == 2;
            }

            @Override
            public String getJMSType() {
                return (String)messageProperties.apply("JMSType");
            }

            @Override
            public String getType() {
                return (String)messageProperties.apply("JMSType");
            }

            @Override
            public Destination getJMSDestination() {
                return (Destination)messageProperties.apply("JMSDestination");
            }

            @Override
            public Object getProperty(String name) {
                return messageProperties.apply(name);
            }

            @Override
            public Map<String, Object> getProperties() {
                throw new UnsupportedOperationException("not supported - getProperties");
            }
        };
        context.setMessageReference(toMessage);
        return this.expression.matches(context);
    }

    public boolean matches(Message fromMessage) throws JMSException {
        Enumeration propertyNames = fromMessage.getPropertyNames();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        while (propertyNames.hasMoreElements()) {
            String name2 = propertyNames.nextElement().toString();
            Object obj = fromMessage.getObjectProperty(name2);
            properties.put(name2, obj);
        }
        Function<String, Object> getProperty = name -> {
            try {
                switch (name) {
                    case "JMSMessageID": {
                        return fromMessage.getJMSMessageID();
                    }
                    case "JMSCorrelationID": {
                        return fromMessage.getJMSCorrelationID();
                    }
                    case "JMSReplyTo": {
                        return fromMessage.getJMSReplyTo();
                    }
                    case "JMSDestination": {
                        return fromMessage.getJMSDestination();
                    }
                    case "JMSDeliveryMode": {
                        return fromMessage.getJMSDeliveryMode();
                    }
                    case "JMSType": {
                        return fromMessage.getJMSType();
                    }
                    case "JMSExpiration": {
                        return fromMessage.getJMSExpiration();
                    }
                    case "JMSPriority": {
                        return fromMessage.getJMSPriority();
                    }
                    case "JMSTimestamp": {
                        return fromMessage.getJMSTimestamp();
                    }
                }
                return properties.get(name);
            }
            catch (JMSException err) {
                throw new RuntimeException(err);
            }
        };
        return this.matches(getProperty);
    }

    public String toString() {
        return "Selector=" + this.selector + ", exp=" + this.expression;
    }

    public String getSelector() {
        return this.selector;
    }

    public SelectorSupport(BooleanExpression expression, String selector) {
        this.expression = expression;
        this.selector = selector;
    }
}

