/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms.selectors;

import com.datastax.oss.pulsar.jms.selectors.SelectorSupport;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.broker.service.Consumer;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.broker.service.Subscription;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.broker.service.persistent.PersistentSubscription;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.broker.service.plugin.EntryFilter;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.broker.service.plugin.FilterContext;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.api.proto.CommandSubscribe;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.api.proto.KeyValue;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.api.proto.MessageMetadata;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.api.proto.SingleMessageMetadata;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.compression.CompressionCodec;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.compression.CompressionCodecProvider;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.protocol.Commands;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.jms.JMSException;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.bookkeeper.mledger.Entry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSFilter
implements EntryFilter {
    private static final Logger log = LoggerFactory.getLogger(JMSFilter.class);
    private final ConcurrentHashMap<String, SelectorSupport> selectors = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EntryFilter.FilterResult filterEntry(Entry entry, FilterContext context) {
        boolean isExclusive;
        String jmsSelectorOnSubscription;
        Consumer consumer = context.getConsumer();
        Map consumerMetadata = consumer != null ? consumer.getMetadata() : Collections.emptyMap();
        Subscription subscription = context.getSubscription();
        boolean jmsFiltering = "true".equals(consumerMetadata.get("jms.filtering"));
        if (subscription instanceof PersistentSubscription) {
            Map subscriptionProperties = ((PersistentSubscription)subscription).getSubscriptionProperties();
            if (subscriptionProperties != null) {
                jmsSelectorOnSubscription = subscriptionProperties.getOrDefault("jms.selector", "");
                jmsFiltering = jmsFiltering || "true".equals(subscriptionProperties.get("jms.filtering"));
            } else {
                jmsSelectorOnSubscription = "";
            }
        } else {
            jmsSelectorOnSubscription = "";
        }
        if (!jmsFiltering) {
            return EntryFilter.FilterResult.ACCEPT;
        }
        String topicName = context.getSubscription().getTopicName();
        String jmsSelector = consumerMetadata.getOrDefault("jms.selector", "");
        String destinationTypeForTheClient = (String)consumerMetadata.get("jms.destination.type");
        String jmsSelectorRejectAction = (String)consumerMetadata.get("jms.selector.reject.action");
        String filterJMSConnectionID = consumerMetadata.getOrDefault("jms.filter.JMSConnectionID", "");
        boolean forceDropRejected = "true".equals(consumerMetadata.getOrDefault("jms.force.drop.rejected", "false"));
        EntryFilter.FilterResult rejectResultForSelector = "drop".equals(jmsSelectorRejectAction) || forceDropRejected ? EntryFilter.FilterResult.REJECT : EntryFilter.FilterResult.RESCHEDULE;
        MessageMetadata metadata = context.getMsgMetadata();
        if (metadata.hasMarkerType()) {
            return EntryFilter.FilterResult.ACCEPT;
        }
        SelectorSupport selector = this.selectors.computeIfAbsent(jmsSelector, s2 -> {
            try {
                return SelectorSupport.build(s2, !jmsSelector.isEmpty());
            }
            catch (JMSException err) {
                log.error("Cannot build selector from '{}'", (Object)jmsSelector, (Object)err);
                return null;
            }
        });
        if (selector == null && !jmsSelector.isEmpty()) {
            return EntryFilter.FilterResult.RESCHEDULE;
        }
        SelectorSupport selectorOnSubscription = this.selectors.computeIfAbsent(jmsSelectorOnSubscription, s2 -> {
            try {
                return SelectorSupport.build(s2, !jmsSelectorOnSubscription.isEmpty());
            }
            catch (JMSException err) {
                log.error("Cannot build subscription selector from '{}'", (Object)jmsSelectorOnSubscription, (Object)err);
                return null;
            }
        });
        if (selectorOnSubscription == null && !jmsSelectorOnSubscription.isEmpty()) {
            return EntryFilter.FilterResult.RESCHEDULE;
        }
        CommandSubscribe.SubType subType = subscription.getType();
        if (subType == null) {
            subType = CommandSubscribe.SubType.Shared;
        }
        switch (subType) {
            case Exclusive: 
            case Failover: {
                isExclusive = true;
                break;
            }
            default: {
                isExclusive = false;
            }
        }
        try {
            boolean matchesSubscriptionFilter;
            if (metadata.hasNumMessagesInBatch()) {
                ByteBuf payload = entry.getDataBuffer().slice();
                Commands.skipMessageMetadata((ByteBuf)payload);
                int uncompressedSize = metadata.getUncompressedSize();
                CompressionCodec codec = CompressionCodecProvider.getCompressionCodec(metadata.getCompression());
                ByteBuf uncompressedPayload = codec.decode(payload, uncompressedSize);
                try {
                    int numMessages = metadata.getNumMessagesInBatch();
                    boolean oneAccepted = false;
                    boolean allExpired = true;
                    boolean allFilteredBySubscriptionFilter = !jmsSelectorOnSubscription.isEmpty();
                    for (int i = 0; i < numMessages; ++i) {
                        SingleMessageMetadata singleMessageMetadata = new SingleMessageMetadata();
                        ByteBuf singleMessagePayload = Commands.deSerializeSingleMessageInBatch((ByteBuf)uncompressedPayload, (SingleMessageMetadata)singleMessageMetadata, (int)i, (int)numMessages);
                        try {
                            PropertyEvaluator typedProperties = new PropertyEvaluator(singleMessageMetadata.getPropertiesCount(), singleMessageMetadata.getPropertiesList(), destinationTypeForTheClient, topicName, singleMessageMetadata, null);
                            if (!filterJMSConnectionID.isEmpty() && filterJMSConnectionID.equals(typedProperties.apply("JMSConnectionID"))) {
                                if (!isExclusive && !forceDropRejected) {
                                    EntryFilter.FilterResult filterResult = EntryFilter.FilterResult.RESCHEDULE;
                                    return filterResult;
                                }
                                EntryFilter.FilterResult filterResult = EntryFilter.FilterResult.REJECT;
                                return filterResult;
                            }
                            long jmsExpiration = JMSFilter.getJMSExpiration(typedProperties);
                            if (jmsExpiration <= 0L || System.currentTimeMillis() <= jmsExpiration) {
                                allExpired = false;
                            }
                            boolean matches = true;
                            if (selector != null) {
                                matches = JMSFilter.matches(typedProperties, selector);
                            }
                            if (!jmsSelectorOnSubscription.isEmpty()) {
                                boolean matchesSubscriptionFilter2 = JMSFilter.matches(typedProperties, selectorOnSubscription);
                                boolean bl = matches = matches && matchesSubscriptionFilter2;
                                if (matchesSubscriptionFilter2) {
                                    allFilteredBySubscriptionFilter = false;
                                }
                            }
                            oneAccepted = oneAccepted || matches;
                            continue;
                        }
                        finally {
                            singleMessagePayload.release();
                        }
                    }
                    if (allExpired) {
                        EntryFilter.FilterResult filterResult = EntryFilter.FilterResult.REJECT;
                        return filterResult;
                    }
                    if (allFilteredBySubscriptionFilter && !jmsSelectorOnSubscription.isEmpty()) {
                        EntryFilter.FilterResult filterResult = EntryFilter.FilterResult.REJECT;
                        return filterResult;
                    }
                    if (oneAccepted) {
                        EntryFilter.FilterResult filterResult = EntryFilter.FilterResult.ACCEPT;
                        return filterResult;
                    }
                    EntryFilter.FilterResult filterResult = rejectResultForSelector;
                    return filterResult;
                }
                finally {
                    uncompressedPayload.release();
                }
            }
            PropertyEvaluator typedProperties = new PropertyEvaluator(metadata.getPropertiesCount(), metadata.getPropertiesList(), destinationTypeForTheClient, topicName, null, metadata);
            long jmsExpiration = JMSFilter.getJMSExpiration(typedProperties);
            if (jmsExpiration > 0L && System.currentTimeMillis() > jmsExpiration) {
                return EntryFilter.FilterResult.REJECT;
            }
            if (!jmsSelectorOnSubscription.isEmpty() && !(matchesSubscriptionFilter = JMSFilter.matches(typedProperties, selectorOnSubscription))) {
                return EntryFilter.FilterResult.REJECT;
            }
            boolean matches = true;
            if (selector != null) {
                matches = JMSFilter.matches(typedProperties, selector);
            }
            if (!filterJMSConnectionID.isEmpty() && filterJMSConnectionID.equals(typedProperties.apply("JMSConnectionID"))) {
                if (isExclusive) return EntryFilter.FilterResult.REJECT;
                if (!forceDropRejected) return EntryFilter.FilterResult.RESCHEDULE;
                return EntryFilter.FilterResult.REJECT;
            }
            if (!matches) return rejectResultForSelector;
            return EntryFilter.FilterResult.ACCEPT;
        }
        catch (Throwable err) {
            log.error("Error while processing entry " + err, err);
            err.printStackTrace(System.out);
            return EntryFilter.FilterResult.REJECT;
        }
    }

    private static long getJMSExpiration(Function<String, Object> typedProperties) {
        long jmsExpiration = 0L;
        Object value = typedProperties.apply("JMSExpiration");
        if (value != null) {
            try {
                jmsExpiration = Long.parseLong(value + "");
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return jmsExpiration;
    }

    private static Object getProperty(int propertiesCount, List<KeyValue> propertiesList, String name) {
        if (propertiesCount <= 0) {
            return null;
        }
        String type = null;
        String value = null;
        String typeProperty = JMSFilter.propertyType(name);
        for (KeyValue keyValue : propertiesList) {
            String key = keyValue.getKey();
            if (key.equals(typeProperty)) {
                type = keyValue.getValue();
            } else if (key.equals(name)) {
                value = keyValue.getValue();
            }
            if (type == null || value == null) continue;
            break;
        }
        return JMSFilter.getObjectProperty(value, type);
    }

    public void close() {
        this.selectors.clear();
    }

    private static String propertyType(String name) {
        return name + "_jsmtype";
    }

    private static Object getObjectProperty(String value, String type) {
        if (value == null) {
            return null;
        }
        if (type == null) {
            return value;
        }
        switch (type) {
            case "string": {
                return value;
            }
            case "boolean": {
                return Boolean.parseBoolean(value);
            }
            case "float": {
                return Float.valueOf(Float.parseFloat(value));
            }
            case "double": {
                return Double.parseDouble(value);
            }
            case "int": {
                return Integer.parseInt(value);
            }
            case "short": {
                return Short.parseShort(value);
            }
            case "byte": {
                return Byte.parseByte(value);
            }
            case "long": {
                return Long.parseLong(value);
            }
        }
        return value;
    }

    private static String safeString(Object value) {
        return value == null ? null : value.toString();
    }

    private static boolean matches(Function<String, Object> typedProperties, SelectorSupport selector) throws JMSException {
        return selector.matches(typedProperties);
    }

    private static class PropertyEvaluator
    implements Function<String, Object> {
        private int propertiesCount;
        private List<KeyValue> propertiesList;
        private String destinationTypeForTheClient;
        private String topicName;
        private SingleMessageMetadata singleMessageMetadata;
        private MessageMetadata metadata;

        private Object getProperty(String name) {
            return JMSFilter.getProperty(this.propertiesCount, this.propertiesList, name);
        }

        @Override
        public Object apply(String name) {
            switch (name) {
                case "JMSReplyTo": {
                    String _jmsReplyTo = JMSFilter.safeString(this.getProperty("JMSReplyTo"));
                    Object jmsReplyTo = null;
                    if (_jmsReplyTo != null) {
                        String jmsReplyToType;
                        switch (jmsReplyToType = this.getProperty("JMSReplyToType") + "") {
                            case "topic": {
                                return new ActiveMQTopic(_jmsReplyTo);
                            }
                        }
                        return new ActiveMQQueue(_jmsReplyTo);
                    }
                    return null;
                }
                case "JMSDestination": {
                    return "queue".equalsIgnoreCase(this.destinationTypeForTheClient) ? new ActiveMQQueue(this.topicName) : new ActiveMQTopic(this.topicName);
                }
                case "JMSType": 
                case "JMSMessageId": {
                    return this.getProperty(name);
                }
                case "JMSCorrelationID": {
                    String _correlationId = JMSFilter.safeString(this.getProperty("JMSCorrelationID"));
                    if (_correlationId != null) {
                        return new String(Base64.getDecoder().decode(_correlationId), StandardCharsets.UTF_8);
                    }
                    return null;
                }
                case "JMSPriority": {
                    Object jmsPriorityString = this.getProperty("JMSPriority");
                    if (jmsPriorityString != null) {
                        try {
                            return Integer.parseInt(jmsPriorityString + "");
                        }
                        catch (NumberFormatException err) {
                            return 4;
                        }
                    }
                    return 4;
                }
                case "JMSDeliveryMode": {
                    Object deliveryModeString = this.getProperty("JMSDeliveryMode");
                    if (deliveryModeString != null) {
                        try {
                            return Integer.parseInt(deliveryModeString + "");
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    return 2;
                }
                case "JMSTimestamp": {
                    if (this.singleMessageMetadata != null && this.singleMessageMetadata.hasEventTime()) {
                        return this.singleMessageMetadata.getEventTime();
                    }
                    if (this.metadata != null && this.metadata.hasEventTime()) {
                        return this.metadata.getEventTime();
                    }
                    return 0L;
                }
                case "JMSXDeliveryCount": {
                    return 0;
                }
                case "JMSXGroupID": {
                    if (this.singleMessageMetadata != null && this.singleMessageMetadata.hasPartitionKey()) {
                        return this.singleMessageMetadata.getPartitionKey();
                    }
                    if (this.metadata != null && this.metadata.hasPartitionKey()) {
                        return this.metadata.getPartitionKey();
                    }
                    return "";
                }
                case "JMSXGroupSeq": {
                    Object rawJMSXGroupSeq = this.getProperty("JMSXGroupSeq");
                    if (rawJMSXGroupSeq != null) {
                        return rawJMSXGroupSeq;
                    }
                    if (this.singleMessageMetadata != null && this.singleMessageMetadata.hasSequenceId()) {
                        return this.singleMessageMetadata.getSequenceId() + "";
                    }
                    if (this.metadata != null && this.metadata.hasSequenceId()) {
                        return this.metadata.getSequenceId() + "";
                    }
                    return "0";
                }
            }
            return this.getProperty(name);
        }

        public PropertyEvaluator(int propertiesCount, List<KeyValue> propertiesList, String destinationTypeForTheClient, String topicName, SingleMessageMetadata singleMessageMetadata, MessageMetadata metadata) {
            this.propertiesCount = propertiesCount;
            this.propertiesList = propertiesList;
            this.destinationTypeForTheClient = destinationTypeForTheClient;
            this.topicName = topicName;
            this.singleMessageMetadata = singleMessageMetadata;
            this.metadata = metadata;
        }
    }
}

