/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms.messages;

import com.datastax.oss.pulsar.jms.PulsarMessage;
import com.datastax.oss.pulsar.jms.Utils;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.TypedMessageBuilder;
import java.nio.charset.StandardCharsets;
import javax.jms.JMSException;
import javax.jms.MessageNotWriteableException;
import javax.jms.TextMessage;

public final class PulsarTextMessage
extends PulsarMessage
implements TextMessage {
    private String text;

    public PulsarTextMessage(byte[] payload) {
        this.text = payload == null ? null : new String(payload, StandardCharsets.UTF_8);
    }

    public PulsarTextMessage(String text) {
        this.text = text;
    }

    @Override
    protected String messageType() {
        return "text";
    }

    @Override
    public boolean isBodyAssignableTo(Class c) {
        return c == String.class;
    }

    @Override
    public void clearBody() throws JMSException {
        this.text = null;
    }

    @Override
    public <T> T getBody(Class<T> c) throws JMSException {
        return (T)Utils.invoke(() -> c.cast(this.text));
    }

    @Override
    protected void prepareForSend(TypedMessageBuilder<byte[]> producer) throws JMSException {
        if (this.text == null) {
            producer.value(null);
        } else {
            producer.value(this.text.getBytes(StandardCharsets.UTF_8));
        }
    }

    @Override
    public void setText(String string) throws JMSException {
        if (!this.writable) {
            throw new MessageNotWriteableException("Message is not writable");
        }
        this.text = string;
    }

    @Override
    public String getText() throws JMSException {
        return this.text;
    }

    public String toString() {
        return "PulsarTextMessage{" + this.text + "," + this.properties + "}";
    }
}

