/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms.messages;

import com.datastax.oss.pulsar.jms.PulsarMessage;
import com.datastax.oss.pulsar.jms.Utils;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.TypedMessageBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import javax.jms.JMSException;
import javax.jms.MessageFormatException;
import javax.jms.StreamMessage;

public final class PulsarStreamMessage
extends PulsarMessage
implements StreamMessage {
    protected ByteArrayOutputStream stream;
    protected byte[] originalMessage;
    protected DataInputStream dataInputStream;
    protected DataOutputStream dataOutputStream;
    protected int remainingByteArrayLen = Integer.MIN_VALUE;
    protected static final byte TYPE_BOOLEAN = 1;
    protected static final byte TYPE_STRING = 2;
    protected static final byte TYPE_INT = 3;
    protected static final byte TYPE_SHORT = 4;
    protected static final byte TYPE_LONG = 5;
    protected static final byte TYPE_FLOAT = 6;
    protected static final byte TYPE_DOUBLE = 7;
    protected static final byte TYPE_BYTE = 8;
    protected static final byte TYPE_CHAR = 9;
    protected static final byte TYPE_BYTES = 10;
    protected static final byte TYPE_NULL = 11;

    @Override
    protected String messageType() {
        return "stream";
    }

    protected void checkType(byte type, byte expected) throws JMSException {
        if (type != expected) {
            throw new MessageFormatException("Invalid type " + PulsarStreamMessage.typeToString(type) + ", expected " + PulsarStreamMessage.typeToString(expected));
        }
    }

    @Override
    public <T> T getBody(Class<T> c) throws JMSException {
        throw new MessageFormatException("getBody not available on StreamMessage");
    }

    protected void writeDataType(byte dataType) throws IOException {
        this.dataOutputStream.writeByte(dataType);
    }

    protected void writeArrayLen(int len) throws IOException {
        this.dataOutputStream.writeInt(len);
    }

    protected int readArrayLen() throws IOException {
        return this.dataInputStream.readInt();
    }

    protected byte readDataType() throws IOException {
        return this.dataInputStream.readByte();
    }

    @Override
    public int readBytes(byte[] value) throws JMSException {
        if (value == null) {
            return -1;
        }
        if (value.length == 0) {
            return 0;
        }
        return this.readBytes(value, value.length);
    }

    private void resetStreamAtMark() throws JMSException {
        try {
            this.dataInputStream.reset();
        }
        catch (IOException err) {
            throw PulsarStreamMessage.handleExceptionAccordingToMessageSpecs(err);
        }
    }

    @Override
    public Object readObject() throws JMSException {
        this.checkReadable();
        if (this.remainingByteArrayLen != Integer.MIN_VALUE) {
            throw new MessageFormatException("You must complete the readBytes operation");
        }
        try {
            this.dataInputStream.mark(100);
            byte dataType = this.readDataType();
            switch (dataType) {
                case 11: {
                    return null;
                }
                case 1: {
                    return this.dataInputStream.readBoolean();
                }
                case 7: {
                    return this.dataInputStream.readDouble();
                }
                case 6: {
                    return Float.valueOf(this.dataInputStream.readFloat());
                }
                case 3: {
                    return this.dataInputStream.readInt();
                }
                case 5: {
                    return this.dataInputStream.readLong();
                }
                case 4: {
                    return this.dataInputStream.readShort();
                }
                case 2: {
                    return this.dataInputStream.readUTF();
                }
                case 8: {
                    return this.dataInputStream.readByte();
                }
                case 9: {
                    return Character.valueOf(this.dataInputStream.readChar());
                }
                case 10: {
                    int len = this.readArrayLen();
                    byte[] buffer = new byte[len];
                    this.dataInputStream.readFully(buffer);
                    return buffer;
                }
            }
            throw new MessageFormatException("Wrong data type: " + dataType);
        }
        catch (Exception err) {
            this.resetStreamAtMark();
            throw PulsarStreamMessage.handleExceptionAccordingToMessageSpecs(err);
        }
    }

    private static String typeToString(byte type) {
        switch (type) {
            case 1: {
                return "boolean";
            }
            case 2: {
                return "string";
            }
            case 3: {
                return "int";
            }
            case 4: {
                return "short";
            }
            case 5: {
                return "long";
            }
            case 6: {
                return "float";
            }
            case 7: {
                return "double";
            }
            case 8: {
                return "byte";
            }
            case 9: {
                return "char";
            }
            case 10: {
                return "bytes";
            }
            case 11: {
                return "null";
            }
        }
        return "?" + type;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public PulsarStreamMessage(byte[] payload) throws JMSException {
        try {
            this.dataInputStream = new DataInputStream(new ByteArrayInputStream(payload));
            this.originalMessage = payload;
            this.stream = null;
            this.dataOutputStream = null;
            this.writable = false;
        }
        catch (Exception err) {
            throw Utils.handleException(err);
        }
    }

    public PulsarStreamMessage() {
        try {
            this.dataInputStream = null;
            this.stream = new ByteArrayOutputStream();
            this.dataOutputStream = new DataOutputStream(this.stream);
            this.originalMessage = null;
            this.writable = true;
        }
        catch (Exception err) {
            throw new RuntimeException(err);
        }
    }

    @Override
    public boolean isBodyAssignableTo(Class c) throws JMSException {
        return byte[].class == c;
    }

    @Override
    protected void prepareForSend(TypedMessageBuilder<byte[]> producer) throws JMSException {
        try {
            if (this.stream != null) {
                this.dataOutputStream.flush();
                this.dataOutputStream.close();
                producer.value(this.stream.toByteArray());
            } else {
                producer.value(this.originalMessage);
            }
        }
        catch (Exception err) {
            throw Utils.handleException(err);
        }
    }

    @Override
    public boolean readBoolean() throws JMSException {
        this.checkReadable();
        try {
            byte dataType = this.readDataType();
            switch (dataType) {
                case 1: {
                    return this.dataInputStream.readBoolean();
                }
                case 2: {
                    return Boolean.parseBoolean(this.dataInputStream.readUTF());
                }
            }
            if (dataType != 11) {
                this.checkType(dataType, (byte)1);
            }
            return false;
        }
        catch (Exception err) {
            throw PulsarStreamMessage.handleExceptionAccordingToMessageSpecs(err);
        }
    }

    @Override
    public byte readByte() throws JMSException {
        this.checkReadable();
        try {
            this.dataInputStream.mark(2);
            byte dataType = this.readDataType();
            switch (dataType) {
                case 2: {
                    return Byte.parseByte(this.dataInputStream.readUTF());
                }
                case 8: {
                    return this.dataInputStream.readByte();
                }
            }
            this.checkType(dataType, (byte)8);
            return 0;
        }
        catch (Exception err) {
            this.resetStreamAtMark();
            throw PulsarStreamMessage.handleExceptionAccordingToMessageSpecs(err);
        }
    }

    @Override
    public short readShort() throws JMSException {
        this.checkReadable();
        try {
            this.dataInputStream.mark(5);
            byte dataType = this.readDataType();
            switch (dataType) {
                case 4: {
                    return this.dataInputStream.readShort();
                }
                case 2: {
                    return Short.parseShort(this.dataInputStream.readUTF());
                }
                case 8: {
                    return this.dataInputStream.readByte();
                }
            }
            this.checkType(dataType, (byte)4);
            return 0;
        }
        catch (Exception err) {
            this.resetStreamAtMark();
            throw PulsarStreamMessage.handleExceptionAccordingToMessageSpecs(err);
        }
    }

    @Override
    public char readChar() throws JMSException {
        this.checkReadable();
        try {
            this.dataInputStream.mark(2);
            byte dataType = this.readDataType();
            switch (dataType) {
                case 9: {
                    return this.dataInputStream.readChar();
                }
                case 11: {
                    throw new NullPointerException("invalid conversion");
                }
            }
            this.checkType(dataType, (byte)9);
            return '\u0000';
        }
        catch (NullPointerException err) {
            throw err;
        }
        catch (Exception err) {
            this.resetStreamAtMark();
            throw PulsarStreamMessage.handleExceptionAccordingToMessageSpecs(err);
        }
    }

    @Override
    public int readInt() throws JMSException {
        this.checkReadable();
        try {
            byte dataType = this.readDataType();
            switch (dataType) {
                case 3: {
                    return this.dataInputStream.readInt();
                }
                case 4: {
                    return this.dataInputStream.readShort();
                }
                case 2: {
                    return Integer.parseInt(this.dataInputStream.readUTF());
                }
                case 8: {
                    return this.dataInputStream.readByte();
                }
            }
            this.checkType(dataType, (byte)3);
            return 0;
        }
        catch (Exception err) {
            throw PulsarStreamMessage.handleExceptionAccordingToMessageSpecs(err);
        }
    }

    @Override
    public long readLong() throws JMSException {
        this.checkReadable();
        try {
            this.dataInputStream.mark(9);
            byte dataType = this.readDataType();
            switch (dataType) {
                case 3: {
                    return this.dataInputStream.readInt();
                }
                case 5: {
                    return this.dataInputStream.readLong();
                }
                case 4: {
                    return this.dataInputStream.readShort();
                }
                case 2: {
                    return Integer.parseInt(this.dataInputStream.readUTF());
                }
                case 8: {
                    return this.dataInputStream.readByte();
                }
            }
            this.checkType(dataType, (byte)5);
            return 0L;
        }
        catch (Exception err) {
            this.resetStreamAtMark();
            throw PulsarStreamMessage.handleExceptionAccordingToMessageSpecs(err);
        }
    }

    @Override
    public float readFloat() throws JMSException {
        this.checkReadable();
        try {
            this.dataInputStream.mark(9);
            byte dataType = this.readDataType();
            switch (dataType) {
                case 6: {
                    return this.dataInputStream.readFloat();
                }
                case 2: {
                    return Float.parseFloat(this.dataInputStream.readUTF());
                }
            }
            this.checkType(dataType, (byte)6);
            return 0.0f;
        }
        catch (Exception err) {
            this.resetStreamAtMark();
            throw PulsarStreamMessage.handleExceptionAccordingToMessageSpecs(err);
        }
    }

    @Override
    public double readDouble() throws JMSException {
        this.checkReadable();
        try {
            this.dataInputStream.mark(9);
            byte dataType = this.readDataType();
            switch (dataType) {
                case 6: {
                    return this.dataInputStream.readFloat();
                }
                case 7: {
                    return this.dataInputStream.readDouble();
                }
                case 2: {
                    return Double.parseDouble(this.dataInputStream.readUTF());
                }
            }
            this.checkType(dataType, (byte)7);
            return 0.0;
        }
        catch (Exception err) {
            this.resetStreamAtMark();
            throw PulsarStreamMessage.handleExceptionAccordingToMessageSpecs(err);
        }
    }

    @Override
    public String readString() throws JMSException {
        this.checkReadable();
        try {
            this.dataInputStream.mark(100);
            byte dataType = this.readDataType();
            switch (dataType) {
                case 11: {
                    return null;
                }
                case 2: {
                    return this.dataInputStream.readUTF();
                }
                case 1: {
                    return Boolean.toString(this.dataInputStream.readBoolean());
                }
                case 9: {
                    return Character.toString(this.dataInputStream.readChar());
                }
                case 8: {
                    return Byte.toString(this.dataInputStream.readByte());
                }
                case 4: {
                    return Short.toString(this.dataInputStream.readShort());
                }
                case 5: {
                    return Long.toString(this.dataInputStream.readLong());
                }
                case 3: {
                    return Integer.toString(this.dataInputStream.readInt());
                }
                case 6: {
                    return Float.toString(this.dataInputStream.readFloat());
                }
                case 7: {
                    return Double.toString(this.dataInputStream.readDouble());
                }
            }
            throw new MessageFormatException("Cannot read a string out of a " + PulsarStreamMessage.typeToString(dataType));
        }
        catch (Exception err) {
            this.resetStreamAtMark();
            throw PulsarStreamMessage.handleExceptionAccordingToMessageSpecs(err);
        }
    }

    @Override
    public void writeBoolean(boolean value) throws JMSException {
        this.checkWritable();
        try {
            this.writeDataType((byte)1);
            this.dataOutputStream.writeBoolean(value);
        }
        catch (Exception err) {
            throw PulsarStreamMessage.handleExceptionAccordingToMessageSpecs(err);
        }
    }

    @Override
    public void writeByte(byte value) throws JMSException {
        this.checkWritable();
        try {
            this.writeDataType((byte)8);
            this.dataOutputStream.writeByte(value);
        }
        catch (Exception err) {
            throw PulsarStreamMessage.handleExceptionAccordingToMessageSpecs(err);
        }
    }

    @Override
    public void writeShort(short value) throws JMSException {
        this.checkWritable();
        try {
            this.writeDataType((byte)4);
            this.dataOutputStream.writeShort(value);
        }
        catch (Exception err) {
            throw PulsarStreamMessage.handleExceptionAccordingToMessageSpecs(err);
        }
    }

    @Override
    public void writeChar(char value) throws JMSException {
        this.checkWritable();
        try {
            this.writeDataType((byte)9);
            this.dataOutputStream.writeChar(value);
        }
        catch (Exception err) {
            throw PulsarStreamMessage.handleExceptionAccordingToMessageSpecs(err);
        }
    }

    @Override
    public void writeInt(int value) throws JMSException {
        this.checkWritable();
        try {
            this.writeDataType((byte)3);
            this.dataOutputStream.writeInt(value);
        }
        catch (Exception err) {
            throw PulsarStreamMessage.handleExceptionAccordingToMessageSpecs(err);
        }
    }

    @Override
    public void writeLong(long value) throws JMSException {
        this.checkWritable();
        try {
            this.writeDataType((byte)5);
            this.dataOutputStream.writeLong(value);
        }
        catch (Exception err) {
            throw PulsarStreamMessage.handleExceptionAccordingToMessageSpecs(err);
        }
    }

    @Override
    public void writeFloat(float value) throws JMSException {
        this.checkWritable();
        try {
            this.writeDataType((byte)6);
            this.dataOutputStream.writeFloat(value);
        }
        catch (Exception err) {
            throw PulsarStreamMessage.handleExceptionAccordingToMessageSpecs(err);
        }
    }

    @Override
    public void writeDouble(double value) throws JMSException {
        this.checkWritable();
        try {
            this.writeDataType((byte)7);
            this.dataOutputStream.writeDouble(value);
        }
        catch (Exception err) {
            throw PulsarStreamMessage.handleExceptionAccordingToMessageSpecs(err);
        }
    }

    @Override
    public void writeString(String value) throws JMSException {
        this.checkWritable();
        try {
            if (value == null) {
                this.writeDataType((byte)11);
                return;
            }
            this.writeDataType((byte)2);
            this.dataOutputStream.writeUTF(value);
        }
        catch (Exception err) {
            throw PulsarStreamMessage.handleExceptionAccordingToMessageSpecs(err);
        }
    }

    @Override
    public void writeBytes(byte[] value) throws JMSException {
        this.writeBytes(value, 0, value.length);
    }

    @Override
    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        this.checkWritable();
        if (value == null) {
            throw new NullPointerException();
        }
        try {
            this.writeDataType((byte)10);
            this.writeArrayLen(length);
            this.dataOutputStream.write(value, offset, length);
        }
        catch (Exception err) {
            throw PulsarStreamMessage.handleExceptionAccordingToMessageSpecs(err);
        }
    }

    @Override
    public void writeObject(Object value) throws JMSException {
        block13: {
            this.checkWritable();
            try {
                if (value == null) {
                    this.writeDataType((byte)11);
                    return;
                }
                if (value instanceof Integer) {
                    this.writeInt((Integer)value);
                    break block13;
                }
                if (value instanceof String) {
                    this.writeUTF((String)value);
                    break block13;
                }
                if (value instanceof Short) {
                    this.writeShort((Short)value);
                    break block13;
                }
                if (value instanceof Long) {
                    this.writeLong((Long)value);
                    break block13;
                }
                if (value instanceof Double) {
                    this.writeDouble((Double)value);
                    break block13;
                }
                if (value instanceof Float) {
                    this.writeFloat(((Float)value).floatValue());
                    break block13;
                }
                if (value instanceof Byte) {
                    this.writeByte((Byte)value);
                    break block13;
                }
                if (value instanceof Character) {
                    this.writeChar(((Character)value).charValue());
                    break block13;
                }
                if (value instanceof Boolean) {
                    this.writeBoolean((Boolean)value);
                    break block13;
                }
                if (value instanceof byte[]) {
                    this.writeBytes((byte[])value);
                    break block13;
                }
                throw new MessageFormatException("Unsupported type " + value.getClass());
            }
            catch (Exception err) {
                throw PulsarStreamMessage.handleExceptionAccordingToMessageSpecs(err);
            }
        }
    }

    @Override
    public void clearBody() throws JMSException {
        this.remainingByteArrayLen = Integer.MIN_VALUE;
        this.writable = true;
        try {
            if (this.stream != null) {
                this.dataInputStream = new DataInputStream(new ByteArrayInputStream(this.stream.toByteArray()));
                this.stream = null;
                this.dataOutputStream = null;
            } else {
                this.stream = new ByteArrayOutputStream();
                this.dataOutputStream = new DataOutputStream(this.stream);
                this.originalMessage = null;
                this.dataInputStream = null;
            }
        }
        catch (Exception err) {
            throw PulsarStreamMessage.handleExceptionAccordingToMessageSpecs(err);
        }
    }

    @Override
    public void reset() throws JMSException {
        this.remainingByteArrayLen = Integer.MIN_VALUE;
        this.writable = false;
        try {
            if (this.stream != null) {
                this.dataOutputStream.flush();
                this.originalMessage = this.stream.toByteArray();
                this.dataInputStream = new DataInputStream(new ByteArrayInputStream(this.originalMessage));
                this.stream = null;
                this.dataOutputStream = null;
            } else {
                this.dataInputStream = new DataInputStream(new ByteArrayInputStream(this.originalMessage));
            }
        }
        catch (Exception err) {
            throw PulsarStreamMessage.handleExceptionAccordingToMessageSpecs(err);
        }
    }

    public long getBodyLength() throws JMSException {
        this.checkReadable();
        return this.originalMessage.length;
    }

    public int readUnsignedByte() throws JMSException {
        this.checkReadable();
        try {
            this.dataInputStream.mark(2);
            this.checkType(this.readDataType(), (byte)8);
            return this.dataInputStream.readUnsignedByte();
        }
        catch (Exception err) {
            this.resetStreamAtMark();
            throw PulsarStreamMessage.handleExceptionAccordingToMessageSpecs(err);
        }
    }

    public int readUnsignedShort() throws JMSException {
        this.checkReadable();
        try {
            this.dataInputStream.mark(5);
            this.checkType(this.readDataType(), (byte)4);
            return this.dataInputStream.readUnsignedShort();
        }
        catch (Exception err) {
            this.resetStreamAtMark();
            throw PulsarStreamMessage.handleExceptionAccordingToMessageSpecs(err);
        }
    }

    public String readUTF() throws JMSException {
        return this.readString();
    }

    public int readBytes(byte[] value, int length) throws JMSException {
        this.checkReadable();
        if (length < 0 || value != null && length > value.length) {
            throw new IndexOutOfBoundsException();
        }
        try {
            if (this.remainingByteArrayLen == Integer.MIN_VALUE) {
                this.dataInputStream.mark(length);
                this.checkType(this.readDataType(), (byte)10);
                this.remainingByteArrayLen = this.readArrayLen();
                if (value == null) {
                    return -1;
                }
                int read = this.dataInputStream.read(value, 0, length);
                this.remainingByteArrayLen -= read;
                return read;
            }
            if (this.remainingByteArrayLen > 0) {
                if (value == null) {
                    return -1;
                }
                int read = this.dataInputStream.read(value, 0, length);
                this.remainingByteArrayLen -= read;
                return read;
            }
            this.remainingByteArrayLen = Integer.MIN_VALUE;
            return -1;
        }
        catch (EOFException err) {
            return -1;
        }
        catch (Exception err) {
            this.resetStreamAtMark();
            throw PulsarStreamMessage.handleExceptionAccordingToMessageSpecs(err);
        }
    }

    public void writeUTF(String value) throws JMSException {
        this.writeString(value);
    }
}

