/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms.messages;

import com.datastax.oss.pulsar.jms.PulsarMessage;
import com.datastax.oss.pulsar.jms.Utils;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.TypedMessageBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;

public final class PulsarObjectMessage
extends PulsarMessage
implements ObjectMessage {
    private Serializable object;

    public PulsarObjectMessage(Serializable object) throws JMSException {
        this(PulsarObjectMessage.encode(object));
    }

    public PulsarObjectMessage(byte[] originalMessage) throws JMSException {
        this.object = PulsarObjectMessage.decode(originalMessage);
    }

    private static Serializable decode(byte[] originalMessage) throws JMSException {
        if (originalMessage == null) {
            return null;
        }
        try {
            ObjectInputStream input = new ObjectInputStream(new ByteArrayInputStream(originalMessage));
            return (Serializable)input.readUnshared();
        }
        catch (Exception err) {
            throw Utils.handleException(err);
        }
    }

    public PulsarObjectMessage() {
    }

    @Override
    protected String messageType() {
        return "object";
    }

    @Override
    public boolean isBodyAssignableTo(Class c) throws JMSException {
        return c.isAssignableFrom(Serializable.class) || this.object != null && c.isInstance(this.object);
    }

    @Override
    public void clearBody() throws JMSException {
        this.writable = true;
        this.object = null;
    }

    @Override
    public <T> T getBody(Class<T> c) throws JMSException {
        if (this.object == null) {
            return null;
        }
        return (T)Utils.invoke(() -> c.cast(this.object));
    }

    @Override
    protected void prepareForSend(TypedMessageBuilder<byte[]> producer) throws JMSException {
        byte[] encoded = PulsarObjectMessage.encode(this.object);
        producer.value(encoded);
    }

    private static byte[] encode(Object object) throws JMSException {
        if (object == null) {
            return null;
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream oo = new ObjectOutputStream(out);
            oo.writeUnshared(object);
            oo.flush();
            oo.close();
            return out.toByteArray();
        }
        catch (Exception err) {
            throw Utils.handleException(err);
        }
    }

    @Override
    public void setObject(Serializable object) throws JMSException {
        this.checkWritable();
        this.object = PulsarObjectMessage.decode(PulsarObjectMessage.encode(object));
    }

    @Override
    public Serializable getObject() throws JMSException {
        return this.object;
    }

    public String toString() {
        if (this.object == null) {
            return "PulsarObjectMessage{null," + this.properties + "}";
        }
        return "PulsarObjectMessage{" + this.object + "," + this.object.getClass() + "," + this.properties + "}";
    }
}

