/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms.messages;

import com.datastax.oss.pulsar.jms.PulsarMessage;
import com.datastax.oss.pulsar.jms.Utils;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.TypedMessageBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.MessageFormatException;

public final class PulsarMapMessage
extends PulsarMessage
implements MapMessage {
    private final Map<String, Object> map = new HashMap<String, Object>();

    public PulsarMapMessage() {
        this.writable = true;
    }

    public PulsarMapMessage(Map<String, Object> body) throws MessageFormatException {
        this(body, true);
    }

    public PulsarMapMessage(Map<String, Object> body, boolean validate) throws MessageFormatException {
        this();
        if (body != null) {
            this.map.putAll(body);
            if (validate) {
                for (Object value : body.values()) {
                    PulsarMapMessage.validateWritableObject(value);
                }
            }
        }
    }

    @Override
    protected String messageType() {
        return "map";
    }

    public PulsarMapMessage(byte[] payload) throws JMSException {
        this.writable = false;
        if (payload != null) {
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(payload);
                ObjectInputStream input = new ObjectInputStream(in);
                int size = input.readInt();
                for (int i = 0; i < size; ++i) {
                    String key = input.readUTF();
                    Object value = input.readUnshared();
                    this.map.put(key, value);
                }
            }
            catch (Exception err) {
                throw PulsarMapMessage.handleExceptionAccordingToMessageSpecs(err);
            }
        }
    }

    @Override
    public void clearBody() throws JMSException {
        this.writable = true;
        this.map.clear();
    }

    @Override
    public <T> T getBody(Class<T> c) throws JMSException {
        if (c == Map.class) {
            return (T)this.map;
        }
        throw new MessageFormatException("only java.util.Map is supported");
    }

    @Override
    public boolean isBodyAssignableTo(Class c) throws JMSException {
        return c == Map.class;
    }

    @Override
    protected void prepareForSend(TypedMessageBuilder<byte[]> producer) throws JMSException {
        if (this.map.isEmpty()) {
            producer.value(null);
            return;
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream oo = new ObjectOutputStream(out);
            oo.writeInt(this.map.size());
            for (Map.Entry<String, Object> entry : this.map.entrySet()) {
                oo.writeUTF(entry.getKey());
                oo.writeUnshared(entry.getValue());
            }
            oo.flush();
            oo.close();
            producer.value(out.toByteArray());
        }
        catch (Exception err) {
            throw PulsarMapMessage.handleExceptionAccordingToMessageSpecs(err);
        }
    }

    @Override
    public boolean getBoolean(String name) throws JMSException {
        Object value = this.map.get(name);
        if (value == null) {
            throw new NullPointerException("Invalid null value (" + this.map + ")");
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        this.allowOnlyStrings(value);
        try {
            return Boolean.parseBoolean(value.toString());
        }
        catch (Exception err) {
            throw PulsarMapMessage.handleExceptionAccordingToMessageSpecs(err);
        }
    }

    @Override
    public byte getByte(String name) throws JMSException {
        Object value = this.map.get(name);
        if (value == null) {
            throw new NullPointerException("Invalid null value");
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        this.allowOnlyStrings(value);
        try {
            return Byte.parseByte(value.toString());
        }
        catch (Exception err) {
            throw PulsarMapMessage.handleExceptionAccordingToMessageSpecs(err);
        }
    }

    @Override
    public short getShort(String name) throws JMSException {
        Object value = this.map.get(name);
        if (value == null) {
            throw new NullPointerException("Invalid null value");
        }
        if (value instanceof Byte || value instanceof Short) {
            return ((Number)value).shortValue();
        }
        this.allowOnlyStrings(value);
        try {
            return Short.parseShort(value.toString());
        }
        catch (Exception err) {
            throw PulsarMapMessage.handleExceptionAccordingToMessageSpecs(err);
        }
    }

    @Override
    public char getChar(String name) throws JMSException {
        return Utils.invoke(() -> (Character)this.map.get(name)).charValue();
    }

    @Override
    public int getInt(String name) throws JMSException {
        Object value = this.map.get(name);
        if (value == null) {
            throw new NullPointerException("Invalid null value");
        }
        if (value instanceof Integer || value instanceof Short || value instanceof Byte) {
            return ((Number)value).intValue();
        }
        this.allowOnlyStrings(value);
        try {
            return Integer.parseInt(value.toString());
        }
        catch (Exception err) {
            throw PulsarMapMessage.handleExceptionAccordingToMessageSpecs(err);
        }
    }

    @Override
    public long getLong(String name) throws JMSException {
        Object value = this.map.get(name);
        if (value == null) {
            throw new NullPointerException("Invalid null value");
        }
        if (value instanceof Integer || value instanceof Short || value instanceof Byte || value instanceof Long) {
            return ((Number)value).longValue();
        }
        this.allowOnlyStrings(value);
        try {
            return Long.parseLong(value.toString());
        }
        catch (Exception err) {
            throw PulsarMapMessage.handleExceptionAccordingToMessageSpecs(err);
        }
    }

    @Override
    public float getFloat(String name) throws JMSException {
        Object value = this.map.get(name);
        if (value == null) {
            throw new NullPointerException("Invalid null value");
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        this.allowOnlyStrings(value);
        try {
            return Float.parseFloat(value.toString());
        }
        catch (Exception err) {
            throw PulsarMapMessage.handleExceptionAccordingToMessageSpecs(err);
        }
    }

    @Override
    public double getDouble(String name) throws JMSException {
        Object value = this.map.get(name);
        if (value == null) {
            throw new NullPointerException("Invalid null value");
        }
        if (value instanceof Double || value instanceof Float) {
            return ((Number)value).doubleValue();
        }
        this.allowOnlyStrings(value);
        try {
            return Double.parseDouble(value.toString());
        }
        catch (Exception err) {
            throw PulsarMapMessage.handleExceptionAccordingToMessageSpecs(err);
        }
    }

    private void allowOnlyStrings(Object value) throws MessageFormatException {
        if (!(value instanceof String)) {
            throw new MessageFormatException("Invalid conversion");
        }
    }

    @Override
    public String getString(String name) throws JMSException {
        Object value = this.map.get(name);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Number || value instanceof Boolean || value instanceof Character) {
            return value.toString();
        }
        throw new MessageFormatException("Unsupported conversion");
    }

    @Override
    public byte[] getBytes(String name) throws JMSException {
        return Utils.invoke(() -> (byte[])this.map.get(name));
    }

    @Override
    public Object getObject(String name) throws JMSException {
        return Utils.invoke(() -> this.map.get(name));
    }

    @Override
    public Enumeration getMapNames() throws JMSException {
        return Collections.enumeration(this.map.keySet());
    }

    @Override
    public void setBoolean(String name, boolean value) throws JMSException {
        this.checkWritableProperty(name);
        this.map.put(name, value);
    }

    @Override
    public void setByte(String name, byte value) throws JMSException {
        this.checkWritableProperty(name);
        this.map.put(name, value);
    }

    @Override
    public void setShort(String name, short value) throws JMSException {
        this.checkWritableProperty(name);
        this.map.put(name, value);
    }

    @Override
    public void setChar(String name, char value) throws JMSException {
        this.checkWritableProperty(name);
        this.map.put(name, Character.valueOf(value));
    }

    @Override
    public void setInt(String name, int value) throws JMSException {
        this.checkWritableProperty(name);
        this.map.put(name, value);
    }

    @Override
    public void setLong(String name, long value) throws JMSException {
        this.checkWritableProperty(name);
        this.map.put(name, value);
    }

    @Override
    public void setFloat(String name, float value) throws JMSException {
        this.checkWritableProperty(name);
        this.map.put(name, Float.valueOf(value));
    }

    @Override
    public void setDouble(String name, double value) throws JMSException {
        this.checkWritableProperty(name);
        this.map.put(name, value);
    }

    @Override
    public void setString(String name, String value) throws JMSException {
        this.checkWritableProperty(name);
        this.map.put(name, value);
    }

    @Override
    public void setBytes(String name, byte[] value) throws JMSException {
        this.checkWritableProperty(name);
        this.map.put(name, value);
    }

    @Override
    public void setBytes(String name, byte[] value, int offset, int length) throws JMSException {
        this.checkWritableProperty(name);
        if (offset == 0 && length == value.length) {
            this.map.put(name, value);
        } else {
            byte[] copy = new byte[length];
            System.arraycopy(value, offset, copy, 0, length);
            this.map.put(name, copy);
        }
    }

    @Override
    public void setObject(String name, Object value) throws JMSException {
        this.checkWritableProperty(name);
        PulsarMapMessage.validateWritableObject(value);
        this.map.put(name, value);
    }

    @Override
    public boolean itemExists(String name) throws JMSException {
        return this.map.containsKey(name);
    }
}

