/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms.jndi;

import com.datastax.oss.pulsar.jms.jndi.PulsarContext;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarInitialContextFactory
implements InitialContextFactory {
    private static final Logger log = LoggerFactory.getLogger(PulsarInitialContextFactory.class);
    static final Map<Hashtable<?, ?>, PulsarContext> sharedInitialContexts = new ConcurrentHashMap();

    @Override
    public Context getInitialContext(Hashtable<?, ?> environment) throws NamingException {
        Objects.requireNonNull(environment);
        boolean shared = Boolean.parseBoolean(environment.get("jms.useSharedJNDIContext") + "");
        if (shared) {
            PulsarContext context = sharedInitialContexts.computeIfAbsent(environment, e -> {
                PulsarContext result = new PulsarContext((Hashtable)e);
                log.info("Creating shared JNDI {}", (Object)result);
                return result;
            });
            context.referenceCount.incrementAndGet();
            return context;
        }
        return new PulsarContext(environment);
    }

    static boolean releaseSharedContext(Hashtable environment, PulsarContext context) {
        return sharedInitialContexts.compute(environment, (e, current) -> {
            if (current == context) {
                int currentCount = context.referenceCount.decrementAndGet();
                if (currentCount == 0) {
                    log.info("Disposing shared JNDI {}", current);
                    return null;
                }
                return current;
            }
            return current;
        }) == null;
    }
}

