/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms.api;

import java.util.List;
import java.util.Map;

public abstract class JMSDestinationMetadata {
    private final String destination;

    public abstract boolean isQueue();

    public abstract boolean isTopic();

    public abstract boolean isVirtualDestination();

    protected JMSDestinationMetadata(String destination) {
        this.destination = destination;
    }

    public final String getDestination() {
        return this.destination;
    }

    public <T extends JMSDestinationMetadata> T unwrap(Class<T> clazz) {
        if (clazz.isInstance(this)) {
            return (T)this;
        }
        throw new IllegalArgumentException("A instance of " + this.getClass() + " cannot be converted to " + clazz);
    }

    public String toString() {
        return "JMSDestinationMetadata(destination=" + this.getDestination() + ")";
    }

    public static final class ProducerMetadata {
        private final String producerName;
        private String pulsarTopic;
        private Map<String, String> metadata;
        private boolean enablePriority;
        private boolean transacted;
        private String priorityMapping;
        private String address;
        private String clientVersion;

        public ProducerMetadata(String producerName) {
            this.producerName = producerName;
        }

        public String getPulsarTopic() {
            return this.pulsarTopic;
        }

        public Map<String, String> getMetadata() {
            return this.metadata;
        }

        public boolean isEnablePriority() {
            return this.enablePriority;
        }

        public boolean isTransacted() {
            return this.transacted;
        }

        public String getPriorityMapping() {
            return this.priorityMapping;
        }

        public String getAddress() {
            return this.address;
        }

        public String getClientVersion() {
            return this.clientVersion;
        }

        public void setPulsarTopic(String pulsarTopic) {
            this.pulsarTopic = pulsarTopic;
        }

        public void setMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
        }

        public void setEnablePriority(boolean enablePriority) {
            this.enablePriority = enablePriority;
        }

        public void setTransacted(boolean transacted) {
            this.transacted = transacted;
        }

        public void setPriorityMapping(String priorityMapping) {
            this.priorityMapping = priorityMapping;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public void setClientVersion(String clientVersion) {
            this.clientVersion = clientVersion;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProducerMetadata)) {
                return false;
            }
            ProducerMetadata other = (ProducerMetadata)o;
            if (this.isEnablePriority() != other.isEnablePriority()) {
                return false;
            }
            if (this.isTransacted() != other.isTransacted()) {
                return false;
            }
            String this$producerName = this.getProducerName();
            String other$producerName = other.getProducerName();
            if (this$producerName == null ? other$producerName != null : !this$producerName.equals(other$producerName)) {
                return false;
            }
            String this$pulsarTopic = this.getPulsarTopic();
            String other$pulsarTopic = other.getPulsarTopic();
            if (this$pulsarTopic == null ? other$pulsarTopic != null : !this$pulsarTopic.equals(other$pulsarTopic)) {
                return false;
            }
            Map<String, String> this$metadata = this.getMetadata();
            Map<String, String> other$metadata = other.getMetadata();
            if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
                return false;
            }
            String this$priorityMapping = this.getPriorityMapping();
            String other$priorityMapping = other.getPriorityMapping();
            if (this$priorityMapping == null ? other$priorityMapping != null : !this$priorityMapping.equals(other$priorityMapping)) {
                return false;
            }
            String this$address = this.getAddress();
            String other$address = other.getAddress();
            if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
                return false;
            }
            String this$clientVersion = this.getClientVersion();
            String other$clientVersion = other.getClientVersion();
            return !(this$clientVersion == null ? other$clientVersion != null : !this$clientVersion.equals(other$clientVersion));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnablePriority() ? 79 : 97);
            result = result * 59 + (this.isTransacted() ? 79 : 97);
            String $producerName = this.getProducerName();
            result = result * 59 + ($producerName == null ? 43 : $producerName.hashCode());
            String $pulsarTopic = this.getPulsarTopic();
            result = result * 59 + ($pulsarTopic == null ? 43 : $pulsarTopic.hashCode());
            Map<String, String> $metadata = this.getMetadata();
            result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
            String $priorityMapping = this.getPriorityMapping();
            result = result * 59 + ($priorityMapping == null ? 43 : $priorityMapping.hashCode());
            String $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : $address.hashCode());
            String $clientVersion = this.getClientVersion();
            result = result * 59 + ($clientVersion == null ? 43 : $clientVersion.hashCode());
            return result;
        }

        public String toString() {
            return "JMSDestinationMetadata.ProducerMetadata(producerName=" + this.getProducerName() + ", pulsarTopic=" + this.getPulsarTopic() + ", metadata=" + this.getMetadata() + ", enablePriority=" + this.isEnablePriority() + ", transacted=" + this.isTransacted() + ", priorityMapping=" + this.getPriorityMapping() + ", address=" + this.getAddress() + ", clientVersion=" + this.getClientVersion() + ")";
        }

        public String getProducerName() {
            return this.producerName;
        }
    }

    public static final class ConsumerMetadata {
        private final String consumerName;
        private String pulsarTopic;
        private String subscriptionName;
        private String acknowledgeMode;
        private Map<String, String> metadata;
        private boolean enableFilters;
        private boolean enablePriority;
        private String selector;
        private String address;
        private String clientVersion;

        public ConsumerMetadata(String consumerName) {
            this.consumerName = consumerName;
        }

        public String getPulsarTopic() {
            return this.pulsarTopic;
        }

        public String getSubscriptionName() {
            return this.subscriptionName;
        }

        public String getAcknowledgeMode() {
            return this.acknowledgeMode;
        }

        public Map<String, String> getMetadata() {
            return this.metadata;
        }

        public boolean isEnableFilters() {
            return this.enableFilters;
        }

        public boolean isEnablePriority() {
            return this.enablePriority;
        }

        public String getSelector() {
            return this.selector;
        }

        public String getAddress() {
            return this.address;
        }

        public String getClientVersion() {
            return this.clientVersion;
        }

        public void setPulsarTopic(String pulsarTopic) {
            this.pulsarTopic = pulsarTopic;
        }

        public void setSubscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
        }

        public void setAcknowledgeMode(String acknowledgeMode) {
            this.acknowledgeMode = acknowledgeMode;
        }

        public void setMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
        }

        public void setEnableFilters(boolean enableFilters) {
            this.enableFilters = enableFilters;
        }

        public void setEnablePriority(boolean enablePriority) {
            this.enablePriority = enablePriority;
        }

        public void setSelector(String selector) {
            this.selector = selector;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public void setClientVersion(String clientVersion) {
            this.clientVersion = clientVersion;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConsumerMetadata)) {
                return false;
            }
            ConsumerMetadata other = (ConsumerMetadata)o;
            if (this.isEnableFilters() != other.isEnableFilters()) {
                return false;
            }
            if (this.isEnablePriority() != other.isEnablePriority()) {
                return false;
            }
            String this$consumerName = this.getConsumerName();
            String other$consumerName = other.getConsumerName();
            if (this$consumerName == null ? other$consumerName != null : !this$consumerName.equals(other$consumerName)) {
                return false;
            }
            String this$pulsarTopic = this.getPulsarTopic();
            String other$pulsarTopic = other.getPulsarTopic();
            if (this$pulsarTopic == null ? other$pulsarTopic != null : !this$pulsarTopic.equals(other$pulsarTopic)) {
                return false;
            }
            String this$subscriptionName = this.getSubscriptionName();
            String other$subscriptionName = other.getSubscriptionName();
            if (this$subscriptionName == null ? other$subscriptionName != null : !this$subscriptionName.equals(other$subscriptionName)) {
                return false;
            }
            String this$acknowledgeMode = this.getAcknowledgeMode();
            String other$acknowledgeMode = other.getAcknowledgeMode();
            if (this$acknowledgeMode == null ? other$acknowledgeMode != null : !this$acknowledgeMode.equals(other$acknowledgeMode)) {
                return false;
            }
            Map<String, String> this$metadata = this.getMetadata();
            Map<String, String> other$metadata = other.getMetadata();
            if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
                return false;
            }
            String this$selector = this.getSelector();
            String other$selector = other.getSelector();
            if (this$selector == null ? other$selector != null : !this$selector.equals(other$selector)) {
                return false;
            }
            String this$address = this.getAddress();
            String other$address = other.getAddress();
            if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
                return false;
            }
            String this$clientVersion = this.getClientVersion();
            String other$clientVersion = other.getClientVersion();
            return !(this$clientVersion == null ? other$clientVersion != null : !this$clientVersion.equals(other$clientVersion));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnableFilters() ? 79 : 97);
            result = result * 59 + (this.isEnablePriority() ? 79 : 97);
            String $consumerName = this.getConsumerName();
            result = result * 59 + ($consumerName == null ? 43 : $consumerName.hashCode());
            String $pulsarTopic = this.getPulsarTopic();
            result = result * 59 + ($pulsarTopic == null ? 43 : $pulsarTopic.hashCode());
            String $subscriptionName = this.getSubscriptionName();
            result = result * 59 + ($subscriptionName == null ? 43 : $subscriptionName.hashCode());
            String $acknowledgeMode = this.getAcknowledgeMode();
            result = result * 59 + ($acknowledgeMode == null ? 43 : $acknowledgeMode.hashCode());
            Map<String, String> $metadata = this.getMetadata();
            result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
            String $selector = this.getSelector();
            result = result * 59 + ($selector == null ? 43 : $selector.hashCode());
            String $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : $address.hashCode());
            String $clientVersion = this.getClientVersion();
            result = result * 59 + ($clientVersion == null ? 43 : $clientVersion.hashCode());
            return result;
        }

        public String toString() {
            return "JMSDestinationMetadata.ConsumerMetadata(consumerName=" + this.getConsumerName() + ", pulsarTopic=" + this.getPulsarTopic() + ", subscriptionName=" + this.getSubscriptionName() + ", acknowledgeMode=" + this.getAcknowledgeMode() + ", metadata=" + this.getMetadata() + ", enableFilters=" + this.isEnableFilters() + ", enablePriority=" + this.isEnablePriority() + ", selector=" + this.getSelector() + ", address=" + this.getAddress() + ", clientVersion=" + this.getClientVersion() + ")";
        }

        public String getConsumerName() {
            return this.consumerName;
        }
    }

    public static final class SubscriptionMetadata {
        private final String subscriptionName;
        private Map<String, String> subscriptionProperties;
        private boolean enableFilters;
        private String selector;
        private List<ConsumerMetadata> consumers;

        public SubscriptionMetadata(String subscriptionName) {
            this.subscriptionName = subscriptionName;
        }

        public String getSubscriptionName() {
            return this.subscriptionName;
        }

        public Map<String, String> getSubscriptionProperties() {
            return this.subscriptionProperties;
        }

        public boolean isEnableFilters() {
            return this.enableFilters;
        }

        public String getSelector() {
            return this.selector;
        }

        public List<ConsumerMetadata> getConsumers() {
            return this.consumers;
        }

        public void setSubscriptionProperties(Map<String, String> subscriptionProperties) {
            this.subscriptionProperties = subscriptionProperties;
        }

        public void setEnableFilters(boolean enableFilters) {
            this.enableFilters = enableFilters;
        }

        public void setSelector(String selector) {
            this.selector = selector;
        }

        public void setConsumers(List<ConsumerMetadata> consumers) {
            this.consumers = consumers;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SubscriptionMetadata)) {
                return false;
            }
            SubscriptionMetadata other = (SubscriptionMetadata)o;
            if (this.isEnableFilters() != other.isEnableFilters()) {
                return false;
            }
            String this$subscriptionName = this.getSubscriptionName();
            String other$subscriptionName = other.getSubscriptionName();
            if (this$subscriptionName == null ? other$subscriptionName != null : !this$subscriptionName.equals(other$subscriptionName)) {
                return false;
            }
            Map<String, String> this$subscriptionProperties = this.getSubscriptionProperties();
            Map<String, String> other$subscriptionProperties = other.getSubscriptionProperties();
            if (this$subscriptionProperties == null ? other$subscriptionProperties != null : !((Object)this$subscriptionProperties).equals(other$subscriptionProperties)) {
                return false;
            }
            String this$selector = this.getSelector();
            String other$selector = other.getSelector();
            if (this$selector == null ? other$selector != null : !this$selector.equals(other$selector)) {
                return false;
            }
            List<ConsumerMetadata> this$consumers = this.getConsumers();
            List<ConsumerMetadata> other$consumers = other.getConsumers();
            return !(this$consumers == null ? other$consumers != null : !((Object)this$consumers).equals(other$consumers));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnableFilters() ? 79 : 97);
            String $subscriptionName = this.getSubscriptionName();
            result = result * 59 + ($subscriptionName == null ? 43 : $subscriptionName.hashCode());
            Map<String, String> $subscriptionProperties = this.getSubscriptionProperties();
            result = result * 59 + ($subscriptionProperties == null ? 43 : ((Object)$subscriptionProperties).hashCode());
            String $selector = this.getSelector();
            result = result * 59 + ($selector == null ? 43 : $selector.hashCode());
            List<ConsumerMetadata> $consumers = this.getConsumers();
            result = result * 59 + ($consumers == null ? 43 : ((Object)$consumers).hashCode());
            return result;
        }

        public String toString() {
            return "JMSDestinationMetadata.SubscriptionMetadata(subscriptionName=" + this.getSubscriptionName() + ", subscriptionProperties=" + this.getSubscriptionProperties() + ", enableFilters=" + this.isEnableFilters() + ", selector=" + this.getSelector() + ", consumers=" + this.getConsumers() + ")";
        }
    }

    public static final class VirtualDestinationMetadata
    extends JMSDestinationMetadata {
        private final boolean multiTopic;
        private final boolean regex;
        private final boolean queue;
        private final List<JMSDestinationMetadata> destinations;

        public VirtualDestinationMetadata(String destination, boolean queue, boolean multiTopic, boolean regex, List<JMSDestinationMetadata> destinations) {
            super(destination);
            this.destinations = destinations;
            this.queue = queue;
            this.regex = regex;
            this.multiTopic = multiTopic;
        }

        public boolean isRegex() {
            return this.regex;
        }

        public boolean isMultiTopic() {
            return this.multiTopic;
        }

        public List<JMSDestinationMetadata> getDestinations() {
            return this.destinations;
        }

        @Override
        public boolean isQueue() {
            return this.queue;
        }

        @Override
        public boolean isTopic() {
            return !this.queue;
        }

        @Override
        public boolean isVirtualDestination() {
            return true;
        }

        @Override
        public String toString() {
            return "JMSDestinationMetadata.VirtualDestinationMetadata(multiTopic=" + this.isMultiTopic() + ", regex=" + this.isRegex() + ", queue=" + this.isQueue() + ", destinations=" + this.getDestinations() + ")";
        }
    }

    public static final class QueueMetadata
    extends PhysicalPulsarTopicMetadata {
        private final String queueSubscription;
        private final boolean queueSubscriptionExists;
        private final SubscriptionMetadata subscriptionMetadata;

        public QueueMetadata(String destination, boolean exists, String pulsarTopic, List<ProducerMetadata> producers, int partitions, String queueSubscription, boolean queueSubscriptionExists, SubscriptionMetadata subscriptionMetadata) {
            super(destination, exists, pulsarTopic, producers, partitions);
            this.queueSubscription = queueSubscription;
            this.queueSubscriptionExists = queueSubscriptionExists;
            this.subscriptionMetadata = subscriptionMetadata;
        }

        public boolean isQueueSubscriptionExists() {
            return this.queueSubscriptionExists;
        }

        public String getQueueSubscription() {
            return this.queueSubscription;
        }

        public SubscriptionMetadata getSubscriptionMetadata() {
            return this.subscriptionMetadata;
        }

        @Override
        public boolean isQueue() {
            return true;
        }

        @Override
        public boolean isTopic() {
            return false;
        }

        @Override
        public String toString() {
            return "JMSDestinationMetadata.QueueMetadata(queueSubscription=" + this.getQueueSubscription() + ", queueSubscriptionExists=" + this.isQueueSubscriptionExists() + ", subscriptionMetadata=" + this.getSubscriptionMetadata() + ")";
        }
    }

    public static final class TopicMetadata
    extends PhysicalPulsarTopicMetadata {
        private final List<SubscriptionMetadata> subscriptions;

        public TopicMetadata(String destination, boolean exists, String pulsarTopic, List<ProducerMetadata> producers, int partitions, List<SubscriptionMetadata> subscriptions) {
            super(destination, exists, pulsarTopic, producers, partitions);
            this.subscriptions = subscriptions;
        }

        public List<SubscriptionMetadata> getSubscriptions() {
            return this.subscriptions;
        }

        @Override
        public boolean isQueue() {
            return false;
        }

        @Override
        public boolean isTopic() {
            return true;
        }

        @Override
        public String toString() {
            return "JMSDestinationMetadata.TopicMetadata(subscriptions=" + this.getSubscriptions() + ")";
        }
    }

    public static abstract class PhysicalPulsarTopicMetadata
    extends JMSDestinationMetadata {
        private final boolean exists;
        private final String pulsarTopic;
        private final List<ProducerMetadata> producers;
        private final int partitions;

        public PhysicalPulsarTopicMetadata(String destination, boolean exists, String pulsarTopic, List<ProducerMetadata> producers, int partitions) {
            super(destination);
            this.exists = exists;
            this.pulsarTopic = pulsarTopic;
            this.producers = producers;
            this.partitions = partitions;
        }

        public boolean isPartitioned() {
            return this.partitions > 0;
        }

        public String getPulsarTopic() {
            return this.pulsarTopic;
        }

        public boolean isExists() {
            return this.exists;
        }

        public int getPartitions() {
            return this.partitions;
        }

        public List<ProducerMetadata> getProducers() {
            return this.producers;
        }

        @Override
        public boolean isVirtualDestination() {
            return false;
        }

        @Override
        public String toString() {
            return "JMSDestinationMetadata.PhysicalPulsarTopicMetadata(exists=" + this.isExists() + ", pulsarTopic=" + this.getPulsarTopic() + ", producers=" + this.getProducers() + ", partitions=" + this.getPartitions() + ")";
        }
    }
}

