/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms;

import com.datastax.oss.pulsar.jms.ConsumerConfiguration;
import com.datastax.oss.pulsar.jms.PulsarDestination;
import com.datastax.oss.pulsar.jms.PulsarMessageConsumer;
import com.datastax.oss.pulsar.jms.PulsarMessageProducer;
import com.datastax.oss.pulsar.jms.PulsarSession;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.MessageId;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.MessageIdAdv;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import javax.jms.IllegalStateRuntimeException;
import javax.jms.InvalidClientIDException;
import javax.jms.InvalidClientIDRuntimeException;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidDestinationRuntimeException;
import javax.jms.InvalidSelectorException;
import javax.jms.InvalidSelectorRuntimeException;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.JMSSecurityException;
import javax.jms.JMSSecurityRuntimeException;
import javax.jms.MessageFormatException;
import javax.jms.MessageFormatRuntimeException;
import javax.jms.MessageNotWriteableException;
import javax.jms.MessageNotWriteableRuntimeException;
import javax.jms.TransactionRolledBackException;
import javax.jms.TransactionRolledBackRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);
    private static ThreadLocal<CallbackContext> currentSession = new ThreadLocal();

    private Utils() {
    }

    public static JMSException handleException(Throwable cause) {
        while (cause instanceof CompletionException) {
            cause = cause.getCause();
        }
        if (cause instanceof JMSException) {
            return (JMSException)cause;
        }
        if (cause instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        if (cause instanceof ClassCastException) {
            return (JMSException)new MessageFormatException("Invalid cast " + cause.getMessage()).initCause(cause);
        }
        if (cause instanceof NumberFormatException) {
            return (JMSException)new MessageFormatException("Invalid conversion " + cause.getMessage()).initCause(cause);
        }
        JMSException err = new JMSException(cause + "");
        err.initCause(cause);
        if (cause instanceof Exception) {
            err.setLinkedException((Exception)cause);
        } else {
            err.setLinkedException(new Exception(cause));
        }
        return err;
    }

    public static <T> T get(CompletableFuture<T> future) throws JMSException {
        try {
            return future.get();
        }
        catch (ExecutionException err) {
            throw Utils.handleException(err.getCause());
        }
        catch (InterruptedException err) {
            throw Utils.handleException(err);
        }
    }

    public static <T> T invoke(SupplierWithException<T> code) throws JMSException {
        try {
            return code.run();
        }
        catch (Throwable err) {
            throw Utils.handleException(err);
        }
    }

    public static void invoke(RunnableWithException code) throws JMSException {
        try {
            code.run();
        }
        catch (Throwable err) {
            throw Utils.handleException(err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean executeMessageListenerInSessionContext(PulsarSession session, PulsarMessageConsumer consumer, BooleanSupplier code) {
        currentSession.set(new CallbackContext(session, consumer, null));
        try {
            boolean bl = session.executeCriticalOperation(() -> code.getAsBoolean());
            return bl;
        }
        catch (javax.jms.IllegalStateException err) {
            log.debug("Ignore error in listener", err);
            boolean bl = false;
            return bl;
        }
        catch (JMSException err) {
            log.error("Unexpected error in listener", err);
            boolean bl = false;
            return bl;
        }
        finally {
            currentSession.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeCompletionListenerInSessionContext(PulsarSession session, PulsarMessageProducer producer, Runnable code) {
        currentSession.set(new CallbackContext(session, null, producer));
        try {
            session.executeCriticalOperation(() -> {
                code.run();
                return null;
            });
        }
        catch (javax.jms.IllegalStateException err) {
            log.debug("Ignore error in listener", err);
        }
        catch (JMSException err) {
            log.error("Unexpected error in listener", err);
        }
        finally {
            currentSession.remove();
        }
    }

    public static boolean isOnMessageListener(PulsarSession session, PulsarMessageConsumer consumer) {
        CallbackContext current = currentSession.get();
        return current != null && current.session == session && current.consumer == consumer;
    }

    public static void checkNotOnMessageListener(PulsarSession session) throws JMSException {
        CallbackContext current = currentSession.get();
        if (current != null && current.session == session && current.consumer != null) {
            throw new javax.jms.IllegalStateException("Cannot call this method inside a listener");
        }
    }

    public static void checkNotOnSessionCallback(PulsarSession session) throws JMSException {
        CallbackContext current = currentSession.get();
        if (current != null && current.session == session) {
            throw new javax.jms.IllegalStateException("Cannot call this method inside a callback");
        }
    }

    public static void checkNotOnMessageProducer(PulsarSession session, PulsarMessageProducer producer) throws JMSException {
        CallbackContext current = currentSession.get();
        if (current != null && current.session == session && (producer != null && current.producer == producer || producer == null && current.producer != null)) {
            throw new javax.jms.IllegalStateException("Cannot call this method inside a CompletionListener");
        }
    }

    public static void noException(RunnableWithException run) {
        try {
            run.run();
        }
        catch (Exception err) {
            if (err instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new RuntimeException(err);
        }
    }

    public static <T> T noException(SupplierWithException<T> run) {
        try {
            return run.run();
        }
        catch (Exception err) {
            if (err instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new RuntimeException(err);
        }
    }

    public static <T> T runtimeException(SupplierWithException<T> run) {
        try {
            return run.run();
        }
        catch (Exception err) {
            if (err instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            Utils.throwAsRuntimeException(err);
            return null;
        }
    }

    public static void runtimeException(RunnableWithException run) {
        try {
            run.run();
        }
        catch (Exception err) {
            if (err instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            Utils.throwAsRuntimeException(err);
        }
    }

    private static void throwAsRuntimeException(Exception err) {
        if (err instanceof NumberFormatException) {
            throw (MessageFormatRuntimeException)new MessageFormatRuntimeException("Illegal value: " + err.getMessage()).initCause(err);
        }
        if (err instanceof javax.jms.IllegalStateException) {
            javax.jms.IllegalStateException jmsException = (javax.jms.IllegalStateException)err;
            throw new IllegalStateRuntimeException(jmsException.getMessage(), jmsException.getErrorCode(), err);
        }
        if (err instanceof TransactionRolledBackException) {
            TransactionRolledBackException jmsException = (TransactionRolledBackException)err;
            throw new TransactionRolledBackRuntimeException(jmsException.getMessage(), jmsException.getErrorCode(), err);
        }
        if (err instanceof InvalidDestinationException) {
            InvalidDestinationException jmsException = (InvalidDestinationException)err;
            throw new InvalidDestinationRuntimeException(jmsException.getMessage(), jmsException.getErrorCode(), err);
        }
        if (err instanceof InvalidClientIDException) {
            InvalidClientIDException jmsException = (InvalidClientIDException)err;
            throw new InvalidClientIDRuntimeException(jmsException.getMessage(), jmsException.getErrorCode(), err);
        }
        if (err instanceof InvalidSelectorException) {
            InvalidSelectorException jmsException = (InvalidSelectorException)err;
            throw new InvalidSelectorRuntimeException(jmsException.getMessage(), jmsException.getErrorCode(), err);
        }
        if (err instanceof MessageFormatException) {
            MessageFormatException jmsException = (MessageFormatException)err;
            throw new MessageFormatRuntimeException(jmsException.getMessage(), jmsException.getErrorCode(), err);
        }
        if (err instanceof MessageNotWriteableException) {
            MessageNotWriteableException jmsException = (MessageNotWriteableException)err;
            throw new MessageNotWriteableRuntimeException(jmsException.getMessage(), jmsException.getErrorCode(), err);
        }
        if (err instanceof JMSSecurityException) {
            JMSSecurityException jmsException = (JMSSecurityException)err;
            throw new JMSSecurityRuntimeException(jmsException.getMessage(), jmsException.getErrorCode(), err);
        }
        if (err instanceof JMSException) {
            JMSException jmsException = (JMSException)err;
            throw new JMSRuntimeException(jmsException.getMessage(), jmsException.getErrorCode(), err);
        }
        JMSRuntimeException jms = new JMSRuntimeException("Generic error " + err.getMessage());
        jms.initCause(err);
        throw jms;
    }

    private static List deepCopyList(List configuration) {
        return configuration.stream().map(f -> Utils.deepCopyObject(f)).collect(Collectors.toList());
    }

    private static Set deepCopySet(Set configuration) {
        return configuration.stream().map(f -> Utils.deepCopyObject(f)).collect(Collectors.toSet());
    }

    public static Object deepCopyObject(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Map) {
            return Utils.deepCopyMap((Map)value);
        }
        if (value instanceof List) {
            return Utils.deepCopyList((List)value);
        }
        if (value instanceof Set) {
            return Utils.deepCopySet((Set)value);
        }
        return value;
    }

    public static Map<String, Object> deepCopyMap(Map<String, Object> configuration) {
        if (configuration == null) {
            return null;
        }
        HashMap<String, Object> copy = new HashMap<String, Object>();
        configuration.forEach((key, value) -> copy.put((String)key, Utils.deepCopyObject(value)));
        return copy;
    }

    public static String getAndRemoveString(String name, String defaultValue, Map<String, Object> properties) {
        Object value = properties.remove(name);
        return value != null ? value.toString() : defaultValue;
    }

    public static boolean sameEntryId(MessageId a, MessageId b) {
        MessageIdAdv a1 = (MessageIdAdv)a;
        MessageIdAdv b1 = (MessageIdAdv)b;
        return a1.getLedgerId() == b1.getLedgerId() && a1.getEntryId() == b1.getEntryId();
    }

    public static int mapPriorityToPartition(int priority, int numPartitions, boolean linear) {
        if (linear) {
            return Utils.mapPriorityToPartitionLinearly(priority, numPartitions);
        }
        return Utils.mapPriorityToPartitionNonLinearly(priority, numPartitions);
    }

    static int mapPriorityToPartitionLinearly(int priority, int numPartitions) {
        if (numPartitions <= 1) {
            return 0;
        }
        if (numPartitions == 2) {
            if (priority <= 4) {
                return 0;
            }
            return 1;
        }
        if (numPartitions == 3) {
            if (priority < 4) {
                return 0;
            }
            if (priority == 4) {
                return 1;
            }
            return 2;
        }
        if (priority < 0) {
            priority = 0;
        } else if (priority > 9) {
            priority = 9;
        }
        double bucketSize = (double)numPartitions / 10.0;
        double start = Math.floor(bucketSize * (double)priority);
        double value = start + ThreadLocalRandom.current().nextDouble(bucketSize);
        int result = (int)Math.floor(value);
        if (result >= numPartitions) {
            return numPartitions - 1;
        }
        return result;
    }

    static int mapPriorityToPartitionNonLinearly(int priority, int numPartitions) {
        double value;
        int result;
        int slots;
        double bucketStart;
        if (numPartitions <= 1) {
            return 0;
        }
        if (priority < 0) {
            priority = 0;
        } else if (priority > 9) {
            priority = 9;
        }
        double bucketSize = (double)numPartitions / 4.0;
        if (bucketSize <= 0.0) {
            bucketSize = 1.0;
        }
        switch (priority) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                bucketStart = 0.0;
                slots = 1;
                if (numPartitions > 3) break;
                return 0;
            }
            case 4: {
                bucketStart = Math.ceil(bucketSize);
                if (numPartitions <= 2) {
                    return 0;
                }
                if (numPartitions == 3) {
                    return 1;
                }
                slots = 2;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                if (numPartitions <= 3) {
                    return numPartitions - 1;
                }
                bucketStart = Math.ceil(bucketSize * 3.0);
                slots = 1;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if ((result = (int)Math.floor(value = bucketStart + ThreadLocalRandom.current().nextDouble(bucketSize * (double)slots))) >= numPartitions) {
            return numPartitions - 1;
        }
        return result;
    }

    public static Map<String, Object> buildConfigurationOverride(PulsarDestination destination) throws InvalidDestinationException {
        String queryString = destination.getQueryString();
        if (queryString == null || queryString.isEmpty()) {
            return null;
        }
        try {
            String[] split = queryString.split("&");
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (String s2 : split) {
                String value;
                String key;
                int equals = s2.indexOf("=");
                if (equals >= 0) {
                    key = URLDecoder.decode(s2.substring(0, equals), "UTF-8");
                    value = URLDecoder.decode(s2.substring(equals + 1), "UTF-8");
                } else {
                    key = URLDecoder.decode(s2, "UTF-8");
                    value = "";
                }
                String[] path = key.split("\\.");
                Utils.putHierichical(path, value, result, 0);
            }
            if (result.isEmpty()) {
                return null;
            }
            return result;
        }
        catch (UnsupportedEncodingException impossible) {
            throw new RuntimeException(impossible);
        }
    }

    private static void putHierichical(String[] path, String value, Map<String, Object> result, int pos) throws InvalidDestinationException {
        String key = path[pos];
        if (pos == path.length - 1) {
            result.put(key, value);
            return;
        }
        HashMap current = result.get(key);
        if (current == null) {
            current = new HashMap();
            result.put(key, current);
        } else if (!(current instanceof Map)) {
            throw new InvalidDestinationException("Cannot build a configuration out of the destination query string");
        }
        Map subMap = current;
        Utils.putHierichical(path, value, subMap, pos + 1);
    }

    public static ConsumerConfiguration computeConsumerOverrideConfiguration(PulsarDestination destination) throws InvalidDestinationException {
        Map<String, Object> result = Utils.buildConfigurationOverride(destination);
        Map consumerConfig = result != null ? (Map)result.get("consumerConfig") : null;
        return ConsumerConfiguration.buildConsumerConfiguration(consumerConfig);
    }

    public static interface SupplierWithException<T> {
        public T run() throws Exception;
    }

    public static interface RunnableWithException {
        public void run() throws Exception;
    }

    private static class CallbackContext {
        final PulsarSession session;
        final PulsarMessageConsumer consumer;
        final PulsarMessageProducer producer;

        private CallbackContext(PulsarSession session, PulsarMessageConsumer consumer, PulsarMessageProducer producer) {
            this.session = session;
            this.consumer = consumer;
            this.producer = producer;
        }
    }
}

