/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms;

import com.datastax.oss.pulsar.jms.Utils;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.PulsarClient;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.LookupService;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.PulsarClientImpl;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.api.proto.CommandGetTopicsOfNamespace;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.naming.NamespaceName;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.naming.TopicName;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.jms.JMSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicDiscoveryUtils {
    private static final Logger log = LoggerFactory.getLogger(TopicDiscoveryUtils.class);

    public static List<String> discoverTopicsByPattern(String regex, PulsarClient client, int timeout) throws JMSException {
        TopicName destination = TopicName.get(regex);
        NamespaceName namespaceName = destination.getNamespaceObject();
        LookupService lookup = ((PulsarClientImpl)client).getLookup();
        try {
            List<String> list = lookup.getTopicsUnderNamespace(namespaceName, CommandGetTopicsOfNamespace.Mode.PERSISTENT, null, null).get(timeout, TimeUnit.MILLISECONDS).getTopics();
            return TopicDiscoveryUtils.topicsPatternFilter(list, Pattern.compile(regex));
        }
        catch (InterruptedException | ExecutionException | TimeoutException err) {
            throw Utils.handleException(err);
        }
    }

    public static List<String> topicsPatternFilter(List<String> original, Pattern topicsPattern) {
        Pattern shortenedTopicsPattern = topicsPattern.toString().contains("://") ? Pattern.compile(topicsPattern.toString().split("\\:\\/\\/")[1]) : topicsPattern;
        return original.stream().map(TopicName::get).map(TopicName::toString).filter(topic -> shortenedTopicsPattern.matcher(topic.split("\\:\\/\\/")[1]).matches()).collect(Collectors.toList());
    }
}

