/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms;

import com.datastax.oss.pulsar.jms.PulsarDestination;
import com.datastax.oss.pulsar.jms.PulsarSession;
import com.datastax.oss.pulsar.jms.Utils;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.admin.PulsarAdminException;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.TopicStats;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class PulsarTemporaryDestination
extends PulsarDestination {
    private static final Logger log = LoggerFactory.getLogger(PulsarTemporaryDestination.class);
    private final PulsarSession session;

    public PulsarTemporaryDestination(String topicName, PulsarSession session) throws InvalidDestinationException {
        super(topicName);
        this.session = session;
        if (this.isVirtualDestination()) {
            throw new InvalidDestinationException("Temporary destinations cannot be virtual");
        }
    }

    public PulsarSession getSession() {
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void delete() throws JMSException {
        try {
            log.info("Deleting {}", (Object)this);
            String topicName = this.getInternalTopicName();
            String fullQualifiedTopicName = this.session.getFactory().applySystemNamespace(topicName);
            TopicStats stats = this.session.getFactory().getPulsarAdmin().topics().getStats(fullQualifiedTopicName);
            log.info("Stats {}", (Object)stats);
            int numConsumers = stats.getSubscriptions().values().stream().mapToInt(s2 -> s2.getConsumers().size()).sum();
            if (numConsumers > 0) {
                throw new JMSException("Cannot delete a temporary destination with active consumers");
            }
            if (this.session.getFactory().getPulsarAdmin().topics().getPartitionedTopicList(this.session.getFactory().getSystemNamespace()).stream().anyMatch(t -> t.equals(fullQualifiedTopicName))) {
                this.session.getFactory().getPulsarAdmin().topics().deletePartitionedTopic(fullQualifiedTopicName, this.session.getFactory().isForceDeleteTemporaryDestinations());
            } else {
                this.session.getFactory().getPulsarAdmin().topics().delete(fullQualifiedTopicName, this.session.getFactory().isForceDeleteTemporaryDestinations());
            }
        }
        catch (PulsarAdminException paEx) {
            Utils.handleException(paEx);
        }
        finally {
            this.session.getConnection().removeTemporaryDestination(this);
        }
    }
}

