/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms;

import com.datastax.oss.pulsar.jms.CompositeEnumeration;
import com.datastax.oss.pulsar.jms.PulsarDestination;
import com.datastax.oss.pulsar.jms.PulsarMessage;
import com.datastax.oss.pulsar.jms.PulsarSession;
import com.datastax.oss.pulsar.jms.Utils;
import com.datastax.oss.pulsar.jms.selectors.SelectorSupport;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.Reader;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.SubscriptionMode;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PulsarQueueBrowser
implements QueueBrowser {
    private static final Logger log = LoggerFactory.getLogger(PulsarQueueBrowser.class);
    private static final int BROWSER_READ_TIMEOUT = 1000;
    private final PulsarSession session;
    private final Queue queue;
    private final String subscriptionName;
    private final List<Reader<?>> readers;
    private final SelectorSupport selectorSupport;
    private final Map<String, SelectorSupport> selectorSupportOnSubscriptions = new HashMap<String, SelectorSupport>();
    private final boolean useServerSideFiltering;

    public PulsarQueueBrowser(PulsarSession session, Queue queue, String selector) throws JMSException {
        session.checkNotClosed();
        this.session = session;
        this.useServerSideFiltering = session.getFactory().isUseServerSideFiltering();
        this.queue = queue;
        this.readers = session.getFactory().createReadersForBrowser((PulsarDestination)((Object)this.queue), session.getOverrideConsumerConfiguration());
        log.info("created {} readers for {}", (Object)this.readers.size(), (Object)this.queue);
        this.selectorSupport = SelectorSupport.build(selector, true);
        this.subscriptionName = session.getFactory().getQueueSubscriptionName((PulsarDestination)((Object)this.queue));
    }

    @Override
    public Queue getQueue() throws JMSException {
        return this.queue;
    }

    @Override
    public String getMessageSelector() throws JMSException {
        String selector = this.internalGetMessageSelector();
        String selectorOnSubscription = this.internalGetMessageSelectorFromSubscription();
        if (selectorOnSubscription == null) {
            return selector;
        }
        if (selector == null) {
            return selectorOnSubscription;
        }
        return "(" + selectorOnSubscription + ") AND (" + selector + ")";
    }

    private synchronized String internalGetMessageSelector() {
        return this.selectorSupport != null ? this.selectorSupport.getSelector() : null;
    }

    private synchronized String internalGetMessageSelectorFromSubscription() {
        if (!this.useServerSideFiltering || this.selectorSupportOnSubscriptions.isEmpty()) {
            return null;
        }
        SelectorSupport next = this.selectorSupportOnSubscriptions.values().iterator().next();
        return next != null ? next.getSelector() : null;
    }

    public synchronized SelectorSupport getSelectorSupportOnSubscription(String topicName) throws JMSException {
        if (!this.useServerSideFiltering) {
            return null;
        }
        if (!this.selectorSupportOnSubscriptions.containsKey(topicName)) {
            String selector = this.session.getFactory().downloadServerSideFilter(topicName, this.subscriptionName, SubscriptionMode.Durable);
            this.selectorSupportOnSubscriptions.put(topicName, SelectorSupport.build(selector, true));
        }
        return this.selectorSupportOnSubscriptions.get(topicName);
    }

    @Override
    public Enumeration getEnumeration() throws JMSException {
        if (this.readers.size() == 1) {
            return new MessageEnumeration(this.readers.get(0));
        }
        List enumerations = this.readers.stream().map(x$0 -> new MessageEnumeration((Reader)x$0)).collect(Collectors.toList());
        return new CompositeEnumeration(enumerations);
    }

    @Override
    public void close() throws JMSException {
        for (Reader<?> reader : this.readers) {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        this.session.removeBrowser(this);
        for (Reader<?> reader : this.readers) {
            this.session.getFactory().removeReader(reader);
        }
    }

    private class MessageEnumeration
    implements Enumeration {
        private final Reader reader;
        PulsarMessage nextMessage;
        boolean finished;

        public MessageEnumeration(Reader reader) {
            this.reader = reader;
        }

        @Override
        public boolean hasMoreElements() {
            this.ensureNext();
            return !this.finished;
        }

        public Object nextElement() {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            PulsarMessage res = this.nextMessage;
            this.nextMessage = null;
            return res;
        }

        private void ensureNext() {
            Utils.runtimeException(() -> {
                while (!this.finished && this.nextMessage == null) {
                    if (!this.reader.hasMessageAvailable()) {
                        this.finished = true;
                        return;
                    }
                    this.nextMessage = PulsarMessage.decode(null, null, this.reader.readNext(1000, TimeUnit.MILLISECONDS));
                    if (this.nextMessage == null) {
                        this.finished = true;
                        return;
                    }
                    if (PulsarQueueBrowser.this.selectorSupport != null && !PulsarQueueBrowser.this.selectorSupport.matches(this.nextMessage)) {
                        log.debug("skip non matching message {}", (Object)this.nextMessage);
                        this.nextMessage = null;
                        continue;
                    }
                    SelectorSupport selectorSupportOnSubscription = PulsarQueueBrowser.this.getSelectorSupportOnSubscription(this.nextMessage.getReceivedPulsarMessage().getTopicName());
                    if (selectorSupportOnSubscription != null && !selectorSupportOnSubscription.matches(this.nextMessage)) {
                        log.debug("skip non matching message {}", (Object)this.nextMessage);
                        this.nextMessage = null;
                        continue;
                    }
                    return;
                }
            });
        }
    }
}

