/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms;

import com.datastax.oss.pulsar.jms.PulsarDestination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Queue;

public final class PulsarQueue
extends PulsarDestination
implements Queue {
    public PulsarQueue() {
        this("unnamed");
    }

    public PulsarQueue(String topicName) {
        super(topicName);
    }

    @Override
    public String getQueueName() throws JMSException {
        return this.topicName;
    }

    @Override
    public boolean isQueue() {
        return true;
    }

    @Override
    public PulsarDestination createSameType(String topicName) throws InvalidDestinationException {
        return new PulsarQueue(topicName);
    }

    @Override
    public boolean isTopic() {
        return false;
    }

    @Override
    public String toString() {
        return "Queue{" + this.topicName + "}";
    }

    @Override
    public String extractSubscriptionName() throws InvalidDestinationException {
        int pos;
        int lastSlash;
        int endSchema;
        String shortTopicName = this.topicName;
        if (shortTopicName.startsWith("multi:")) {
            shortTopicName = shortTopicName.substring("multi:".length());
        }
        if (shortTopicName.startsWith("regex:")) {
            shortTopicName = shortTopicName.substring("regex:".length());
        }
        if ((endSchema = shortTopicName.indexOf("://")) > 0) {
            shortTopicName = shortTopicName.substring(endSchema + 3);
        }
        if ((lastSlash = shortTopicName.lastIndexOf(47)) > 0) {
            shortTopicName = shortTopicName.substring(lastSlash + 1);
        }
        if ((pos = shortTopicName.lastIndexOf(":")) < 0) {
            return null;
        }
        String subscriptionName = shortTopicName.substring(pos + 1);
        if (subscriptionName.isEmpty()) {
            throw new InvalidDestinationException("Subscription name cannot be empty");
        }
        return subscriptionName;
    }

    @Override
    public String getInternalTopicName() {
        int pos;
        String topicName = this.topicName;
        if (topicName.startsWith("regex:")) {
            topicName = topicName.substring("regex:".length());
        }
        if (topicName.startsWith("multi:")) {
            topicName = topicName.substring("multi:".length());
        }
        if ((pos = topicName.lastIndexOf(":")) < 0) {
            return topicName;
        }
        int slash = topicName.lastIndexOf("/");
        if (slash < 0 || slash < pos) {
            return topicName.substring(0, pos);
        }
        return topicName;
    }
}

