/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms;

import com.datastax.oss.pulsar.jms.PulsarMessageConsumer;
import com.datastax.oss.pulsar.jms.Utils;
import javax.jms.JMSConsumer;
import javax.jms.JMSRuntimeException;
import javax.jms.Message;
import javax.jms.MessageListener;

public class PulsarJMSConsumer
implements JMSConsumer {
    private final PulsarMessageConsumer pulsarMessageConsumer;

    public PulsarJMSConsumer(PulsarMessageConsumer pulsarMessageConsumer) {
        this.pulsarMessageConsumer = pulsarMessageConsumer;
    }

    public PulsarMessageConsumer asPulsarMessageConsumer() {
        return this.pulsarMessageConsumer;
    }

    @Override
    public String getMessageSelector() {
        return Utils.runtimeException(() -> this.pulsarMessageConsumer.getMessageSelector());
    }

    @Override
    public MessageListener getMessageListener() throws JMSRuntimeException {
        return Utils.runtimeException(() -> this.pulsarMessageConsumer.getMessageListener());
    }

    @Override
    public void setMessageListener(MessageListener listener) throws JMSRuntimeException {
        Utils.runtimeException(() -> this.pulsarMessageConsumer.setMessageListener(listener));
    }

    @Override
    public Message receive() {
        return Utils.runtimeException(() -> this.pulsarMessageConsumer.receive());
    }

    @Override
    public Message receive(long timeout) {
        return Utils.runtimeException(() -> this.pulsarMessageConsumer.receive(timeout));
    }

    @Override
    public Message receiveNoWait() {
        return Utils.runtimeException(() -> this.pulsarMessageConsumer.receiveNoWait());
    }

    @Override
    public void close() {
        Utils.runtimeException(() -> this.pulsarMessageConsumer.close());
    }

    @Override
    public <T> T receiveBody(Class<T> c) {
        return (T)Utils.runtimeException(() -> {
            Message msg = this.pulsarMessageConsumer.receiveWithTimeoutAndValidateType(Long.MAX_VALUE, c);
            return msg == null ? null : msg.getBody(c);
        });
    }

    @Override
    public <T> T receiveBody(Class<T> c, long timeout) {
        return (T)Utils.runtimeException(() -> {
            Message msg = this.pulsarMessageConsumer.receiveWithTimeoutAndValidateType(timeout, c);
            return msg == null ? null : msg.getBody(c);
        });
    }

    @Override
    public <T> T receiveBodyNoWait(Class<T> c) {
        return (T)Utils.runtimeException(() -> {
            Message msg = this.pulsarMessageConsumer.receiveWithTimeoutAndValidateType(1L, c);
            return msg == null ? null : msg.getBody(c);
        });
    }
}

