/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms;

import com.datastax.oss.pulsar.jms.PulsarConnectionFactory;
import com.datastax.oss.pulsar.jms.PulsarDestination;
import com.datastax.oss.pulsar.jms.PulsarQueue;
import com.datastax.oss.pulsar.jms.PulsarTopic;
import com.datastax.oss.pulsar.jms.TopicDiscoveryUtils;
import com.datastax.oss.pulsar.jms.Utils;
import com.datastax.oss.pulsar.jms.api.JMSAdmin;
import com.datastax.oss.pulsar.jms.api.JMSDestinationMetadata;
import com.datastax.oss.pulsar.jms.selectors.SelectorSupport;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.admin.PulsarAdminException;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.admin.Topics;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.MessageId;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.PulsarClient;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.partition.PartitionedTopicMetadata;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.ConsumerStats;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.PublisherStats;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.SubscriptionStats;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.TopicStats;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Topic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PulsarJMSAdminImpl
implements JMSAdmin {
    private static final Logger log = LoggerFactory.getLogger(PulsarJMSAdminImpl.class);
    private final PulsarConnectionFactory factory;

    PulsarJMSAdminImpl(PulsarConnectionFactory factory) {
        this.factory = factory;
    }

    @Override
    public Queue getQueue(String queue) throws JMSException {
        return new PulsarQueue(queue);
    }

    @Override
    public Topic getTopic(String topic) throws JMSException {
        return new PulsarTopic(topic);
    }

    @Override
    public JMSDestinationMetadata describe(Destination dest) throws JMSException {
        PulsarDestination destination = PulsarConnectionFactory.toPulsarDestination(dest);
        if (destination.isMultiTopic()) {
            ArrayList<JMSDestinationMetadata> subDestinationsMetadata = new ArrayList<JMSDestinationMetadata>();
            List<PulsarDestination> destinations = destination.getDestinations();
            for (PulsarDestination sub : destinations) {
                JMSDestinationMetadata subDestinationMetadata = this.describe(sub);
                subDestinationsMetadata.add(subDestinationMetadata);
            }
            return new JMSDestinationMetadata.VirtualDestinationMetadata(destination.getName(), destination.isQueue(), destination.isMultiTopic(), destination.isRegExp(), subDestinationsMetadata);
        }
        if (destination.isRegExp()) {
            ArrayList<JMSDestinationMetadata> subDestinationsMetadata = new ArrayList<JMSDestinationMetadata>();
            PulsarClient pulsarClient = this.factory.ensureClient();
            String topicName = this.factory.getPulsarTopicName(destination);
            List<String> topics = TopicDiscoveryUtils.discoverTopicsByPattern(topicName, pulsarClient, 10000);
            String customSubscription = destination.extractSubscriptionName();
            for (String topic : topics) {
                if (customSubscription != null) {
                    topic = topic + ":" + customSubscription;
                }
                PulsarDestination sub = destination.createSameType(topic);
                JMSDestinationMetadata subDestinationMetadata = this.describe(sub);
                subDestinationsMetadata.add(subDestinationMetadata);
            }
            return new JMSDestinationMetadata.VirtualDestinationMetadata(destination.getName(), destination.isQueue(), destination.isMultiTopic(), destination.isRegExp(), subDestinationsMetadata);
        }
        return this.describeDestination(destination);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private JMSDestinationMetadata describeDestination(PulsarDestination destination) throws JMSException {
        pulsarAdmin = this.factory.ensurePulsarAdmin();
        pulsarTopic = this.factory.getPulsarTopicName(destination);
        queueSubscription = destination.isQueue() != false ? this.factory.getQueueSubscriptionName(destination) : null;
        exists = false;
        subscriptions /* !! */  = Collections.emptyMap();
        publishers = Collections.emptyList();
        try {
            partitionedTopicMetadata = pulsarAdmin.topics().getPartitionedTopicMetadata(pulsarTopic);
            exists = true;
        }
        catch (PulsarAdminException.NotFoundException notFound) {
            partitionedTopicMetadata = new PartitionedTopicMetadata(0);
        }
        catch (PulsarAdminException err) {
            throw Utils.handleException(err);
        }
        partitions = partitionedTopicMetadata.partitions;
        if (exists) {
            try {
                if (partitionedTopicMetadata.partitions > 0) {
                    partitionedStats = pulsarAdmin.topics().getPartitionedStats(pulsarTopic, true);
                    subscriptions /* !! */  = partitionedStats.getSubscriptions();
                    publishers = partitionedStats.getPublishers();
                    partitionsStats = partitionedStats.getPartitions();
                } else {
                    stats = pulsarAdmin.topics().getStats(pulsarTopic);
                    subscriptions /* !! */  = stats.getSubscriptions();
                    publishers = stats.getPublishers();
                    partitionsStats = Collections.emptyMap();
                }
                if (subscriptions /* !! */  == null) {
                    subscriptions /* !! */  = Collections.emptyMap();
                }
                if (publishers != null) ** GOTO lbl37
                publishers = Collections.emptyList();
            }
            catch (PulsarAdminException err) {
                throw Utils.handleException(err);
            }
        } else {
            partitionsStats = Collections.emptyMap();
        }
lbl37:
        // 3 sources

        subscriptionMetadataList = new ArrayList<JMSDestinationMetadata.SubscriptionMetadata>();
        queueSubscriptionExists = false;
        if (destination.isQueue()) {
            queueSubscriptionExists = subscriptions /* !! */ .containsKey(queueSubscription);
        }
        subscriptions /* !! */ .forEach((BiConsumer<String, SubscriptionStats>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$describeDestination$3(com.datastax.oss.pulsar.jms.PulsarDestination java.lang.String java.util.List int java.util.Map java.lang.String java.lang.String com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.SubscriptionStats ), (Ljava/lang/String;Lcom/datastax/oss/pulsar/jms/shaded/org/apache/pulsar/common/policies/data/SubscriptionStats;)V)((PulsarDestination)destination, (String)queueSubscription, subscriptionMetadataList, (int)partitions, partitionsStats, (String)pulsarTopic));
        producerMetadataList = new ArrayList<JMSDestinationMetadata.ProducerMetadata>();
        if (partitions > 0) {
            partitionsStats.forEach((BiConsumer<String, TopicStats>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$describeDestination$5(java.util.List java.lang.String com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.TopicStats ), (Ljava/lang/String;Lcom/datastax/oss/pulsar/jms/shaded/org/apache/pulsar/common/policies/data/TopicStats;)V)(producerMetadataList));
        } else {
            publishers.forEach((Consumer<PublisherStats>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$describeDestination$6(java.lang.String java.util.List com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.common.policies.data.PublisherStats ), (Lcom/datastax/oss/pulsar/jms/shaded/org/apache/pulsar/common/policies/data/PublisherStats;)V)((String)pulsarTopic, producerMetadataList));
        }
        if (destination.isQueue()) {
            subscriptionMetadata = subscriptionMetadataList.isEmpty() != false ? null : (JMSDestinationMetadata.SubscriptionMetadata)subscriptionMetadataList.get(0);
            return new JMSDestinationMetadata.QueueMetadata(destination.getName(), exists, pulsarTopic, producerMetadataList, partitions, queueSubscription, queueSubscriptionExists, subscriptionMetadata);
        }
        return new JMSDestinationMetadata.TopicMetadata(destination.getName(), exists, pulsarTopic, producerMetadataList, partitions, subscriptionMetadataList);
    }

    private static JMSDestinationMetadata.ConsumerMetadata buildConsumerMetadata(String pulsarTopic, String subscriptionName, ConsumerStats c) {
        JMSDestinationMetadata.ConsumerMetadata cmd = new JMSDestinationMetadata.ConsumerMetadata(c.getConsumerName());
        cmd.setSubscriptionName(subscriptionName);
        cmd.setPulsarTopic(pulsarTopic);
        cmd.setAddress(c.getAddress());
        cmd.setClientVersion(c.getClientVersion());
        Map<String, String> metadata = c.getMetadata() != null ? c.getMetadata() : Collections.emptyMap();
        cmd.setMetadata(metadata);
        cmd.setAcknowledgeMode(metadata.getOrDefault("jms.acknowledgeMode", "?"));
        String jmsConsumerFiltering = metadata.getOrDefault("jms.filtering", "false");
        if ("true".equals(jmsConsumerFiltering)) {
            cmd.setEnableFilters(true);
            String jmsSelector = metadata.getOrDefault("jms.selector", "");
            cmd.setSelector(jmsSelector);
        }
        cmd.setEnablePriority(metadata.getOrDefault("jms.priority", "disabled").equals("enabled"));
        return cmd;
    }

    private static JMSDestinationMetadata.ProducerMetadata buildProducerMetadata(String pulsarTopic, PublisherStats p) {
        JMSDestinationMetadata.ProducerMetadata cmd = new JMSDestinationMetadata.ProducerMetadata(p.getProducerName());
        cmd.setPulsarTopic(pulsarTopic);
        cmd.setAddress(p.getAddress());
        cmd.setClientVersion(p.getClientVersion());
        Map<String, String> metadata = p.getMetadata() != null ? p.getMetadata() : Collections.emptyMap();
        cmd.setMetadata(metadata);
        cmd.setEnablePriority(metadata.getOrDefault("jms.priority", "disabled").equals("enabled"));
        cmd.setTransacted(metadata.getOrDefault("jms.transactions", "disabled").equals("enabled"));
        cmd.setPriorityMapping(metadata.getOrDefault("jms.priorityMapping", ""));
        return cmd;
    }

    void checkDestination(Destination destination, Function<Destination, Boolean> condition, String message) throws JMSException {
        if (!condition.apply(destination).booleanValue()) {
            throw new InvalidDestinationException(message);
        }
    }

    void checkArgument(Supplier<Boolean> condition, String message) throws JMSException {
        if (!condition.get().booleanValue()) {
            throw new IllegalStateException(message);
        }
    }

    void validateSelector(boolean enableFilters, String selector) throws JMSException {
        if (enableFilters) {
            SelectorSupport.build(selector, true);
        }
    }

    @Override
    public void createSubscription(Topic destination, String subscriptionName, boolean enableFilters, String selector, boolean fromBeginning) throws JMSException {
        try {
            PulsarDestination dest = PulsarConnectionFactory.toPulsarDestination(destination);
            this.validateSelector(enableFilters, selector);
            HashMap<String, String> properties = new HashMap<String, String>();
            if (enableFilters) {
                properties.put("jms.filtering", "true");
                properties.put("jms.selector", selector);
            }
            String topicName = this.factory.getPulsarTopicName(dest);
            Topics topics = this.factory.ensurePulsarAdmin().topics();
            topics.createSubscription(topicName, subscriptionName, fromBeginning ? MessageId.earliest : MessageId.latest, false, properties);
        }
        catch (PulsarAdminException error) {
            throw Utils.handleException(error);
        }
    }

    @Override
    public void createQueue(Queue destination, int partitions, boolean enableFilters, String selector) throws JMSException {
        this.checkArgument(() -> partitions >= 0, "Invalid number of partitions " + partitions);
        this.validateSelector(enableFilters, selector);
        try {
            PulsarDestination dest = PulsarConnectionFactory.toPulsarDestination(destination);
            this.checkDestination(destination, d -> !dest.isVirtualDestination(), "Cannot create a VirtualDestination");
            String topicName = this.factory.getPulsarTopicName(dest);
            Topics topics = this.factory.ensurePulsarAdmin().topics();
            boolean exists = false;
            try {
                PartitionedTopicMetadata partitionedTopicMetadata = topics.getPartitionedTopicMetadata(topicName);
                this.checkDestination(destination, d -> partitionedTopicMetadata.partitions == partitions, "Destination exists and it has a different number of partitions " + partitionedTopicMetadata.partitions + " is different from " + partitions);
                exists = true;
            }
            catch (PulsarAdminException.NotFoundException partitionedTopicMetadata) {
                // empty catch block
            }
            String subscriptionName = this.factory.getQueueSubscriptionName(dest);
            if (!exists) {
                if (partitions > 0) {
                    topics.createPartitionedTopic(topicName, partitions);
                } else {
                    topics.createNonPartitionedTopic(topicName);
                }
            }
            HashMap<String, String> properties = new HashMap<String, String>();
            if (enableFilters) {
                properties.put("jms.filtering", "true");
                properties.put("jms.selector", selector);
            }
            try {
                topics.createSubscription(topicName, subscriptionName, MessageId.earliest, false, properties);
            }
            catch (PulsarAdminException.ConflictException alreadyExists) {
                log.debug("Already exists", alreadyExists);
                throw new InvalidDestinationException("Subscription " + subscriptionName + " already exists on Pulsar Topic " + topicName);
            }
        }
        catch (PulsarAdminException error) {
            throw Utils.handleException(error);
        }
    }

    @Override
    public void createTopic(Topic destination, int partitions) throws JMSException {
        this.checkArgument(() -> partitions >= 0, "Invalid number of partitions " + partitions);
        try {
            PulsarDestination dest = PulsarConnectionFactory.toPulsarDestination(destination);
            this.checkDestination(destination, d -> !dest.isVirtualDestination(), "Cannot create a VirtualDestination");
            String topicName = this.factory.getPulsarTopicName(dest);
            Topics topics = this.factory.ensurePulsarAdmin().topics();
            try {
                PartitionedTopicMetadata partitionedTopicMetadata = topics.getPartitionedTopicMetadata(topicName);
                this.checkDestination(destination, d -> partitionedTopicMetadata.partitions != partitions, "Destination exists and it has a different number of partitions " + partitionedTopicMetadata.partitions + " is different from " + partitions);
            }
            catch (PulsarAdminException.NotFoundException partitionedTopicMetadata) {
                // empty catch block
            }
            try {
                if (partitions > 0) {
                    topics.createPartitionedTopic(topicName, partitions);
                } else {
                    topics.createNonPartitionedTopic(topicName);
                }
            }
            catch (PulsarAdminException.ConflictException exists) {
                throw new InvalidDestinationException("Topic " + topicName + " already exists");
            }
        }
        catch (PulsarAdminException error) {
            throw Utils.handleException(error);
        }
    }

    @Override
    public void setQueueSubscriptionSelector(Queue destination, boolean enableFilters, String selector) throws JMSException {
        try {
            PulsarDestination dest = PulsarConnectionFactory.toPulsarDestination(destination);
            String topicName = this.factory.getPulsarTopicName(dest);
            String subscriptionName = this.factory.getQueueSubscriptionName(dest);
            this.doUpdateSubscriptionSelector(enableFilters, selector, topicName, subscriptionName);
        }
        catch (PulsarAdminException error) {
            throw Utils.handleException(error);
        }
    }

    private void doUpdateSubscriptionSelector(boolean enableFilters, String selector, String topicName, String subscriptionName) throws JMSException, PulsarAdminException {
        this.validateSelector(enableFilters, selector);
        Topics topics = this.factory.ensurePulsarAdmin().topics();
        Map<Object, Object> currentProperties = new HashMap<String, String>();
        try {
            currentProperties = topics.getSubscriptionProperties(topicName, subscriptionName);
        }
        catch (PulsarAdminException.NotFoundException notFoundException) {
            // empty catch block
        }
        currentProperties.put("jms.filtering", enableFilters + "");
        if (enableFilters) {
            currentProperties.put("jms.selector", selector);
        } else {
            currentProperties.remove("jms.selector");
        }
        topics.updateSubscriptionProperties(topicName, subscriptionName, currentProperties);
    }

    @Override
    public void setSubscriptionSelector(Topic destination, String subscriptionName, boolean enableFilters, String selector) throws JMSException {
        try {
            PulsarDestination dest = PulsarConnectionFactory.toPulsarDestination(destination);
            String topicName = this.factory.getPulsarTopicName(dest);
            this.doUpdateSubscriptionSelector(enableFilters, selector, topicName, subscriptionName);
        }
        catch (PulsarAdminException error) {
            throw Utils.handleException(error);
        }
    }

    private static /* synthetic */ void lambda$describeDestination$6(String pulsarTopic, List producerMetadataList, PublisherStats p) {
        JMSDestinationMetadata.ProducerMetadata cmd = PulsarJMSAdminImpl.buildProducerMetadata(pulsarTopic, p);
        producerMetadataList.add(cmd);
    }

    private static /* synthetic */ void lambda$describeDestination$5(List producerMetadataList, String partition, TopicStats stats) {
        stats.getPublishers().forEach(p -> {
            JMSDestinationMetadata.ProducerMetadata cmd = PulsarJMSAdminImpl.buildProducerMetadata(partition, p);
            producerMetadataList.add(cmd);
        });
    }

    private static /* synthetic */ void lambda$describeDestination$3(PulsarDestination destination, String queueSubscription, List subscriptionMetadataList, int partitions, Map partitionsStats, String pulsarTopic, String subscriptionName, SubscriptionStats sub) {
        if (destination.isQueue() && !subscriptionName.equals(queueSubscription)) {
            return;
        }
        JMSDestinationMetadata.SubscriptionMetadata md = new JMSDestinationMetadata.SubscriptionMetadata(subscriptionName);
        subscriptionMetadataList.add(md);
        Map<String, String> subscriptionProperties = sub.getSubscriptionProperties() != null ? sub.getSubscriptionProperties() : Collections.emptyMap();
        md.setSubscriptionProperties(subscriptionProperties);
        String jmsFiltering = subscriptionProperties.getOrDefault("jms.filtering", "false");
        if ("true".equals(jmsFiltering)) {
            md.setEnableFilters(true);
            String jmsSelector = subscriptionProperties.getOrDefault("jms.selector", "");
            md.setSelector(jmsSelector);
        }
        ArrayList<JMSDestinationMetadata.ConsumerMetadata> consumers = new ArrayList<JMSDestinationMetadata.ConsumerMetadata>();
        md.setConsumers(consumers);
        if (partitions > 0) {
            partitionsStats.forEach((partitionName, topicStats) -> {
                SubscriptionStats subscriptionStats = topicStats.getSubscriptions().get(subscriptionName);
                if (subscriptionStats != null) {
                    subscriptionStats.getConsumers().forEach(c -> {
                        JMSDestinationMetadata.ConsumerMetadata cmd = PulsarJMSAdminImpl.buildConsumerMetadata(partitionName, subscriptionName, c);
                        consumers.add(cmd);
                    });
                }
            });
        } else {
            sub.getConsumers().forEach(c -> {
                JMSDestinationMetadata.ConsumerMetadata cmd = PulsarJMSAdminImpl.buildConsumerMetadata(pulsarTopic, subscriptionName, c);
                consumers.add(cmd);
            });
        }
    }
}

