/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms;

import com.datastax.oss.pulsar.jms.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;

public abstract class PulsarDestination
implements Destination {
    protected String topicName;
    protected String queryString;

    protected PulsarDestination(String topicName) {
        this.topicName = Objects.requireNonNull(topicName);
        this.estractQueryString();
        if (this.isMultiTopic()) {
            Utils.runtimeException(() -> {
                List<PulsarDestination> destinations = this.getDestinations();
                if (destinations.size() == 1) {
                    this.topicName = destinations.get((int)0).topicName;
                    this.queryString = destinations.get((int)0).queryString;
                }
            });
        }
    }

    private void estractQueryString() {
        int queryStringStart = this.topicName.indexOf("?");
        if (queryStringStart > 0) {
            this.queryString = this.topicName.substring(queryStringStart + 1);
            this.topicName = this.topicName.substring(0, queryStringStart);
        } else {
            this.queryString = "";
        }
    }

    public String getName() {
        return this.topicName;
    }

    public void setName(String name) {
        this.topicName = name;
        this.estractQueryString();
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String extractSubscriptionName() throws InvalidDestinationException {
        return null;
    }

    public String getInternalTopicName() throws InvalidDestinationException {
        if (this.isRegExp()) {
            return this.topicName.substring("regex:".length());
        }
        if (this.isMultiTopic()) {
            throw new InvalidDestinationException("Cannot get internal topic name for a multi-topic destination");
        }
        return this.topicName;
    }

    public final boolean isVirtualDestination() {
        return this.isRegExp() || this.isMultiTopic();
    }

    public boolean isRegExp() {
        return this.topicName.startsWith("regex:");
    }

    public boolean isMultiTopic() {
        return this.topicName.startsWith("multi:");
    }

    public List<PulsarDestination> getDestinations() throws InvalidDestinationException {
        if (!this.isMultiTopic()) {
            return Collections.singletonList(this);
        }
        String withoutPrefix = this.topicName.substring("multi:".length());
        if (withoutPrefix.isEmpty()) {
            throw new InvalidDestinationException("Invalid destination " + this.topicName);
        }
        String customSubscription = this.extractSubscriptionName();
        if (customSubscription != null) {
            withoutPrefix = withoutPrefix.substring(0, withoutPrefix.length() - customSubscription.length() - 1);
        }
        String[] split = withoutPrefix.split(",");
        ArrayList<PulsarDestination> destinations = new ArrayList<PulsarDestination>(split.length);
        String appendQueryString = this.queryString.isEmpty() ? "" : "?" + this.queryString;
        for (String part : split) {
            if (part.isEmpty()) {
                throw new InvalidDestinationException("Invalid destination " + this.topicName);
            }
            if (customSubscription != null) {
                destinations.add(this.createSameType(part + ":" + customSubscription + appendQueryString));
                continue;
            }
            destinations.add(this.createSameType(part + appendQueryString));
        }
        if (destinations.isEmpty()) {
            throw new InvalidDestinationException("Invalid destination " + this.topicName);
        }
        return destinations;
    }

    public PulsarDestination createSameType(String topicName) throws InvalidDestinationException {
        throw new InvalidDestinationException("Multi topic syntax is not allowed for this kind of destination (" + this.getClass() + ")");
    }

    public abstract boolean isQueue();

    public abstract boolean isTopic();

    public final boolean equals(Object other) {
        if (!(other instanceof PulsarDestination)) {
            return false;
        }
        PulsarDestination o = (PulsarDestination)other;
        return Objects.equals(o.topicName, this.topicName) && Objects.equals(o.isQueue(), this.isQueue()) && Objects.equals(o.isTopic(), this.isTopic() && Objects.equals(o.queryString, this.queryString));
    }

    public final int hashCode() {
        return this.topicName.hashCode();
    }
}

