/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms;

import com.datastax.oss.pulsar.jms.Utils;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.DeadLetterPolicy;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.RedeliveryBackoff;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.api.Schema;
import com.datastax.oss.pulsar.jms.shaded.org.apache.pulsar.client.impl.MultiplierRedeliveryBackoff;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

final class ConsumerConfiguration {
    static ConsumerConfiguration DEFAULT = new ConsumerConfiguration(Collections.emptyMap(), null, null, null, null);
    private final Map<String, Object> consumerConfiguration;
    private Schema<?> consumerSchema;
    private DeadLetterPolicy deadLetterPolicy;
    private RedeliveryBackoff negativeAckRedeliveryBackoff;
    private RedeliveryBackoff ackTimeoutRedeliveryBackoff;

    ConsumerConfiguration(Map<String, Object> consumerConfiguration, Schema<?> consumerSchema, DeadLetterPolicy deadLetterPolicy, RedeliveryBackoff negativeAckRedeliveryBackoff, RedeliveryBackoff ackTimeoutRedeliveryBackoff) {
        this.consumerConfiguration = Objects.requireNonNull(consumerConfiguration);
        this.consumerSchema = consumerSchema;
        this.deadLetterPolicy = deadLetterPolicy;
        this.negativeAckRedeliveryBackoff = negativeAckRedeliveryBackoff;
        this.ackTimeoutRedeliveryBackoff = ackTimeoutRedeliveryBackoff;
    }

    public Map<String, Object> getConsumerConfiguration() {
        return this.consumerConfiguration;
    }

    public Schema<?> getConsumerSchema() {
        return this.consumerSchema;
    }

    public DeadLetterPolicy getDeadLetterPolicy() {
        return this.deadLetterPolicy;
    }

    public RedeliveryBackoff getNegativeAckRedeliveryBackoff() {
        return this.negativeAckRedeliveryBackoff;
    }

    public RedeliveryBackoff getAckTimeoutRedeliveryBackoff() {
        return this.ackTimeoutRedeliveryBackoff;
    }

    ConsumerConfiguration applyDefaults(ConsumerConfiguration defaultConsumerConfiguration) {
        HashMap<String, Object> mergedConsumerConfiguration = new HashMap<String, Object>();
        if (defaultConsumerConfiguration.consumerConfiguration != null) {
            mergedConsumerConfiguration.putAll(Utils.deepCopyMap(defaultConsumerConfiguration.consumerConfiguration));
        }
        if (this.consumerConfiguration != null) {
            mergedConsumerConfiguration.putAll(Utils.deepCopyMap(this.consumerConfiguration));
        }
        Schema<?> mergedConsumerSchema = this.consumerSchema != null ? this.consumerSchema : defaultConsumerConfiguration.consumerSchema;
        DeadLetterPolicy mergedDeadLetterPolicy = this.deadLetterPolicy != null ? this.deadLetterPolicy : defaultConsumerConfiguration.deadLetterPolicy;
        RedeliveryBackoff mergedNegativeAckRedeliveryBackoff = this.negativeAckRedeliveryBackoff != null ? this.negativeAckRedeliveryBackoff : defaultConsumerConfiguration.negativeAckRedeliveryBackoff;
        RedeliveryBackoff mergedAckTimeoutRedeliveryBackoff = this.ackTimeoutRedeliveryBackoff != null ? this.ackTimeoutRedeliveryBackoff : defaultConsumerConfiguration.ackTimeoutRedeliveryBackoff;
        return new ConsumerConfiguration(mergedConsumerConfiguration, mergedConsumerSchema, mergedDeadLetterPolicy, mergedNegativeAckRedeliveryBackoff, mergedAckTimeoutRedeliveryBackoff);
    }

    static ConsumerConfiguration buildConsumerConfiguration(Map<String, Object> consumerConfigurationM) {
        if (consumerConfigurationM == null || consumerConfigurationM.isEmpty()) {
            return DEFAULT;
        }
        consumerConfigurationM = Utils.deepCopyMap(consumerConfigurationM);
        Schema<Object> consumerSchema = null;
        Map<String, Object> consumerConfiguration = Collections.emptyMap();
        DeadLetterPolicy deadLetterPolicy = null;
        RedeliveryBackoff negativeAckRedeliveryBackoff = null;
        RedeliveryBackoff ackTimeoutRedeliveryBackoff = null;
        if (consumerConfigurationM != null) {
            consumerConfiguration = new HashMap<String, Object>(consumerConfigurationM);
            if (consumerConfiguration.containsKey("useSchema")) {
                boolean useSchema = Boolean.parseBoolean(Utils.getAndRemoveString("useSchema", "false", consumerConfiguration));
                consumerSchema = useSchema ? Schema.AUTO_CONSUME() : Schema.BYTES;
            }
            deadLetterPolicy = ConsumerConfiguration.getAndRemoveDeadLetterPolicy(consumerConfiguration);
            negativeAckRedeliveryBackoff = ConsumerConfiguration.getAndRemoveRedeliveryBackoff("negativeAckRedeliveryBackoff", consumerConfiguration);
            ackTimeoutRedeliveryBackoff = ConsumerConfiguration.getAndRemoveRedeliveryBackoff("ackTimeoutRedeliveryBackoff", consumerConfiguration);
        }
        return new ConsumerConfiguration(consumerConfiguration, consumerSchema, deadLetterPolicy, negativeAckRedeliveryBackoff, ackTimeoutRedeliveryBackoff);
    }

    private static RedeliveryBackoff getAndRemoveRedeliveryBackoff(String baseName, Map<String, Object> consumerConfiguration) {
        double multiplier;
        long minDelayMs;
        Map config = (Map)consumerConfiguration.remove(baseName);
        if (config == null) {
            return null;
        }
        MultiplierRedeliveryBackoff.MultiplierRedeliveryBackoffBuilder builder = MultiplierRedeliveryBackoff.builder();
        long maxDelayMs = Long.parseLong(Utils.getAndRemoveString("maxDelayMs", "-1", config));
        if (maxDelayMs >= 0L) {
            builder.maxDelayMs(maxDelayMs);
        }
        if ((minDelayMs = Long.parseLong(Utils.getAndRemoveString("minDelayMs", "-1", config))) >= 0L) {
            builder.minDelayMs(minDelayMs);
        }
        if ((multiplier = Double.parseDouble(Utils.getAndRemoveString("multiplier", "-1", config))) >= 0.0) {
            builder.multiplier(multiplier);
        }
        if (!config.isEmpty()) {
            throw new IllegalArgumentException("Unhandled fields in " + baseName + ": " + config);
        }
        return builder.build();
    }

    private static DeadLetterPolicy getAndRemoveDeadLetterPolicy(Map<String, Object> consumerConfiguration) {
        int maxRedeliverCount;
        String initialSubscriptionName;
        Map deadLetterPolicyConfig = (Map)consumerConfiguration.remove("deadLetterPolicy");
        if (deadLetterPolicyConfig == null || deadLetterPolicyConfig.isEmpty()) {
            return null;
        }
        DeadLetterPolicy.DeadLetterPolicyBuilder deadLetterPolicyBuilder = DeadLetterPolicy.builder();
        String deadLetterTopic = Utils.getAndRemoveString("deadLetterTopic", "", deadLetterPolicyConfig);
        if (!deadLetterTopic.isEmpty()) {
            deadLetterPolicyBuilder.deadLetterTopic(deadLetterTopic);
        }
        String retryLetterTopic = Utils.getAndRemoveString("retryLetterTopic", "", deadLetterPolicyConfig);
        if (!deadLetterTopic.isEmpty()) {
            deadLetterPolicyBuilder.retryLetterTopic(retryLetterTopic);
        }
        if (!(initialSubscriptionName = Utils.getAndRemoveString("initialSubscriptionName", "", deadLetterPolicyConfig)).isEmpty()) {
            deadLetterPolicyBuilder.initialSubscriptionName(initialSubscriptionName);
        }
        if ((maxRedeliverCount = Integer.parseInt(Utils.getAndRemoveString("maxRedeliverCount", "-1", deadLetterPolicyConfig))) > -1) {
            deadLetterPolicyBuilder.maxRedeliverCount(maxRedeliverCount);
        }
        if (!deadLetterPolicyConfig.isEmpty()) {
            throw new IllegalArgumentException("Unhandled fields in deadLetterPolicy: " + deadLetterPolicyConfig);
        }
        return deadLetterPolicyBuilder.build();
    }
}

