/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.pulsar.jms;

import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;

public final class CompositeEnumeration
implements Enumeration {
    private final List<? extends Enumeration> enumerations;
    private int currentEnumeration = 0;
    private Enumeration current;

    public CompositeEnumeration(List<? extends Enumeration> enumerations) {
        this.enumerations = enumerations;
        if (enumerations.isEmpty()) {
            this.current = null;
            this.currentEnumeration = -1;
        } else {
            this.startEnumeration(0);
        }
    }

    private void startEnumeration(int n) {
        if (n == this.enumerations.size()) {
            this.currentEnumeration = -1;
            this.current = null;
        } else {
            this.currentEnumeration = n;
            this.current = this.enumerations.get(n);
            this.skipEmpty();
        }
    }

    private void skipEmpty() {
        while (!this.current.hasMoreElements()) {
            ++this.currentEnumeration;
            if (this.currentEnumeration == this.enumerations.size()) {
                this.currentEnumeration = -1;
                this.current = null;
                break;
            }
            this.current = this.enumerations.get(this.currentEnumeration);
        }
    }

    @Override
    public synchronized boolean hasMoreElements() {
        return this.currentEnumeration >= 0;
    }

    public synchronized Object nextElement() {
        if (this.current == null) {
            throw new NoSuchElementException();
        }
        Object next = this.current.nextElement();
        if (!this.current.hasMoreElements()) {
            this.startEnumeration(this.currentEnumeration + 1);
        }
        return next;
    }
}

