/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger;

import com.google.common.base.Charsets;
import java.nio.charset.Charset;
import java.util.Enumeration;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.test.MockedBookKeeperTestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.Test;

public class SimpleBookKeeperTest
extends MockedBookKeeperTestCase {
    private static final String SECRET = "secret";
    private static final Charset Encoding = Charsets.UTF_8;
    private static Logger log = LoggerFactory.getLogger(SimpleBookKeeperTest.class);

    @Test
    public void simpleTest() throws Exception {
        LedgerHandle ledger = this.bkc.createLedger(BookKeeper.DigestType.MAC, SECRET.getBytes());
        long ledgerId = ledger.getId();
        log.info("Writing to ledger: {}", (Object)ledgerId);
        for (int i = 0; i < 10; ++i) {
            String content = "entry-" + i;
            ledger.addEntry(content.getBytes(Encoding));
        }
        ledger.close();
        ledger = this.bkc.openLedger(ledgerId, BookKeeper.DigestType.MAC, SECRET.getBytes());
        Enumeration entries = ledger.readEntries(0L, 9L);
        while (entries.hasMoreElements()) {
            LedgerEntry entry = (LedgerEntry)entries.nextElement();
            String content = new String(entry.getEntry(), Encoding);
            log.info("Entry {}  lenght={} content='{}'", new Object[]{entry.getEntryId(), entry.getLength(), content});
        }
        ledger.close();
    }
}

