/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.util;

import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class MockClock
extends Clock {
    private Instant initialInstant = Clock.systemUTC().instant();
    private AtomicLong delta = new AtomicLong(0L);

    public void advance(long period, TimeUnit unit) {
        this.delta.addAndGet(unit.toNanos(period));
    }

    @Override
    public Instant instant() {
        return this.initialInstant.plusNanos(this.delta.get());
    }

    @Override
    public Clock withZone(ZoneId zone) {
        return this;
    }

    @Override
    public ZoneId getZone() {
        return ZoneId.systemDefault();
    }
}

