/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.util;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.bookkeeper.mledger.util.CallbackMutex;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CallbackMutexTest {
    public final int numberOfThreads = 1000;
    public int counter = 0;

    @Test
    public void lock() {
        CallbackMutex cbm = new CallbackMutex();
        Account salary = new Account();
        salary.add(1000);
        new Thread(() -> {
            cbm.lock();
            if (salary.value() == 1000) {
                salary.add(2000);
            }
            cbm.unlock();
            Assert.assertEquals((int)salary.value(), (int)3000);
        }).start();
    }

    @Test(enabled=false)
    public void unlock() {
        ProtectedCode pc = new ProtectedCode();
        for (int i = 0; i < 1000; ++i) {
            new Thread(pc).start();
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Assert.assertEquals((int)this.counter, (int)1000);
    }

    public class ProtectedCode
    implements Runnable {
        AtomicBoolean ab = new AtomicBoolean(false);
        Account salary = new Account();
        CallbackMutex cbm = new CallbackMutex();

        @Override
        public void run() {
            ++CallbackMutexTest.this.counter;
            this.cbm.lock();
            this.salary.set(0);
            int raise = 0;
            raise = this.ab.compareAndSet(false, true) ? 2 : -2;
            while (this.salary.value() < 1000000) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (this.salary.value() % 2 != 0) continue;
                this.salary.add(raise);
            }
            Assert.assertEquals((int)this.salary.value(), (int)1000000);
            this.ab.compareAndSet(true, false);
            this.cbm.unlock();
        }
    }

    public class Account {
        int balance = 0;

        public int add(int change) {
            this.balance += change;
            return this.balance;
        }

        public int value() {
            return this.balance;
        }

        public int set(int initial) {
            this.balance = initial;
            return this.balance;
        }
    }
}

