/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.apache.bookkeeper.mledger.impl.MetaStoreImpl;
import org.apache.bookkeeper.mledger.offload.OffloadUtils;
import org.apache.bookkeeper.mledger.proto.MLDataFormats;
import org.apache.commons.lang3.RandomUtils;
import org.apache.pulsar.common.api.proto.CompressionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ManagedLedgerInfoMetadataTest {
    private static final Logger log = LoggerFactory.getLogger(ManagedLedgerInfoMetadataTest.class);

    @DataProvider(name="compressionTypeProvider")
    private Object[][] compressionTypeProvider() {
        return new Object[][]{{null}, {"INVALID_TYPE"}, {CompressionType.NONE.name()}, {CompressionType.LZ4.name()}, {CompressionType.ZLIB.name()}, {CompressionType.ZSTD.name()}, {CompressionType.SNAPPY.name()}};
    }

    @Test(dataProvider="compressionTypeProvider")
    public void testEncodeAndDecode(String compressionType) throws IOException {
        MetaStoreImpl metaStore;
        long ledgerId = 10000L;
        ArrayList<MLDataFormats.ManagedLedgerInfo.LedgerInfo> ledgerInfoList = new ArrayList<MLDataFormats.ManagedLedgerInfo.LedgerInfo>();
        for (int i = 0; i < 100; ++i) {
            MLDataFormats.ManagedLedgerInfo.LedgerInfo.Builder builder = MLDataFormats.ManagedLedgerInfo.LedgerInfo.newBuilder();
            builder.setLedgerId(ledgerId);
            builder.setEntries((long)RandomUtils.nextInt());
            builder.setSize(RandomUtils.nextLong());
            builder.setTimestamp(System.currentTimeMillis());
            UUID uuid = UUID.randomUUID();
            builder.getOffloadContextBuilder().setUidMsb(uuid.getMostSignificantBits()).setUidLsb(uuid.getLeastSignificantBits());
            HashMap<String, String> offloadDriverMetadata = new HashMap<String, String>();
            offloadDriverMetadata.put("bucket", "test-bucket");
            offloadDriverMetadata.put("managedLedgerOffloadDriver", "pulsar-offload-dev");
            offloadDriverMetadata.put("serviceEndpoint", "https://s3.eu-west-1.amazonaws.com");
            offloadDriverMetadata.put("region", "eu-west-1");
            OffloadUtils.setOffloadDriverMetadata((MLDataFormats.ManagedLedgerInfo.LedgerInfo.Builder)builder, (String)"aws-s3", offloadDriverMetadata);
            MLDataFormats.ManagedLedgerInfo.LedgerInfo ledgerInfo = builder.build();
            ledgerInfoList.add(ledgerInfo);
            ++ledgerId;
        }
        MLDataFormats.ManagedLedgerInfo managedLedgerInfo = MLDataFormats.ManagedLedgerInfo.newBuilder().addAllLedgerInfo(ledgerInfoList).build();
        try {
            metaStore = new MetaStoreImpl(null, null, compressionType);
            if ("INVALID_TYPE".equals(compressionType)) {
                Assert.fail((String)"The managedLedgerInfo compression type is invalid, should fail.");
            }
        }
        catch (Exception e) {
            if ("INVALID_TYPE".equals(compressionType)) {
                Assert.assertEquals(e.getClass(), IllegalArgumentException.class);
                Assert.assertEquals((String)("No enum constant org.apache.bookkeeper.mledger.proto.MLDataFormats.CompressionType." + compressionType), (String)e.getMessage());
                return;
            }
            throw e;
        }
        byte[] compressionBytes = metaStore.compressLedgerInfo(managedLedgerInfo);
        log.info("[{}] Uncompressed data size: {}, compressed data size: {}", new Object[]{compressionType, managedLedgerInfo.getSerializedSize(), compressionBytes.length});
        if (compressionType == null || compressionType.equals(CompressionType.NONE.name())) {
            Assert.assertEquals((int)compressionBytes.length, (int)managedLedgerInfo.getSerializedSize());
        }
        MLDataFormats.ManagedLedgerInfo info1 = metaStore.parseManagedLedgerInfo(compressionBytes);
        MLDataFormats.ManagedLedgerInfo info2 = metaStore.parseManagedLedgerInfo(managedLedgerInfo.toByteArray());
        Assert.assertEquals((Object)info1, (Object)info2);
    }

    @Test
    public void testParseEmptyData() throws InvalidProtocolBufferException {
        MetaStoreImpl metaStore = new MetaStoreImpl(null, null);
        MLDataFormats.ManagedLedgerInfo managedLedgerInfo = metaStore.parseManagedLedgerInfo(new byte[0]);
        Assert.assertEquals((String)managedLedgerInfo.toString(), (String)"");
    }
}

