/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.offload;

import org.apache.bookkeeper.mledger.offload.OffloaderUtils;
import org.apache.bookkeeper.mledger.offload.Offloaders;
import org.apache.bookkeeper.mledger.offload.OffloadersCache;
import org.mockito.ArgumentMatchers;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.testng.PowerMockObjectFactory;
import org.testng.Assert;
import org.testng.IObjectFactory;
import org.testng.annotations.ObjectFactory;
import org.testng.annotations.Test;

@PrepareForTest(value={OffloaderUtils.class})
@PowerMockIgnore(value={"org.apache.logging.log4j.*", "org.apache.pulsar.common.nar.*"})
public class OffloadersCacheTest {
    @ObjectFactory
    public IObjectFactory getObjectFactory() {
        return new PowerMockObjectFactory();
    }

    @Test
    public void testLoadsOnlyOnce() throws Exception {
        Offloaders expectedOffloaders = new Offloaders();
        PowerMockito.mockStatic(OffloaderUtils.class, (Class[])new Class[0]);
        PowerMockito.when((Object)OffloaderUtils.searchForOffloaders((String)((String)ArgumentMatchers.eq((Object)"./offloaders")), (String)((String)ArgumentMatchers.eq((Object)"/tmp")))).thenReturn((Object)expectedOffloaders);
        OffloadersCache cache = new OffloadersCache();
        Offloaders offloaders1 = cache.getOrLoadOffloaders("./offloaders", "/tmp");
        Assert.assertSame((Object)offloaders1, (Object)expectedOffloaders, (String)"The offloaders should be the mocked one.");
        Offloaders offloaders2 = cache.getOrLoadOffloaders("./offloaders", "/tmp");
        Assert.assertSame((Object)offloaders2, (Object)expectedOffloaders, (String)"The offloaders should be the mocked one.");
    }
}

