/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import java.util.Collections;
import java.util.List;
import org.apache.bookkeeper.common.allocator.PoolingPolicy;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.bookkeeper.mledger.ManagedLedgerConfig;
import org.apache.bookkeeper.mledger.ManagedLedgerFactoryConfig;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerFactoryImpl;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ManagedLedgerFactoryChangeLedgerPathTest
extends BookKeeperClusterTestCase {
    public ManagedLedgerFactoryChangeLedgerPathTest() {
        super(2);
    }

    @Override
    protected String changeLedgerPath() {
        return "/test";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChangeZKPath() throws Exception {
        ClientConfiguration configuration = new ClientConfiguration();
        String zkConnectString = this.zkUtil.getZooKeeperConnectString() + "/test";
        configuration.setMetadataServiceUri("zk://" + zkConnectString + "/ledgers");
        configuration.setUseV2WireProtocol(true);
        configuration.setEnableDigestTypeAutodetection(true);
        configuration.setAllocatorPoolingPolicy(PoolingPolicy.UnpooledHeap);
        ManagedLedgerFactoryImpl factory = new ManagedLedgerFactoryImpl((MetadataStore)this.metadataStore, configuration);
        try {
            ManagedLedgerConfig config = new ManagedLedgerConfig();
            config.setEnsembleSize(1).setWriteQuorumSize(1).setAckQuorumSize(1).setMetadataAckQuorumSize(1).setMetadataAckQuorumSize(1);
            ManagedLedger ledger = factory.open("test-ledger", config);
            ManagedCursor cursor = ledger.openCursor("test-c1");
            for (int i = 0; i < 10; ++i) {
                String entry = "entry" + i;
                ledger.addEntry(entry.getBytes("UTF8"));
            }
            List entryList = cursor.readEntries(10);
            Assert.assertEquals((int)10, (int)entryList.size());
            for (int i = 0; i < 10; ++i) {
                Entry entry = (Entry)entryList.get(i);
                Assert.assertEquals((byte[])("entry" + i).getBytes("UTF8"), (byte[])entry.getData());
            }
        }
        finally {
            if (Collections.singletonList(factory).get(0) != null) {
                factory.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChangeZKPath2() throws Exception {
        ClientConfiguration configuration = new ClientConfiguration();
        String zkConnectString = this.zkUtil.getZooKeeperConnectString() + "/test";
        configuration.setMetadataServiceUri("zk://" + zkConnectString + "/ledgers");
        configuration.setUseV2WireProtocol(true);
        configuration.setEnableDigestTypeAutodetection(true);
        configuration.setAllocatorPoolingPolicy(PoolingPolicy.UnpooledHeap);
        ManagedLedgerFactoryConfig managedLedgerFactoryConfig = new ManagedLedgerFactoryConfig();
        ManagedLedgerFactoryImpl factory = new ManagedLedgerFactoryImpl((MetadataStore)this.metadataStore, configuration, managedLedgerFactoryConfig);
        try {
            ManagedLedgerConfig config = new ManagedLedgerConfig();
            config.setEnsembleSize(1).setWriteQuorumSize(1).setAckQuorumSize(1).setMetadataAckQuorumSize(1).setMetadataAckQuorumSize(1);
            ManagedLedger ledger = factory.open("test-ledger", config);
            ManagedCursor cursor = ledger.openCursor("test-c1");
            for (int i = 0; i < 10; ++i) {
                String entry = "entry" + i;
                ledger.addEntry(entry.getBytes("UTF8"));
            }
            List entryList = cursor.readEntries(10);
            Assert.assertEquals((int)10, (int)entryList.size());
            for (int i = 0; i < 10; ++i) {
                Entry entry = (Entry)entryList.get(i);
                Assert.assertEquals((byte[])("entry" + i).getBytes("UTF8"), (byte[])entry.getData());
            }
        }
        finally {
            if (Collections.singletonList(factory).get(0) != null) {
                factory.shutdown();
            }
        }
    }
}

