/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.bookkeeper.mledger.ManagedLedgerConfig;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerFactoryImpl;
import org.apache.bookkeeper.test.MockedBookKeeperTestCase;
import org.apache.pulsar.common.api.proto.CommandSubscribe;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ManagedCursorPropertiesTest
extends MockedBookKeeperTestCase {
    @Test(timeOut=20000L)
    void testPropertiesClose() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger", new ManagedLedgerConfig());
        ManagedCursor c1 = ledger.openCursor("c1");
        Assert.assertEquals((Map)c1.getProperties(), Collections.emptyMap());
        ledger.addEntry("entry-1".getBytes());
        ledger.addEntry("entry-2".getBytes());
        Position p3 = ledger.addEntry("entry-3".getBytes());
        ledger.addEntry("entry-4".getBytes());
        TreeMap<String, Long> properties = new TreeMap<String, Long>();
        properties.put("a", 1L);
        properties.put("b", 2L);
        properties.put("c", 3L);
        c1.markDelete(p3, properties);
        Assert.assertEquals((Map)c1.getProperties(), properties);
        TreeMap<String, Long> properties2 = new TreeMap<String, Long>();
        properties2.put("a", 4L);
        properties2.put("b", 5L);
        properties2.put("c", 6L);
        c1.markDelete(p3, properties2);
        Assert.assertEquals((Map)c1.getProperties(), properties2);
        ledger.close();
        ledger = this.factory.open("my_test_ledger", new ManagedLedgerConfig());
        c1 = ledger.openCursor("c1");
        Assert.assertEquals((Object)c1.getMarkDeletedPosition(), (Object)p3);
        Assert.assertEquals((Map)c1.getProperties(), properties2);
    }

    @Test(timeOut=20000L)
    void testPropertiesRecoveryAfterCrash() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger", new ManagedLedgerConfig());
        ManagedCursor c1 = ledger.openCursor("c1");
        Assert.assertEquals((Map)c1.getProperties(), Collections.emptyMap());
        ledger.addEntry("entry-1".getBytes());
        ledger.addEntry("entry-2".getBytes());
        Position p3 = ledger.addEntry("entry-3".getBytes());
        ledger.addEntry("entry-4".getBytes());
        TreeMap<String, Long> properties = new TreeMap<String, Long>();
        properties.put("a", 1L);
        properties.put("b", 2L);
        properties.put("c", 3L);
        c1.markDelete(p3, properties);
        ManagedLedgerFactoryImpl factory2 = new ManagedLedgerFactoryImpl((MetadataStore)this.metadataStore, (BookKeeper)this.bkc);
        ledger = factory2.open("my_test_ledger", new ManagedLedgerConfig());
        c1 = ledger.openCursor("c1");
        Assert.assertEquals((Object)c1.getMarkDeletedPosition(), (Object)p3);
        Assert.assertEquals((Map)c1.getProperties(), properties);
        factory2.shutdown();
    }

    @Test(timeOut=20000L)
    void testPropertiesOnDelete() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger", new ManagedLedgerConfig());
        ManagedCursor c1 = ledger.openCursor("c1");
        Assert.assertEquals((Map)c1.getProperties(), Collections.emptyMap());
        ledger.addEntry("entry-1".getBytes());
        Position p2 = ledger.addEntry("entry-2".getBytes());
        Position p3 = ledger.addEntry("entry-3".getBytes());
        ledger.addEntry("entry-4".getBytes());
        TreeMap<String, Long> properties = new TreeMap<String, Long>();
        properties.put("a", 1L);
        properties.put("b", 2L);
        properties.put("c", 3L);
        c1.markDelete(p2, properties);
        Assert.assertEquals((Map)c1.getProperties(), properties);
        c1.markDelete(p3, properties);
        Assert.assertEquals((Map)c1.getProperties(), properties);
        ledger.close();
        ledger = this.factory.open("my_test_ledger", new ManagedLedgerConfig());
        c1 = ledger.openCursor("c1");
        Assert.assertEquals((Object)c1.getMarkDeletedPosition(), (Object)p3);
        Assert.assertEquals((Map)c1.getProperties(), properties);
    }

    @Test
    void testPropertiesAtCreation() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger_at_creation", new ManagedLedgerConfig());
        TreeMap<String, Long> properties = new TreeMap<String, Long>();
        properties.put("a", 1L);
        properties.put("b", 2L);
        properties.put("c", 3L);
        ManagedCursor c1 = ledger.openCursor("c1", CommandSubscribe.InitialPosition.Latest, properties);
        Assert.assertEquals((Map)c1.getProperties(), properties);
        ledger.addEntry("entry-1".getBytes());
        ledger.close();
        ledger = this.factory.open("my_test_ledger_at_creation", new ManagedLedgerConfig());
        c1 = ledger.openCursor("c1");
        Assert.assertEquals((Map)c1.getProperties(), properties);
    }
}

