/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.ManagedLedgerConfig;
import org.apache.bookkeeper.mledger.ManagedLedgerInfo;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.bookkeeper.test.MockedBookKeeperTestCase;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ManagedLedgerFactoryTest
extends MockedBookKeeperTestCase {
    @Test(timeOut=20000L)
    public void testGetManagedLedgerInfoWithClose() throws Exception {
        ManagedLedgerConfig conf = new ManagedLedgerConfig();
        conf.setMaxEntriesPerLedger(1);
        ManagedLedgerImpl ledger = (ManagedLedgerImpl)this.factory.open("testGetManagedLedgerInfo", conf);
        ManagedCursor c1 = ledger.openCursor("c1");
        PositionImpl p1 = (PositionImpl)ledger.addEntry("entry1".getBytes());
        PositionImpl p2 = (PositionImpl)ledger.addEntry("entry2".getBytes());
        PositionImpl p3 = (PositionImpl)ledger.addEntry("entry3".getBytes());
        ledger.addEntry("entry4".getBytes());
        c1.delete((Position)p2);
        c1.delete((Position)p3);
        ledger.close();
        ManagedLedgerInfo info = this.factory.getManagedLedgerInfo("testGetManagedLedgerInfo");
        Assert.assertEquals((int)info.ledgers.size(), (int)4);
        Assert.assertEquals((long)((ManagedLedgerInfo.LedgerInfo)info.ledgers.get((int)0)).ledgerId, (long)3L);
        Assert.assertEquals((long)((ManagedLedgerInfo.LedgerInfo)info.ledgers.get((int)1)).ledgerId, (long)5L);
        Assert.assertEquals((long)((ManagedLedgerInfo.LedgerInfo)info.ledgers.get((int)2)).ledgerId, (long)6L);
        Assert.assertEquals((long)((ManagedLedgerInfo.LedgerInfo)info.ledgers.get((int)3)).ledgerId, (long)7L);
        Assert.assertEquals((int)info.cursors.size(), (int)1);
        ManagedLedgerInfo.CursorInfo cursorInfo = (ManagedLedgerInfo.CursorInfo)info.cursors.get("c1");
        Assert.assertEquals((long)cursorInfo.markDelete.ledgerId, (long)3L);
        Assert.assertEquals((long)cursorInfo.markDelete.entryId, (long)-1L);
        Assert.assertEquals((int)cursorInfo.individualDeletedMessages.size(), (int)2);
        ManagedLedgerInfo.MessageRangeInfo mri = (ManagedLedgerInfo.MessageRangeInfo)cursorInfo.individualDeletedMessages.get(0);
        Assert.assertEquals((long)mri.from.ledgerId, (long)p2.getLedgerId());
        Assert.assertEquals((long)mri.from.entryId, (long)-1L);
        Assert.assertEquals((long)mri.to.ledgerId, (long)p2.getLedgerId());
        Assert.assertEquals((long)mri.to.entryId, (long)0L);
    }
}

