/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.api.ReadHandle;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.ManagedLedgerFactoryConfig;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.impl.EntryCache;
import org.apache.bookkeeper.mledger.impl.EntryCacheManager;
import org.apache.bookkeeper.mledger.impl.EntryCacheTest;
import org.apache.bookkeeper.mledger.impl.EntryImpl;
import org.apache.bookkeeper.mledger.impl.ManagedCursorImpl;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerFactoryImpl;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerMBeanImpl;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.bookkeeper.test.MockedBookKeeperTestCase;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

public class EntryCacheManagerTest
extends MockedBookKeeperTestCase {
    ManagedLedgerImpl ml1;
    ManagedLedgerImpl ml2;

    @Override
    protected void setUpTestCase() throws Exception {
        OrderedScheduler executor = (OrderedScheduler)OrderedScheduler.newSchedulerBuilder().numThreads(1).build();
        this.ml1 = (ManagedLedgerImpl)Mockito.mock(ManagedLedgerImpl.class);
        Mockito.when((Object)this.ml1.getScheduledExecutor()).thenReturn((Object)executor);
        Mockito.when((Object)this.ml1.getName()).thenReturn((Object)"cache1");
        Mockito.when((Object)this.ml1.getMBean()).thenReturn((Object)new ManagedLedgerMBeanImpl(this.ml1));
        Mockito.when((Object)this.ml1.getExecutor()).thenReturn((Object)this.executor);
        this.ml2 = (ManagedLedgerImpl)Mockito.mock(ManagedLedgerImpl.class);
        Mockito.when((Object)this.ml2.getScheduledExecutor()).thenReturn((Object)executor);
        Mockito.when((Object)this.ml2.getName()).thenReturn((Object)"cache2");
    }

    @Test
    public void simple() throws Exception {
        ManagedLedgerFactoryConfig config = new ManagedLedgerFactoryConfig();
        config.setMaxCacheSize(10L);
        config.setCacheEvictionWatermark(0.8);
        this.factory = new ManagedLedgerFactoryImpl((BookKeeper)this.bkc, this.bkc.getZkHandle(), config);
        EntryCacheManager cacheManager = this.factory.getEntryCacheManager();
        EntryCache cache1 = cacheManager.getEntryCache(this.ml1);
        EntryCache cache2 = cacheManager.getEntryCache(this.ml2);
        cache1.insert(EntryImpl.create((long)1L, (long)1L, (byte[])new byte[4]));
        cache1.insert(EntryImpl.create((long)1L, (long)0L, (byte[])new byte[3]));
        Assert.assertEquals((long)cache1.getSize(), (long)7L);
        Assert.assertEquals((long)cacheManager.getSize(), (long)7L);
        cacheManager.mlFactoryMBean.refreshStats(1L, TimeUnit.SECONDS);
        Assert.assertEquals((long)cacheManager.mlFactoryMBean.getCacheMaxSize(), (long)10L);
        Assert.assertEquals((long)cacheManager.mlFactoryMBean.getCacheUsedSize(), (long)7L);
        Assert.assertEquals((double)cacheManager.mlFactoryMBean.getCacheHitsRate(), (double)0.0);
        Assert.assertEquals((double)cacheManager.mlFactoryMBean.getCacheMissesRate(), (double)0.0);
        Assert.assertEquals((double)cacheManager.mlFactoryMBean.getCacheHitsThroughput(), (double)0.0);
        Assert.assertEquals((long)cacheManager.mlFactoryMBean.getNumberOfCacheEvictions(), (long)0L);
        cache2.insert(EntryImpl.create((long)2L, (long)0L, (byte[])new byte[1]));
        cache2.insert(EntryImpl.create((long)2L, (long)1L, (byte[])new byte[1]));
        cache2.insert(EntryImpl.create((long)2L, (long)2L, (byte[])new byte[1]));
        Assert.assertEquals((long)cache2.getSize(), (long)3L);
        Assert.assertEquals((long)cacheManager.getSize(), (long)10L);
        cache2.insert(EntryImpl.create((long)2L, (long)3L, (byte[])new byte[1]));
        Thread.sleep(100L);
        Assert.assertEquals((long)cacheManager.getSize(), (long)7L);
        Assert.assertEquals((long)cache1.getSize(), (long)4L);
        Assert.assertEquals((long)cache2.getSize(), (long)3L);
        cacheManager.removeEntryCache("cache1");
        Assert.assertEquals((long)cacheManager.getSize(), (long)3L);
        Assert.assertEquals((long)cache2.getSize(), (long)3L);
        cache2.invalidateEntries(new PositionImpl(2L, 1L));
        Assert.assertEquals((long)cacheManager.getSize(), (long)2L);
        Assert.assertEquals((long)cache2.getSize(), (long)2L);
        cacheManager.mlFactoryMBean.refreshStats(1L, TimeUnit.SECONDS);
        Assert.assertEquals((long)cacheManager.mlFactoryMBean.getCacheMaxSize(), (long)10L);
        Assert.assertEquals((long)cacheManager.mlFactoryMBean.getCacheUsedSize(), (long)2L);
        Assert.assertEquals((double)cacheManager.mlFactoryMBean.getCacheHitsRate(), (double)0.0);
        Assert.assertEquals((double)cacheManager.mlFactoryMBean.getCacheMissesRate(), (double)0.0);
        Assert.assertEquals((double)cacheManager.mlFactoryMBean.getCacheHitsThroughput(), (double)0.0);
        Assert.assertEquals((long)cacheManager.mlFactoryMBean.getNumberOfCacheEvictions(), (long)1L);
    }

    @Test
    public void doubleInsert() throws Exception {
        ManagedLedgerFactoryConfig config = new ManagedLedgerFactoryConfig();
        config.setMaxCacheSize(10L);
        config.setCacheEvictionWatermark(0.8);
        this.factory = new ManagedLedgerFactoryImpl((BookKeeper)this.bkc, this.bkc.getZkHandle(), config);
        EntryCacheManager cacheManager = this.factory.getEntryCacheManager();
        EntryCache cache1 = cacheManager.getEntryCache(this.ml1);
        Assert.assertTrue((boolean)cache1.insert(EntryImpl.create((long)1L, (long)1L, (byte[])new byte[4])));
        Assert.assertTrue((boolean)cache1.insert(EntryImpl.create((long)1L, (long)0L, (byte[])new byte[3])));
        Assert.assertEquals((long)cache1.getSize(), (long)7L);
        Assert.assertEquals((long)cacheManager.getSize(), (long)7L);
        Assert.assertFalse((boolean)cache1.insert(EntryImpl.create((long)1L, (long)0L, (byte[])new byte[5])));
        Assert.assertEquals((long)cache1.getSize(), (long)7L);
        Assert.assertEquals((long)cacheManager.getSize(), (long)7L);
    }

    @Test
    public void cacheSizeUpdate() throws Exception {
        ManagedLedgerFactoryConfig config = new ManagedLedgerFactoryConfig();
        config.setMaxCacheSize(200L);
        config.setCacheEvictionWatermark(0.8);
        this.factory = new ManagedLedgerFactoryImpl((BookKeeper)this.bkc, this.bkc.getZkHandle(), config);
        EntryCacheManager cacheManager = this.factory.getEntryCacheManager();
        EntryCache cache1 = cacheManager.getEntryCache(this.ml1);
        ArrayList<EntryImpl> entries = new ArrayList<EntryImpl>();
        for (int i = 0; i < 20; ++i) {
            entries.add(EntryImpl.create((long)1L, (long)i, (byte[])new byte[i + 1]));
            Assert.assertTrue((boolean)cache1.insert((EntryImpl)entries.get(i)));
        }
        Assert.assertEquals((long)210L, (long)cacheManager.getSize());
        Random random = new Random();
        for (int i = 0; i < 20; ++i) {
            if (!random.nextBoolean()) continue;
            ((EntryImpl)entries.get(i)).getDataBuffer().readBytes(new byte[((EntryImpl)entries.get(i)).getDataBuffer().readableBytes()]);
        }
        cacheManager.removeEntryCache(this.ml1.getName());
        Assert.assertTrue((cacheManager.getSize() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void cacheDisabled() throws Exception {
        ManagedLedgerFactoryConfig config = new ManagedLedgerFactoryConfig();
        config.setMaxCacheSize(0L);
        config.setCacheEvictionWatermark(0.8);
        this.factory = new ManagedLedgerFactoryImpl((BookKeeper)this.bkc, this.bkc.getZkHandle(), config);
        EntryCacheManager cacheManager = this.factory.getEntryCacheManager();
        EntryCache cache1 = cacheManager.getEntryCache(this.ml1);
        EntryCache cache2 = cacheManager.getEntryCache(this.ml2);
        Assert.assertTrue((boolean)(cache1 instanceof EntryCacheManager.EntryCacheDisabled));
        Assert.assertTrue((boolean)(cache2 instanceof EntryCacheManager.EntryCacheDisabled));
        cache1.insert(EntryImpl.create((long)1L, (long)1L, (byte[])new byte[4]));
        cache1.insert(EntryImpl.create((long)1L, (long)0L, (byte[])new byte[3]));
        Assert.assertEquals((long)cache1.getSize(), (long)0L);
        Assert.assertEquals((long)cacheManager.getSize(), (long)0L);
        cacheManager.mlFactoryMBean.refreshStats(1L, TimeUnit.SECONDS);
        Assert.assertEquals((long)cacheManager.mlFactoryMBean.getCacheMaxSize(), (long)0L);
        Assert.assertEquals((long)cacheManager.mlFactoryMBean.getCacheUsedSize(), (long)0L);
        Assert.assertEquals((double)cacheManager.mlFactoryMBean.getCacheHitsRate(), (double)0.0);
        Assert.assertEquals((double)cacheManager.mlFactoryMBean.getCacheMissesRate(), (double)0.0);
        Assert.assertEquals((double)cacheManager.mlFactoryMBean.getCacheHitsThroughput(), (double)0.0);
        Assert.assertEquals((long)cacheManager.mlFactoryMBean.getNumberOfCacheEvictions(), (long)0L);
        cache2.insert(EntryImpl.create((long)2L, (long)0L, (byte[])new byte[1]));
        cache2.insert(EntryImpl.create((long)2L, (long)1L, (byte[])new byte[1]));
        cache2.insert(EntryImpl.create((long)2L, (long)2L, (byte[])new byte[1]));
        Assert.assertEquals((long)cache2.getSize(), (long)0L);
        Assert.assertEquals((long)cacheManager.getSize(), (long)0L);
    }

    @Test
    public void verifyNoCacheIfNoConsumer() throws Exception {
        ManagedLedgerFactoryConfig config = new ManagedLedgerFactoryConfig();
        config.setMaxCacheSize(70L);
        config.setCacheEvictionWatermark(0.8);
        this.factory = new ManagedLedgerFactoryImpl((BookKeeper)this.bkc, this.bkc.getZkHandle(), config);
        EntryCacheManager cacheManager = this.factory.getEntryCacheManager();
        ManagedLedgerImpl ledger = (ManagedLedgerImpl)this.factory.open("ledger");
        EntryCache cache1 = ledger.entryCache;
        for (int i = 0; i < 10; ++i) {
            ledger.addEntry(("entry-" + i).getBytes());
        }
        Assert.assertEquals((long)cache1.getSize(), (long)0L);
        Assert.assertEquals((long)cacheManager.getSize(), (long)0L);
        cacheManager.mlFactoryMBean.refreshStats(1L, TimeUnit.SECONDS);
        Assert.assertEquals((long)cacheManager.mlFactoryMBean.getCacheMaxSize(), (long)70L);
        Assert.assertEquals((long)cacheManager.mlFactoryMBean.getCacheUsedSize(), (long)0L);
        Assert.assertEquals((double)cacheManager.mlFactoryMBean.getCacheHitsRate(), (double)0.0);
        Assert.assertEquals((double)cacheManager.mlFactoryMBean.getCacheMissesRate(), (double)0.0);
        Assert.assertEquals((double)cacheManager.mlFactoryMBean.getCacheHitsThroughput(), (double)0.0);
        Assert.assertEquals((long)cacheManager.mlFactoryMBean.getNumberOfCacheEvictions(), (long)0L);
    }

    @Test
    public void verifyHitsMisses() throws Exception {
        ManagedLedgerFactoryConfig config = new ManagedLedgerFactoryConfig();
        config.setMaxCacheSize(70L);
        config.setCacheEvictionWatermark(0.8);
        config.setCacheEvictionFrequency(1.0);
        this.factory = new ManagedLedgerFactoryImpl((BookKeeper)this.bkc, this.bkc.getZkHandle(), config);
        EntryCacheManager cacheManager = this.factory.getEntryCacheManager();
        ManagedLedgerImpl ledger = (ManagedLedgerImpl)this.factory.open("ledger");
        ManagedCursorImpl c1 = (ManagedCursorImpl)ledger.openCursor("c1");
        ManagedCursorImpl c2 = (ManagedCursorImpl)ledger.openCursor("c2");
        for (int i = 0; i < 10; ++i) {
            ledger.addEntry(("entry-" + i).getBytes());
        }
        cacheManager.mlFactoryMBean.refreshStats(1L, TimeUnit.SECONDS);
        Assert.assertEquals((long)cacheManager.mlFactoryMBean.getCacheUsedSize(), (long)70L);
        Assert.assertEquals((double)cacheManager.mlFactoryMBean.getCacheHitsRate(), (double)0.0);
        Assert.assertEquals((double)cacheManager.mlFactoryMBean.getCacheMissesRate(), (double)0.0);
        Assert.assertEquals((double)cacheManager.mlFactoryMBean.getCacheHitsThroughput(), (double)0.0);
        Assert.assertEquals((long)cacheManager.mlFactoryMBean.getNumberOfCacheEvictions(), (long)0L);
        List entries = c1.readEntries(10);
        Assert.assertEquals((int)entries.size(), (int)10);
        entries.forEach(e -> e.release());
        cacheManager.mlFactoryMBean.refreshStats(1L, TimeUnit.SECONDS);
        Assert.assertEquals((long)cacheManager.mlFactoryMBean.getCacheUsedSize(), (long)70L);
        Assert.assertEquals((double)cacheManager.mlFactoryMBean.getCacheHitsRate(), (double)10.0);
        Assert.assertEquals((double)cacheManager.mlFactoryMBean.getCacheMissesRate(), (double)0.0);
        Assert.assertEquals((double)cacheManager.mlFactoryMBean.getCacheHitsThroughput(), (double)70.0);
        Assert.assertEquals((long)cacheManager.mlFactoryMBean.getNumberOfCacheEvictions(), (long)0L);
        ledger.deactivateCursor((ManagedCursor)c1);
        cacheManager.mlFactoryMBean.refreshStats(1L, TimeUnit.SECONDS);
        Assert.assertEquals((long)cacheManager.mlFactoryMBean.getCacheUsedSize(), (long)70L);
        Assert.assertEquals((double)cacheManager.mlFactoryMBean.getCacheHitsRate(), (double)0.0);
        Assert.assertEquals((double)cacheManager.mlFactoryMBean.getCacheMissesRate(), (double)0.0);
        Assert.assertEquals((double)cacheManager.mlFactoryMBean.getCacheHitsThroughput(), (double)0.0);
        Assert.assertEquals((long)cacheManager.mlFactoryMBean.getNumberOfCacheEvictions(), (long)0L);
        entries = c2.readEntries(10);
        Assert.assertEquals((int)entries.size(), (int)10);
        cacheManager.mlFactoryMBean.refreshStats(1L, TimeUnit.SECONDS);
        Assert.assertEquals((long)cacheManager.mlFactoryMBean.getCacheUsedSize(), (long)70L);
        Assert.assertEquals((double)cacheManager.mlFactoryMBean.getCacheHitsRate(), (double)10.0);
        Assert.assertEquals((double)cacheManager.mlFactoryMBean.getCacheMissesRate(), (double)0.0);
        Assert.assertEquals((double)cacheManager.mlFactoryMBean.getCacheHitsThroughput(), (double)70.0);
        Assert.assertEquals((long)cacheManager.mlFactoryMBean.getNumberOfCacheEvictions(), (long)0L);
        PositionImpl pos = (PositionImpl)((Entry)entries.get(entries.size() - 1)).getPosition();
        c2.setReadPosition((Position)pos);
        ledger.discardEntriesFromCache(c2, pos);
        entries.forEach(e -> e.release());
        cacheManager.mlFactoryMBean.refreshStats(1L, TimeUnit.SECONDS);
        Assert.assertEquals((long)cacheManager.mlFactoryMBean.getCacheUsedSize(), (long)7L);
        Assert.assertEquals((double)cacheManager.mlFactoryMBean.getCacheHitsRate(), (double)0.0);
        Assert.assertEquals((double)cacheManager.mlFactoryMBean.getCacheMissesRate(), (double)0.0);
        Assert.assertEquals((double)cacheManager.mlFactoryMBean.getCacheHitsThroughput(), (double)0.0);
        Assert.assertEquals((long)cacheManager.mlFactoryMBean.getNumberOfCacheEvictions(), (long)0L);
    }

    @Test
    public void verifyTimeBasedEviction() throws Exception {
        ManagedLedgerFactoryConfig config = new ManagedLedgerFactoryConfig();
        config.setMaxCacheSize(1000L);
        config.setCacheEvictionFrequency(100.0);
        config.setCacheEvictionTimeThresholdMillis(100L);
        ManagedLedgerFactoryImpl factory = new ManagedLedgerFactoryImpl((BookKeeper)this.bkc, this.bkc.getZkHandle(), config);
        ManagedLedgerImpl ledger = (ManagedLedgerImpl)factory.open("test");
        ManagedCursor c1 = ledger.openCursor("c1");
        c1.setActive();
        ManagedCursor c2 = ledger.openCursor("c2");
        c2.setActive();
        EntryCacheManager cacheManager = factory.getEntryCacheManager();
        Assert.assertEquals((long)cacheManager.getSize(), (long)0L);
        EntryCache cache = cacheManager.getEntryCache(ledger);
        Assert.assertEquals((long)cache.getSize(), (long)0L);
        ledger.addEntry(new byte[4]);
        ledger.addEntry(new byte[3]);
        Thread.sleep(1000L);
        c1.close();
        c2.close();
        Assert.assertEquals((long)cacheManager.getSize(), (long)0L);
        Assert.assertEquals((long)cache.getSize(), (long)0L);
        factory.shutdown();
    }

    @Test(timeOut=5000L)
    void entryCacheDisabledAsyncReadEntry() throws Exception {
        ReadHandle lh = EntryCacheTest.getLedgerHandle();
        ManagedLedgerFactoryConfig config = new ManagedLedgerFactoryConfig();
        config.setMaxCacheSize(0L);
        ManagedLedgerFactoryImpl factory = new ManagedLedgerFactoryImpl((BookKeeper)this.bkc, this.bkc.getZkHandle(), config);
        EntryCacheManager cacheManager = factory.getEntryCacheManager();
        EntryCache entryCache = cacheManager.getEntryCache(this.ml1);
        final CountDownLatch counter = new CountDownLatch(1);
        entryCache.asyncReadEntry(lh, new PositionImpl(1L, 1L), new AsyncCallbacks.ReadEntryCallback(){

            public void readEntryComplete(Entry entry, Object ctx) {
                Assert.assertNotEquals((Object)entry, null);
                entry.release();
                counter.countDown();
            }

            public void readEntryFailed(ManagedLedgerException exception, Object ctx) {
                Assert.fail((String)"should not have failed");
                counter.countDown();
            }
        }, null);
        counter.await();
        ((ReadHandle)Mockito.verify((Object)lh)).readAsync(ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong());
    }
}

