/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.test;

import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.PulsarMockBookKeeper;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.mledger.ManagedLedgerFactoryConfig;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerFactoryImpl;
import org.apache.bookkeeper.util.ZkUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.MockZooKeeper;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;

public abstract class MockedBookKeeperTestCase {
    static final Logger LOG = LoggerFactory.getLogger(MockedBookKeeperTestCase.class);
    protected MockZooKeeper zkc;
    protected PulsarMockBookKeeper bkc;
    protected int numBookies;
    protected ManagedLedgerFactoryImpl factory;
    protected ClientConfiguration baseClientConf = new ClientConfiguration();
    protected OrderedScheduler executor;
    protected ExecutorService cachedExecutor;

    public MockedBookKeeperTestCase() {
        this(3);
    }

    public MockedBookKeeperTestCase(int numBookies) {
        this.numBookies = numBookies;
    }

    @BeforeMethod
    public void setUp(Method method) throws Exception {
        LOG.info(">>>>>> starting {}", (Object)method);
        try {
            this.startBookKeeper();
        }
        catch (Exception e) {
            LOG.error("Error setting up", (Throwable)e);
            throw e;
        }
        ManagedLedgerFactoryConfig conf = new ManagedLedgerFactoryConfig();
        this.factory = new ManagedLedgerFactoryImpl((BookKeeper)this.bkc, (ZooKeeper)this.zkc, conf);
        this.zkc.create("/managed-ledgers", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown(Method method) {
        try {
            LOG.info("@@@@@@@@@ stopping " + method);
            this.factory.shutdown();
            this.factory = null;
            this.stopBookKeeper();
            this.stopZooKeeper();
            LOG.info("--------- stopped {}", (Object)method);
        }
        catch (Exception e) {
            LOG.error("tearDown Error", (Throwable)e);
        }
    }

    @BeforeClass
    public void setUpClass() {
        this.executor = (OrderedScheduler)OrderedScheduler.newSchedulerBuilder().numThreads(2).name("test").build();
        this.cachedExecutor = Executors.newCachedThreadPool();
    }

    @AfterClass
    public void tearDownClass() {
        this.executor.shutdown();
        this.cachedExecutor.shutdown();
    }

    protected void startBookKeeper() throws Exception {
        this.zkc = MockZooKeeper.newInstance();
        for (int i = 0; i < this.numBookies; ++i) {
            ZkUtils.createFullPathOptimistic((ZooKeeper)this.zkc, (String)("/ledgers/available/192.168.1.1:" + (5000 + i)), (byte[])"".getBytes(), null, null);
        }
        this.zkc.create("/ledgers/LAYOUT", "1\nflat:1".getBytes(), null, null);
        this.bkc = new PulsarMockBookKeeper((ZooKeeper)this.zkc, (ExecutorService)this.executor.chooseThread((Object)this));
    }

    protected void stopBookKeeper() throws Exception {
        this.bkc.shutdown();
    }

    protected void stopZooKeeper() throws Exception {
        this.zkc.shutdown();
    }
}

