/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.util;

import java.util.BitSet;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.bookkeeper.mledger.util.PositionAckSetUtil;
import org.apache.pulsar.common.util.collections.BitSetRecyclable;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PositionAckSetUtilTest {
    @Test
    public void isAckSetRepeatedTest() {
        BitSet thisBitSet = new BitSet();
        BitSet otherBitSet = new BitSet();
        thisBitSet.set(0, 64);
        otherBitSet.set(0, 64);
        thisBitSet.clear(1, 5);
        otherBitSet.clear(1, 6);
        Assert.assertTrue((boolean)PositionAckSetUtil.isAckSetOverlap((long[])thisBitSet.toLongArray(), (long[])otherBitSet.toLongArray()));
        otherBitSet.set(1, 5);
        Assert.assertFalse((boolean)PositionAckSetUtil.isAckSetOverlap((long[])thisBitSet.toLongArray(), (long[])otherBitSet.toLongArray()));
    }

    @Test
    public void compareToWithAckSetForCumulativeAckTest() {
        PositionImpl positionOne = PositionImpl.get((long)1L, (long)1L);
        PositionImpl positionTwo = PositionImpl.get((long)1L, (long)2L);
        Assert.assertEquals((int)PositionAckSetUtil.compareToWithAckSet((PositionImpl)positionOne, (PositionImpl)positionTwo), (int)-1);
        positionTwo = PositionImpl.get((long)2L, (long)1L);
        Assert.assertEquals((int)PositionAckSetUtil.compareToWithAckSet((PositionImpl)positionOne, (PositionImpl)positionTwo), (int)-1);
        positionTwo = PositionImpl.get((long)0L, (long)1L);
        Assert.assertEquals((int)PositionAckSetUtil.compareToWithAckSet((PositionImpl)positionOne, (PositionImpl)positionTwo), (int)1);
        positionTwo = PositionImpl.get((long)1L, (long)0L);
        Assert.assertEquals((int)PositionAckSetUtil.compareToWithAckSet((PositionImpl)positionOne, (PositionImpl)positionTwo), (int)1);
        positionTwo = PositionImpl.get((long)1L, (long)1L);
        Assert.assertEquals((int)PositionAckSetUtil.compareToWithAckSet((PositionImpl)positionOne, (PositionImpl)positionTwo), (int)0);
        BitSet bitSetOne = new BitSet();
        BitSet bitSetTwo = new BitSet();
        bitSetOne.set(0, 63);
        bitSetTwo.set(0, 63);
        bitSetOne.clear(0, 10);
        bitSetTwo.clear(0, 10);
        positionOne.setAckSet(bitSetOne.toLongArray());
        positionTwo.setAckSet(bitSetTwo.toLongArray());
        Assert.assertEquals((int)PositionAckSetUtil.compareToWithAckSet((PositionImpl)positionOne, (PositionImpl)positionTwo), (int)0);
        bitSetOne.clear(10, 12);
        positionOne.setAckSet(bitSetOne.toLongArray());
        Assert.assertEquals((int)PositionAckSetUtil.compareToWithAckSet((PositionImpl)positionOne, (PositionImpl)positionTwo), (int)2);
        bitSetOne.set(8, 12);
        positionOne.setAckSet(bitSetOne.toLongArray());
        Assert.assertEquals((int)PositionAckSetUtil.compareToWithAckSet((PositionImpl)positionOne, (PositionImpl)positionTwo), (int)-2);
    }

    @Test
    public void andAckSetTest() {
        PositionImpl positionOne = PositionImpl.get((long)1L, (long)1L);
        PositionImpl positionTwo = PositionImpl.get((long)1L, (long)2L);
        BitSet bitSetOne = new BitSet();
        BitSet bitSetTwo = new BitSet();
        bitSetOne.set(0);
        bitSetOne.set(2);
        bitSetOne.set(4);
        bitSetOne.set(6);
        bitSetOne.set(8);
        positionOne.setAckSet(bitSetOne.toLongArray());
        positionTwo.setAckSet(bitSetTwo.toLongArray());
        PositionAckSetUtil.andAckSet((PositionImpl)positionOne, (PositionImpl)positionTwo);
        BitSetRecyclable bitSetRecyclable = BitSetRecyclable.valueOf((long[])positionOne.getAckSet());
        Assert.assertTrue((boolean)bitSetRecyclable.isEmpty());
        bitSetTwo.set(2);
        bitSetTwo.set(4);
        positionOne.setAckSet(bitSetOne.toLongArray());
        positionTwo.setAckSet(bitSetTwo.toLongArray());
        PositionAckSetUtil.andAckSet((PositionImpl)positionOne, (PositionImpl)positionTwo);
        bitSetRecyclable = BitSetRecyclable.valueOf((long[])positionOne.getAckSet());
        BitSetRecyclable bitSetRecyclableTwo = BitSetRecyclable.valueOf((long[])bitSetTwo.toLongArray());
        Assert.assertEquals((Object)bitSetRecyclable, (Object)bitSetRecyclableTwo);
    }
}

