/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.bookkeeper.mledger.ManagedLedgerConfig;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerFactoryImpl;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.bookkeeper.test.MockedBookKeeperTestCase;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.MockZooKeeper;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ManagedLedgerErrorsTest
extends MockedBookKeeperTestCase {
    private static final Logger log = LoggerFactory.getLogger(ManagedLedgerErrorsTest.class);

    @Test
    public void removingCursor() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger");
        ManagedCursor c1 = ledger.openCursor("c1");
        Assert.assertNotNull((Object)this.zkc.exists("/managed-ledgers/my_test_ledger/c1", false));
        this.zkc.failConditional(KeeperException.Code.BADVERSION, (op, path) -> op == MockZooKeeper.Op.SET && path.equals("/managed-ledgers/my_test_ledger/c1"));
        try {
            c1.close();
            Assert.fail((String)"should fail");
        }
        catch (ManagedLedgerException managedLedgerException) {
            // empty catch block
        }
        this.bkc.failNow(-7);
        ledger.deleteCursor("c1");
        Assert.assertNull((Object)this.zkc.exists("/managed-ledgers/my_test_ledger/c1", false));
        Assert.assertEquals((int)this.bkc.getLedgers().size(), (int)2);
    }

    @Test
    public void removingCursor2() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger");
        ledger.openCursor("c1");
        this.zkc.failConditional(KeeperException.Code.CONNECTIONLOSS, (op, path) -> op == MockZooKeeper.Op.DELETE && path.equals("/managed-ledgers/my_test_ledger/c1"));
        try {
            ledger.deleteCursor("c1");
            Assert.fail((String)"should fail");
        }
        catch (ManagedLedgerException managedLedgerException) {
            // empty catch block
        }
    }

    @Test
    public void closingManagedLedger() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger");
        ledger.openCursor("c1");
        ledger.addEntry("entry".getBytes());
        this.bkc.failNow(-7);
        try {
            ledger.close();
            Assert.fail((String)"should fail");
        }
        catch (ManagedLedgerException managedLedgerException) {
            // empty catch block
        }
        try {
            ledger.addEntry("entry".getBytes());
            Assert.fail((String)"managed ledger was closed");
        }
        catch (ManagedLedgerException managedLedgerException) {
            // empty catch block
        }
    }

    @Test
    public void asyncClosingManagedLedger() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger");
        ledger.openCursor("c1");
        this.bkc.failNow(-7);
        final CountDownLatch latch = new CountDownLatch(1);
        ledger.asyncClose(new AsyncCallbacks.CloseCallback(){

            public void closeFailed(ManagedLedgerException exception, Object ctx) {
                latch.countDown();
            }

            public void closeComplete(Object ctx) {
                Assert.fail((String)"should have failed");
            }
        }, null);
        latch.await();
    }

    @Test
    public void errorInRecovering() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger");
        ledger.addEntry("entry".getBytes());
        ledger.close();
        this.factory = new ManagedLedgerFactoryImpl((BookKeeper)this.bkc, (ZooKeeper)this.zkc);
        this.bkc.failNow(-101);
        try {
            ledger = this.factory.open("my_test_ledger");
            Assert.fail((String)"should fail");
        }
        catch (ManagedLedgerException managedLedgerException) {
            // empty catch block
        }
        ledger = this.factory.open("my_test_ledger");
    }

    @Test
    public void errorInRecovering2() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger");
        ledger.addEntry("entry".getBytes());
        ledger.close();
        this.factory = new ManagedLedgerFactoryImpl((BookKeeper)this.bkc, (ZooKeeper)this.zkc);
        this.bkc.failAfter(1, -101);
        try {
            ledger = this.factory.open("my_test_ledger");
            Assert.fail((String)"should fail");
        }
        catch (ManagedLedgerException managedLedgerException) {
            // empty catch block
        }
        ledger = this.factory.open("my_test_ledger");
    }

    @Test
    public void errorInRecovering3() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger");
        ledger.addEntry("entry".getBytes());
        ledger.close();
        this.factory = new ManagedLedgerFactoryImpl((BookKeeper)this.bkc, (ZooKeeper)this.zkc);
        this.bkc.failAfter(1, -101);
        try {
            ledger = this.factory.open("my_test_ledger");
            Assert.fail((String)"should fail");
        }
        catch (ManagedLedgerException managedLedgerException) {
            // empty catch block
        }
        ledger = this.factory.open("my_test_ledger");
    }

    @Test
    public void errorInRecovering4() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger");
        ledger.addEntry("entry".getBytes());
        ledger.close();
        this.factory = new ManagedLedgerFactoryImpl((BookKeeper)this.bkc, (ZooKeeper)this.zkc);
        this.zkc.failConditional(KeeperException.Code.CONNECTIONLOSS, (op, path) -> path.equals("/managed-ledgers/my_test_ledger") && op == MockZooKeeper.Op.SET);
        try {
            ledger = this.factory.open("my_test_ledger");
            Assert.fail((String)"should fail");
        }
        catch (ManagedLedgerException managedLedgerException) {
            // empty catch block
        }
        ledger = this.factory.open("my_test_ledger");
    }

    @Test
    public void errorInRecovering5() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger");
        ledger.addEntry("entry".getBytes());
        ledger.close();
        this.factory = new ManagedLedgerFactoryImpl((BookKeeper)this.bkc, (ZooKeeper)this.zkc);
        this.zkc.failConditional(KeeperException.Code.CONNECTIONLOSS, (op, path) -> path.equals("/managed-ledgers/my_test_ledger") && op == MockZooKeeper.Op.GET_CHILDREN);
        try {
            ledger = this.factory.open("my_test_ledger");
            Assert.fail((String)"should fail");
        }
        catch (ManagedLedgerException managedLedgerException) {
            // empty catch block
        }
        ledger = this.factory.open("my_test_ledger");
    }

    @Test
    public void errorInRecovering6() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger");
        ledger.openCursor("c1");
        ledger.addEntry("entry".getBytes());
        ledger.close();
        this.factory = new ManagedLedgerFactoryImpl((BookKeeper)this.bkc, (ZooKeeper)this.zkc);
        this.zkc.failConditional(KeeperException.Code.CONNECTIONLOSS, (op, path) -> path.equals("/managed-ledgers/my_test_ledger/c1") && op == MockZooKeeper.Op.GET);
        try {
            ledger = this.factory.open("my_test_ledger");
            Assert.fail((String)"should fail");
        }
        catch (ManagedLedgerException managedLedgerException) {
            // empty catch block
        }
        ledger = this.factory.open("my_test_ledger");
    }

    @Test
    public void passwordError() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger", new ManagedLedgerConfig().setPassword("password"));
        ledger.openCursor("c1");
        ledger.addEntry("entry".getBytes());
        ledger.close();
        try {
            ledger = this.factory.open("my_test_ledger", new ManagedLedgerConfig().setPassword("wrong-password"));
            Assert.fail((String)"should fail for password error");
        }
        catch (ManagedLedgerException managedLedgerException) {
            // empty catch block
        }
    }

    @Test
    public void digestError() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger", new ManagedLedgerConfig().setDigestType(DigestType.CRC32));
        ledger.openCursor("c1");
        ledger.addEntry("entry".getBytes());
        ledger.close();
        try {
            ledger = this.factory.open("my_test_ledger", new ManagedLedgerConfig().setDigestType(DigestType.MAC));
            Assert.fail((String)"should fail for digest error");
        }
        catch (ManagedLedgerException managedLedgerException) {
            // empty catch block
        }
    }

    @Test(timeOut=20000L, invocationCount=1, skipFailedInvocations=true, enabled=false)
    public void errorInUpdatingLedgersList() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger", new ManagedLedgerConfig().setMaxEntriesPerLedger(1));
        final CompletableFuture promise = new CompletableFuture();
        this.zkc.failConditional(KeeperException.Code.CONNECTIONLOSS, (op, path) -> path.equals("/managed-ledgers/my_test_ledger") && op == MockZooKeeper.Op.SET);
        ledger.asyncAddEntry("entry".getBytes(), new AsyncCallbacks.AddEntryCallback(){

            public void addFailed(ManagedLedgerException exception, Object ctx) {
            }

            public void addComplete(Position position, Object ctx) {
            }
        }, null);
        ledger.asyncAddEntry("entry".getBytes(), new AsyncCallbacks.AddEntryCallback(){

            public void addFailed(ManagedLedgerException exception, Object ctx) {
                promise.complete(null);
            }

            public void addComplete(Position position, Object ctx) {
                promise.completeExceptionally(new Exception("should have failed"));
            }
        }, null);
        promise.get();
    }

    @Test
    public void recoverAfterZnodeVersionError() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger", new ManagedLedgerConfig().setMaxEntriesPerLedger(1));
        this.zkc.failConditional(KeeperException.Code.BADVERSION, (op, path) -> path.equals("/managed-ledgers/my_test_ledger") && op == MockZooKeeper.Op.SET);
        ledger.addEntry("test".getBytes());
        try {
            ledger.addEntry("entry".getBytes());
            Assert.fail((String)"should fail");
        }
        catch (ManagedLedgerException.ManagedLedgerFencedException e) {
            Assert.assertEquals(e.getCause().getClass(), ManagedLedgerException.BadVersionException.class);
        }
        try {
            ledger.addEntry("entry".getBytes());
            Assert.fail((String)"should fail");
        }
        catch (ManagedLedgerException.ManagedLedgerFencedException managedLedgerFencedException) {
            // empty catch block
        }
    }

    @Test
    public void recoverAfterWriteError() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger");
        ManagedCursor cursor = ledger.openCursor("c1");
        this.bkc.failNow(-8);
        ledger.addEntry("entry-1".getBytes());
        Assert.assertEquals((long)cursor.getNumberOfEntriesInBacklog(false), (long)1L);
        this.bkc.failNow(-8);
        this.zkc.failConditional(KeeperException.Code.CONNECTIONLOSS, (op, path) -> path.equals("/managed-ledgers/my_test_ledger") && op == MockZooKeeper.Op.SET);
        try {
            ledger.addEntry("entry-2".getBytes());
            Assert.fail((String)"should fail");
        }
        catch (ManagedLedgerException managedLedgerException) {
            // empty catch block
        }
        this.bkc.failNow(-6);
        try {
            ledger.addEntry("entry-3".getBytes());
            Assert.fail((String)"should fail");
        }
        catch (ManagedLedgerException managedLedgerException) {
            // empty catch block
        }
        Assert.assertEquals((long)cursor.getNumberOfEntriesInBacklog(false), (long)1L);
        ledger.readyToCreateNewLedger();
        ledger.addEntry("entry-4".getBytes());
        Assert.assertEquals((long)cursor.getNumberOfEntriesInBacklog(false), (long)2L);
        List entries = cursor.readEntries(10);
        Assert.assertEquals((int)entries.size(), (int)2);
        Assert.assertEquals((String)new String(((Entry)entries.get(0)).getData()), (String)"entry-1");
        Assert.assertEquals((String)new String(((Entry)entries.get(1)).getData()), (String)"entry-4");
        entries.forEach(e -> e.release());
    }

    @Test
    public void recoverLongTimeAfterMultipleWriteErrors() throws Exception {
        ManagedLedgerImpl ledger = (ManagedLedgerImpl)this.factory.open("recoverLongTimeAfterMultipleWriteErrors");
        ManagedCursor cursor = ledger.openCursor("c1");
        this.bkc.failAfter(0, -8);
        this.bkc.failAfter(1, -8);
        final CountDownLatch counter = new CountDownLatch(2);
        final AtomicReference ex = new AtomicReference();
        AsyncCallbacks.AddEntryCallback cb = new AsyncCallbacks.AddEntryCallback(){

            public void addComplete(Position position, Object ctx) {
                counter.countDown();
            }

            public void addFailed(ManagedLedgerException exception, Object ctx) {
                log.warn("Error in write", (Throwable)exception);
                ex.set(exception);
                counter.countDown();
            }
        };
        ledger.asyncAddEntry("entry-1".getBytes(), cb, null);
        ledger.asyncAddEntry("entry-2".getBytes(), cb, null);
        counter.await();
        Assert.assertNull(ex.get());
        Assert.assertEquals((long)cursor.getNumberOfEntriesInBacklog(false), (long)2L);
        Assert.assertEquals((int)ledger.getLedgersInfoAsList().size(), (int)1);
        ledger.addEntry("entry-3".getBytes());
        List entries = cursor.readEntries(10);
        Assert.assertEquals((int)entries.size(), (int)3);
        Assert.assertEquals((String)new String(((Entry)entries.get(0)).getData()), (String)"entry-1");
        Assert.assertEquals((String)new String(((Entry)entries.get(1)).getData()), (String)"entry-2");
        Assert.assertEquals((String)new String(((Entry)entries.get(2)).getData()), (String)"entry-3");
        entries.forEach(e -> e.release());
    }

    @Test
    public void recoverAfterMarkDeleteError() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger");
        ManagedCursor cursor = ledger.openCursor("my-cursor");
        Position position = ledger.addEntry("entry".getBytes());
        this.bkc.failNow(-8);
        this.zkc.failConditional(KeeperException.Code.CONNECTIONLOSS, (op, path) -> path.equals("/managed-ledgers/my_test_ledger/my-cursor") && op == MockZooKeeper.Op.SET);
        try {
            cursor.markDelete(position);
            Assert.fail((String)"should fail");
        }
        catch (ManagedLedgerException managedLedgerException) {
            // empty catch block
        }
        Thread.sleep(100L);
        cursor.markDelete(position);
    }

    @Test
    public void handleCursorRecoveryFailure() throws Exception {
        ManagedLedger ledger = this.factory.open("my_test_ledger");
        ManagedCursor cursor = ledger.openCursor("my-cursor");
        Position p0 = cursor.getMarkDeletedPosition();
        Position p1 = ledger.addEntry("entry-1".getBytes());
        cursor.markDelete(p1);
        ManagedLedgerFactoryImpl factory2 = new ManagedLedgerFactoryImpl((BookKeeper)this.bkc, (ZooKeeper)this.zkc);
        this.bkc.failAfter(3, -10);
        ledger = factory2.open("my_test_ledger");
        cursor = ledger.openCursor("my-cursor");
        Assert.assertEquals((Object)cursor.getMarkDeletedPosition(), (Object)p0);
        factory2.shutdown();
    }
}

