/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.ManagedCursorMXBean;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.impl.ManagedCursorContainer;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ManagedCursorContainerTest {
    @Test
    public void simple() throws Exception {
        ManagedCursorContainer container = new ManagedCursorContainer();
        Assert.assertNull((Object)container.getSlowestReaderPosition());
        MockManagedCursor cursor1 = new MockManagedCursor(container, "test1", (Position)new PositionImpl(5L, 5L));
        container.add((ManagedCursor)cursor1);
        Assert.assertEquals((Object)container.getSlowestReaderPosition(), (Object)new PositionImpl(5L, 5L));
        MockManagedCursor cursor2 = new MockManagedCursor(container, "test2", (Position)new PositionImpl(2L, 2L));
        container.add((ManagedCursor)cursor2);
        Assert.assertEquals((Object)container.getSlowestReaderPosition(), (Object)new PositionImpl(2L, 2L));
        MockManagedCursor cursor3 = new MockManagedCursor(container, "test3", (Position)new PositionImpl(2L, 0L));
        container.add((ManagedCursor)cursor3);
        Assert.assertEquals((Object)container.getSlowestReaderPosition(), (Object)new PositionImpl(2L, 0L));
        Assert.assertEquals((String)container.toString(), (String)"[test1=5:5, test2=2:2, test3=2:0]");
        MockManagedCursor cursor4 = new MockManagedCursor(container, "test4", (Position)new PositionImpl(4L, 0L));
        container.add((ManagedCursor)cursor4);
        Assert.assertEquals((Object)container.getSlowestReaderPosition(), (Object)new PositionImpl(2L, 0L));
        MockManagedCursor cursor5 = new MockManagedCursor(container, "test5", (Position)new PositionImpl(3L, 5L));
        container.add((ManagedCursor)cursor5);
        Assert.assertEquals((Object)container.getSlowestReaderPosition(), (Object)new PositionImpl(2L, 0L));
        cursor3.markDelete((Position)new PositionImpl(3L, 0L));
        Assert.assertEquals((Object)container.getSlowestReaderPosition(), (Object)new PositionImpl(2L, 2L));
        cursor2.markDelete((Position)new PositionImpl(10L, 5L));
        Assert.assertEquals((Object)container.getSlowestReaderPosition(), (Object)new PositionImpl(3L, 0L));
        container.removeCursor(cursor3.getName());
        Assert.assertEquals((Object)container.getSlowestReaderPosition(), (Object)new PositionImpl(3L, 5L));
        container.removeCursor(cursor2.getName());
        container.removeCursor(cursor5.getName());
        container.removeCursor(cursor1.getName());
        Assert.assertEquals((Object)container.getSlowestReaderPosition(), (Object)new PositionImpl(4L, 0L));
        Assert.assertTrue((boolean)container.hasDurableCursors());
        container.removeCursor(cursor4.getName());
        Assert.assertNull((Object)container.getSlowestReaderPosition());
        Assert.assertFalse((boolean)container.hasDurableCursors());
        MockManagedCursor cursor6 = new MockManagedCursor(container, "test6", (Position)new PositionImpl(6L, 5L));
        container.add((ManagedCursor)cursor6);
        Assert.assertEquals((Object)container.getSlowestReaderPosition(), (Object)new PositionImpl(6L, 5L));
        Assert.assertEquals((String)container.toString(), (String)"[test6=6:5]");
    }

    @Test
    public void updatingCursorOutsideContainer() throws Exception {
        ManagedCursorContainer container = new ManagedCursorContainer();
        MockManagedCursor cursor1 = new MockManagedCursor(container, "test1", (Position)new PositionImpl(5L, 5L));
        container.add((ManagedCursor)cursor1);
        Assert.assertEquals((Object)container.getSlowestReaderPosition(), (Object)new PositionImpl(5L, 5L));
        MockManagedCursor cursor2 = new MockManagedCursor(container, "test2", (Position)new PositionImpl(2L, 2L));
        container.add((ManagedCursor)cursor2);
        Assert.assertEquals((Object)container.getSlowestReaderPosition(), (Object)new PositionImpl(2L, 2L));
        cursor2.position = new PositionImpl(8L, 8L);
        Assert.assertEquals((Object)container.getSlowestReaderPosition(), (Object)new PositionImpl(2L, 2L));
        container.cursorUpdated((ManagedCursor)cursor2, cursor2.position);
        Assert.assertEquals((Object)container.getSlowestReaderPosition(), (Object)new PositionImpl(5L, 5L));
    }

    @Test
    public void removingCursor() throws Exception {
        ManagedCursorContainer container = new ManagedCursorContainer();
        MockManagedCursor cursor1 = new MockManagedCursor(container, "test1", (Position)new PositionImpl(5L, 5L));
        container.add((ManagedCursor)cursor1);
        Assert.assertEquals((Object)container.getSlowestReaderPosition(), (Object)new PositionImpl(5L, 5L));
        Assert.assertEquals((Object)container.get("test1"), (Object)cursor1);
        MockManagedCursor cursor2 = new MockManagedCursor(container, "test2", (Position)new PositionImpl(2L, 2L));
        container.add((ManagedCursor)cursor2);
        Assert.assertEquals((Object)container.getSlowestReaderPosition(), (Object)new PositionImpl(2L, 2L));
        Assert.assertEquals((Object)container.get("test2"), (Object)cursor2);
        MockManagedCursor cursor3 = new MockManagedCursor(container, "test3", (Position)new PositionImpl(1L, 1L));
        container.add((ManagedCursor)cursor3);
        Assert.assertEquals((Object)container.getSlowestReaderPosition(), (Object)new PositionImpl(1L, 1L));
        Assert.assertEquals((Object)container.get("test3"), (Object)cursor3);
        Assert.assertEquals((Iterable)container, (Iterable)Lists.newArrayList((Object[])new ManagedCursor[]{cursor1, cursor2, cursor3}));
        container.removeCursor("test2");
        Assert.assertEquals((Iterable)container, (Iterable)Lists.newArrayList((Object[])new ManagedCursor[]{cursor1, cursor3}));
        Assert.assertNull((Object)container.get("test2"));
        Assert.assertEquals((Object)container.getSlowestReaderPosition(), (Object)new PositionImpl(1L, 1L));
        container.removeCursor("test3");
        Assert.assertEquals((Iterable)container, (Iterable)Lists.newArrayList((Object[])new ManagedCursor[]{cursor1}));
        Assert.assertEquals((Object)container.getSlowestReaderPosition(), (Object)new PositionImpl(5L, 5L));
    }

    @Test
    public void ordering() throws Exception {
        ManagedCursorContainer container = new ManagedCursorContainer();
        MockManagedCursor cursor1 = new MockManagedCursor(container, "test1", (Position)new PositionImpl(5L, 5L));
        MockManagedCursor cursor2 = new MockManagedCursor(container, "test2", (Position)new PositionImpl(5L, 1L));
        MockManagedCursor cursor3 = new MockManagedCursor(container, "test3", (Position)new PositionImpl(7L, 1L));
        MockManagedCursor cursor4 = new MockManagedCursor(container, "test4", (Position)new PositionImpl(6L, 4L));
        MockManagedCursor cursor5 = new MockManagedCursor(container, "test5", (Position)new PositionImpl(7L, 0L));
        container.add((ManagedCursor)cursor1);
        container.add((ManagedCursor)cursor2);
        container.add((ManagedCursor)cursor3);
        container.add((ManagedCursor)cursor4);
        container.add((ManagedCursor)cursor5);
        Assert.assertEquals((Object)container.getSlowestReaderPosition(), (Object)new PositionImpl(5L, 1L));
        container.removeCursor("test2");
        Assert.assertEquals((Object)container.getSlowestReaderPosition(), (Object)new PositionImpl(5L, 5L));
        container.removeCursor("test1");
        Assert.assertEquals((Object)container.getSlowestReaderPosition(), (Object)new PositionImpl(6L, 4L));
        container.removeCursor("test4");
        Assert.assertEquals((Object)container.getSlowestReaderPosition(), (Object)new PositionImpl(7L, 0L));
        container.removeCursor("test5");
        Assert.assertEquals((Object)container.getSlowestReaderPosition(), (Object)new PositionImpl(7L, 1L));
        container.removeCursor("test3");
        Assert.assertFalse((boolean)container.hasDurableCursors());
    }

    @Test
    public void orderingWithUpdates() throws Exception {
        ManagedCursorContainer container = new ManagedCursorContainer();
        MockManagedCursor c1 = new MockManagedCursor(container, "test1", (Position)new PositionImpl(5L, 5L));
        MockManagedCursor c2 = new MockManagedCursor(container, "test2", (Position)new PositionImpl(5L, 1L));
        MockManagedCursor c3 = new MockManagedCursor(container, "test3", (Position)new PositionImpl(7L, 1L));
        MockManagedCursor c4 = new MockManagedCursor(container, "test4", (Position)new PositionImpl(6L, 4L));
        MockManagedCursor c5 = new MockManagedCursor(container, "test5", (Position)new PositionImpl(7L, 0L));
        container.add((ManagedCursor)c1);
        container.add((ManagedCursor)c2);
        container.add((ManagedCursor)c3);
        container.add((ManagedCursor)c4);
        container.add((ManagedCursor)c5);
        Assert.assertEquals((Object)container.getSlowestReaderPosition(), (Object)new PositionImpl(5L, 1L));
        c1.position = new PositionImpl(5L, 8L);
        container.cursorUpdated((ManagedCursor)c1, c1.position);
        Assert.assertEquals((Object)container.getSlowestReaderPosition(), (Object)new PositionImpl(5L, 1L));
        c2.position = new PositionImpl(5L, 6L);
        container.cursorUpdated((ManagedCursor)c2, c2.position);
        Assert.assertEquals((Object)container.getSlowestReaderPosition(), (Object)new PositionImpl(5L, 6L));
        c1.position = new PositionImpl(6L, 8L);
        container.cursorUpdated((ManagedCursor)c1, c1.position);
        Assert.assertEquals((Object)container.getSlowestReaderPosition(), (Object)new PositionImpl(5L, 6L));
        c3.position = new PositionImpl(8L, 5L);
        container.cursorUpdated((ManagedCursor)c3, c3.position);
        Assert.assertEquals((Object)container.getSlowestReaderPosition(), (Object)new PositionImpl(5L, 6L));
        c1.position = new PositionImpl(8L, 4L);
        container.cursorUpdated((ManagedCursor)c1, c1.position);
        Assert.assertEquals((Object)container.getSlowestReaderPosition(), (Object)new PositionImpl(5L, 6L));
        c2.position = new PositionImpl(8L, 4L);
        container.cursorUpdated((ManagedCursor)c2, c2.position);
        Assert.assertEquals((Object)container.getSlowestReaderPosition(), (Object)new PositionImpl(6L, 4L));
        c4.position = new PositionImpl(7L, 1L);
        container.cursorUpdated((ManagedCursor)c4, c4.position);
        Assert.assertEquals((Object)container.getSlowestReaderPosition(), (Object)new PositionImpl(7L, 0L));
        container.removeCursor("test5");
        Assert.assertEquals((Object)container.getSlowestReaderPosition(), (Object)new PositionImpl(7L, 1L));
        container.removeCursor("test4");
        Assert.assertEquals((Object)container.getSlowestReaderPosition(), (Object)new PositionImpl(8L, 4L));
        container.removeCursor("test1");
        Assert.assertEquals((Object)container.getSlowestReaderPosition(), (Object)new PositionImpl(8L, 4L));
        container.removeCursor("test2");
        Assert.assertEquals((Object)container.getSlowestReaderPosition(), (Object)new PositionImpl(8L, 5L));
        container.removeCursor("test3");
        Assert.assertFalse((boolean)container.hasDurableCursors());
    }

    @Test
    public void orderingWithUpdatesAndReset() throws Exception {
        ManagedCursorContainer container = new ManagedCursorContainer();
        MockManagedCursor c1 = new MockManagedCursor(container, "test1", (Position)new PositionImpl(5L, 5L));
        MockManagedCursor c2 = new MockManagedCursor(container, "test2", (Position)new PositionImpl(5L, 1L));
        MockManagedCursor c3 = new MockManagedCursor(container, "test3", (Position)new PositionImpl(7L, 1L));
        MockManagedCursor c4 = new MockManagedCursor(container, "test4", (Position)new PositionImpl(6L, 4L));
        MockManagedCursor c5 = new MockManagedCursor(container, "test5", (Position)new PositionImpl(7L, 0L));
        container.add((ManagedCursor)c1);
        container.add((ManagedCursor)c2);
        container.add((ManagedCursor)c3);
        container.add((ManagedCursor)c4);
        container.add((ManagedCursor)c5);
        Assert.assertEquals((Object)container.getSlowestReaderPosition(), (Object)new PositionImpl(5L, 1L));
        c1.position = new PositionImpl(5L, 8L);
        container.cursorUpdated((ManagedCursor)c1, c1.position);
        Assert.assertEquals((Object)container.getSlowestReaderPosition(), (Object)new PositionImpl(5L, 1L));
        c1.position = new PositionImpl(5L, 6L);
        container.cursorUpdated((ManagedCursor)c1, c1.position);
        Assert.assertEquals((Object)container.getSlowestReaderPosition(), (Object)new PositionImpl(5L, 1L));
        c2.position = new PositionImpl(6L, 8L);
        container.cursorUpdated((ManagedCursor)c2, c2.position);
        Assert.assertEquals((Object)container.getSlowestReaderPosition(), (Object)new PositionImpl(5L, 6L));
        c3.position = new PositionImpl(8L, 5L);
        container.cursorUpdated((ManagedCursor)c3, c3.position);
        Assert.assertEquals((Object)container.getSlowestReaderPosition(), (Object)new PositionImpl(5L, 6L));
        c1.position = new PositionImpl(8L, 4L);
        container.cursorUpdated((ManagedCursor)c1, c1.position);
        Assert.assertEquals((Object)container.getSlowestReaderPosition(), (Object)new PositionImpl(6L, 4L));
        c2.position = new PositionImpl(4L, 4L);
        container.cursorUpdated((ManagedCursor)c2, c2.position);
        Assert.assertEquals((Object)container.getSlowestReaderPosition(), (Object)new PositionImpl(4L, 4L));
        c4.position = new PositionImpl(7L, 1L);
        container.cursorUpdated((ManagedCursor)c4, c4.position);
        Assert.assertEquals((Object)container.getSlowestReaderPosition(), (Object)new PositionImpl(4L, 4L));
        container.removeCursor("test2");
        Assert.assertEquals((Object)container.getSlowestReaderPosition(), (Object)new PositionImpl(7L, 0L));
        container.removeCursor("test5");
        Assert.assertEquals((Object)container.getSlowestReaderPosition(), (Object)new PositionImpl(7L, 1L));
        container.removeCursor("test1");
        Assert.assertEquals((Object)container.getSlowestReaderPosition(), (Object)new PositionImpl(7L, 1L));
        container.removeCursor("test4");
        Assert.assertEquals((Object)container.getSlowestReaderPosition(), (Object)new PositionImpl(8L, 5L));
        container.removeCursor("test3");
        Assert.assertFalse((boolean)container.hasDurableCursors());
    }

    private static class MockManagedCursor
    implements ManagedCursor {
        ManagedCursorContainer container;
        Position position;
        String name;

        public MockManagedCursor(ManagedCursorContainer container, String name, Position position) {
            this.container = container;
            this.name = name;
            this.position = position;
        }

        public Map<String, Long> getProperties() {
            return Collections.emptyMap();
        }

        public boolean isDurable() {
            return true;
        }

        public List<Entry> readEntries(int numberOfEntriesToRead) throws ManagedLedgerException {
            return Lists.newArrayList();
        }

        public void asyncReadEntries(int numberOfEntriesToRead, AsyncCallbacks.ReadEntriesCallback callback, Object ctx) {
            callback.readEntriesComplete(null, ctx);
        }

        public void asyncReadEntries(int numberOfEntriesToRead, long maxSizeBytes, AsyncCallbacks.ReadEntriesCallback callback, Object ctx) {
            callback.readEntriesComplete(null, ctx);
        }

        public boolean hasMoreEntries() {
            return true;
        }

        public long getNumberOfEntries() {
            return 0L;
        }

        public long getNumberOfEntriesInBacklog(boolean isPrecise) {
            return 0L;
        }

        public void markDelete(Position position) throws ManagedLedgerException {
            this.markDelete(position, Collections.emptyMap());
        }

        public void markDelete(Position position, Map<String, Long> properties) throws ManagedLedgerException {
            this.position = position;
            this.container.cursorUpdated((ManagedCursor)this, (Position)((PositionImpl)position));
        }

        public void asyncMarkDelete(Position position, AsyncCallbacks.MarkDeleteCallback callback, Object ctx) {
            Assert.fail();
        }

        public void asyncMarkDelete(Position position, Map<String, Long> properties, AsyncCallbacks.MarkDeleteCallback callback, Object ctx) {
            Assert.fail();
        }

        public Position getMarkDeletedPosition() {
            return this.position;
        }

        public String getName() {
            return this.name;
        }

        public long getLastActive() {
            return System.currentTimeMillis();
        }

        public void updateLastActive() {
        }

        public String toString() {
            return String.format("%s=%s", this.name, this.position);
        }

        public Position getReadPosition() {
            return null;
        }

        public void rewind() {
        }

        public void seek(Position newReadPosition) {
        }

        public void close() {
        }

        public void asyncClose(AsyncCallbacks.CloseCallback callback, Object ctx) {
        }

        public void delete(Position position) throws InterruptedException, ManagedLedgerException {
        }

        public void asyncDelete(Position position, AsyncCallbacks.DeleteCallback callback, Object ctx) {
        }

        public void delete(Iterable<Position> positions) throws InterruptedException, ManagedLedgerException {
        }

        public void asyncDelete(Iterable<Position> position, AsyncCallbacks.DeleteCallback callback, Object ctx) {
        }

        public void clearBacklog() throws InterruptedException, ManagedLedgerException {
        }

        public void asyncClearBacklog(AsyncCallbacks.ClearBacklogCallback callback, Object ctx) {
        }

        public void skipEntries(int numEntriesToSkip, ManagedCursor.IndividualDeletedEntries deletedEntries) throws InterruptedException, ManagedLedgerException {
        }

        public void asyncSkipEntries(int numEntriesToSkip, ManagedCursor.IndividualDeletedEntries deletedEntries, AsyncCallbacks.SkipEntriesCallback callback, Object ctx) {
        }

        public Position findNewestMatching(Predicate<Entry> condition) throws InterruptedException, ManagedLedgerException {
            return null;
        }

        public Position findNewestMatching(ManagedCursor.FindPositionConstraint constraint, Predicate<Entry> condition) throws InterruptedException, ManagedLedgerException {
            return null;
        }

        public void asyncFindNewestMatching(ManagedCursor.FindPositionConstraint constraint, Predicate<Entry> condition, AsyncCallbacks.FindEntryCallback callback, Object ctx) {
        }

        public void asyncResetCursor(Position position, AsyncCallbacks.ResetCursorCallback callback) {
        }

        public void resetCursor(Position position) throws ManagedLedgerException, InterruptedException {
        }

        public Position getFirstPosition() {
            return null;
        }

        public void setAlwaysInactive() {
        }

        public List<Entry> replayEntries(Set<? extends Position> positions) throws InterruptedException, ManagedLedgerException {
            return null;
        }

        public Set<? extends Position> asyncReplayEntries(Set<? extends Position> positions, AsyncCallbacks.ReadEntriesCallback callback, Object ctx) {
            return Sets.newConcurrentHashSet();
        }

        public Set<? extends Position> asyncReplayEntries(Set<? extends Position> positions, AsyncCallbacks.ReadEntriesCallback callback, Object ctx, boolean sortEntries) {
            return Sets.newConcurrentHashSet();
        }

        public List<Entry> readEntriesOrWait(int numberOfEntriesToRead) throws InterruptedException, ManagedLedgerException {
            return null;
        }

        public void asyncReadEntriesOrWait(int numberOfEntriesToRead, AsyncCallbacks.ReadEntriesCallback callback, Object ctx) {
        }

        public boolean cancelPendingReadRequest() {
            return true;
        }

        public Entry getNthEntry(int N, ManagedCursor.IndividualDeletedEntries deletedEntries) throws InterruptedException, ManagedLedgerException {
            return null;
        }

        public void asyncGetNthEntry(int N, ManagedCursor.IndividualDeletedEntries deletedEntries, AsyncCallbacks.ReadEntryCallback callback, Object ctx) {
        }

        public void setActive() {
        }

        public void setInactive() {
        }

        public boolean isActive() {
            return true;
        }

        public long getNumberOfEntriesSinceFirstNotAckedMessage() {
            return 0L;
        }

        public int getTotalNonContiguousDeletedMessagesRange() {
            return 0;
        }

        public int getNonContiguousDeletedMessagesRangeSerializedSize() {
            return 0;
        }

        public long getEstimatedSizeSinceMarkDeletePosition() {
            return 0L;
        }

        public void setThrottleMarkDelete(double throttleMarkDelete) {
        }

        public double getThrottleMarkDelete() {
            return -1.0;
        }

        public ManagedLedger getManagedLedger() {
            return null;
        }

        public Range<PositionImpl> getLastIndividualDeletedRange() {
            return null;
        }

        public void trimDeletedEntries(List<Entry> entries) {
        }

        public long[] getDeletedBatchIndexesAsLongArray(PositionImpl position) {
            return new long[0];
        }

        public ManagedCursorMXBean getStats() {
            return null;
        }

        public void asyncReadEntriesOrWait(int maxEntries, long maxSizeBytes, AsyncCallbacks.ReadEntriesCallback callback, Object ctx) {
        }

        public List<Entry> readEntriesOrWait(int maxEntries, long maxSizeBytes) throws InterruptedException, ManagedLedgerException {
            return null;
        }
    }
}

