/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import com.google.common.base.Predicate;
import java.util.Optional;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.impl.ManagedCursorImpl;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OpFindNewest
implements AsyncCallbacks.ReadEntryCallback {
    private static final Logger log = LoggerFactory.getLogger(OpFindNewest.class);
    private final ManagedCursorImpl cursor;
    private final PositionImpl startPosition;
    private final AsyncCallbacks.FindEntryCallback callback;
    private final Predicate<Entry> condition;
    private final Object ctx;
    PositionImpl searchPosition;
    long min;
    long max;
    Position lastMatchedPosition = null;
    State state;

    public OpFindNewest(ManagedCursorImpl cursor, PositionImpl startPosition, Predicate<Entry> condition, long numberOfEntries, AsyncCallbacks.FindEntryCallback callback, Object ctx) {
        this.cursor = cursor;
        this.startPosition = startPosition;
        this.callback = callback;
        this.condition = condition;
        this.ctx = ctx;
        this.min = 0L;
        this.max = numberOfEntries;
        this.searchPosition = startPosition;
        this.state = State.checkFirst;
    }

    @Override
    public void readEntryComplete(Entry entry, Object ctx) {
        Position position = entry.getPosition();
        switch (this.state) {
            case checkFirst: {
                if (!this.condition.apply((Object)entry)) {
                    this.callback.findEntryComplete(null, this.ctx);
                    return;
                }
                this.lastMatchedPosition = position;
                this.state = State.checkLast;
                PositionImpl lastPosition = this.cursor.ledger.getLastPosition();
                this.searchPosition = this.cursor.ledger.getPositionAfterN(this.searchPosition, this.max, ManagedLedgerImpl.PositionBound.startExcluded);
                if (lastPosition.compareTo(this.searchPosition) < 0) {
                    if (log.isDebugEnabled()) {
                        log.debug("first position {} matches, last should be {}, but moving to lastPos {}", new Object[]{position, this.searchPosition, lastPosition});
                    }
                    this.searchPosition = lastPosition;
                }
                this.find();
                break;
            }
            case checkLast: {
                if (this.condition.apply((Object)entry)) {
                    this.callback.findEntryComplete(position, this.ctx);
                    return;
                }
                this.state = State.searching;
                this.searchPosition = this.cursor.ledger.getPositionAfterN(this.startPosition, this.mid(), ManagedLedgerImpl.PositionBound.startExcluded);
                this.find();
                break;
            }
            case searching: {
                if (this.condition.apply((Object)entry)) {
                    this.lastMatchedPosition = position;
                    this.min = this.mid();
                } else {
                    this.max = this.mid() - 1L;
                }
                if (this.max <= this.min) {
                    this.callback.findEntryComplete(this.lastMatchedPosition, this.ctx);
                    return;
                }
                this.searchPosition = this.cursor.ledger.getPositionAfterN(this.startPosition, this.mid(), ManagedLedgerImpl.PositionBound.startExcluded);
                this.find();
            }
        }
    }

    @Override
    public void readEntryFailed(ManagedLedgerException exception, Object ctx) {
        this.callback.findEntryFailed(exception, Optional.ofNullable(this.searchPosition), this.ctx);
    }

    public void find() {
        if (this.cursor.hasMoreEntries(this.searchPosition)) {
            this.cursor.ledger.asyncReadEntry(this.searchPosition, this, null);
        } else {
            this.callback.findEntryComplete(this.lastMatchedPosition, this.ctx);
        }
    }

    private long mid() {
        return this.min + Math.max((this.max - this.min) / 2L, 1L);
    }

    static enum State {
        checkFirst,
        checkLast,
        searching;

    }
}

