/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.impl.MetaStore;
import org.apache.bookkeeper.mledger.impl.MetaStoreImpl;
import org.apache.bookkeeper.mledger.proto.MLDataFormats;
import org.apache.bookkeeper.test.MockedBookKeeperTestCase;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.Stat;
import org.apache.pulsar.metadata.impl.zookeeper.ZKMetadataStore;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.MockZooKeeper;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MetaStoreImplTest
extends MockedBookKeeperTestCase {
    @Test
    void getMLList() throws Exception {
        MetaStoreImpl store = new MetaStoreImpl((MetadataStore)new ZKMetadataStore((ZooKeeper)this.zkc), (OrderedExecutor)this.executor);
        this.zkc.failConditional(KeeperException.Code.CONNECTIONLOSS, (op, path) -> op == MockZooKeeper.Op.GET_CHILDREN && path.equals("/managed-ledgers"));
        try {
            store.getManagedLedgers();
            Assert.fail((String)"should fail in getting the list");
        }
        catch (ManagedLedgerException.MetaStoreException metaStoreException) {
            // empty catch block
        }
    }

    @Test
    void deleteNonExistingML() throws Exception {
        MetaStoreImpl store = new MetaStoreImpl((MetadataStore)new ZKMetadataStore((ZooKeeper)this.zkc), (OrderedExecutor)this.executor);
        final AtomicReference exception = new AtomicReference();
        final CountDownLatch counter = new CountDownLatch(1);
        store.removeManagedLedger("non-existing", (MetaStore.MetaStoreCallback)new MetaStore.MetaStoreCallback<Void>(){

            public void operationComplete(Void result, Stat version) {
                counter.countDown();
            }

            public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                exception.set(e);
                counter.countDown();
            }
        });
        counter.await();
        Assert.assertNotNull(exception.get());
    }

    @Test(timeOut=20000L)
    void readMalformedML() throws Exception {
        MetaStoreImpl store = new MetaStoreImpl((MetadataStore)new ZKMetadataStore((ZooKeeper)this.zkc), (OrderedExecutor)this.executor);
        this.zkc.create("/managed-ledgers/my_test", "non-valid".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        final CountDownLatch latch = new CountDownLatch(1);
        store.getManagedLedgerInfo("my_test", false, (MetaStore.MetaStoreCallback)new MetaStore.MetaStoreCallback<MLDataFormats.ManagedLedgerInfo>(){

            public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                latch.countDown();
            }

            public void operationComplete(MLDataFormats.ManagedLedgerInfo result, Stat version) {
                Assert.fail((String)"Operation should have failed");
            }
        });
        latch.await();
    }

    @Test(timeOut=20000L)
    void readMalformedCursorNode() throws Exception {
        MetaStoreImpl store = new MetaStoreImpl((MetadataStore)new ZKMetadataStore((ZooKeeper)this.zkc), (OrderedExecutor)this.executor);
        this.zkc.create("/managed-ledgers/my_test", "".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zkc.create("/managed-ledgers/my_test/c1", "non-valid".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        final CountDownLatch latch = new CountDownLatch(1);
        store.asyncGetCursorInfo("my_test", "c1", (MetaStore.MetaStoreCallback)new MetaStore.MetaStoreCallback<MLDataFormats.ManagedCursorInfo>(){

            public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                latch.countDown();
            }

            public void operationComplete(MLDataFormats.ManagedCursorInfo result, Stat version) {
                Assert.fail((String)"Operation should have failed");
            }
        });
        latch.await();
    }

    @Test(timeOut=20000L)
    void failInCreatingMLnode() throws Exception {
        MetaStoreImpl store = new MetaStoreImpl((MetadataStore)new ZKMetadataStore((ZooKeeper)this.zkc), (OrderedExecutor)this.executor);
        final CompletableFuture promise = new CompletableFuture();
        this.zkc.failConditional(KeeperException.Code.CONNECTIONLOSS, (op, path) -> op == MockZooKeeper.Op.CREATE);
        store.getManagedLedgerInfo("my_test", false, (MetaStore.MetaStoreCallback)new MetaStore.MetaStoreCallback<MLDataFormats.ManagedLedgerInfo>(){

            public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                promise.complete(null);
            }

            public void operationComplete(MLDataFormats.ManagedLedgerInfo result, Stat version) {
                promise.completeExceptionally(new Exception("Operation should have failed"));
            }
        });
        promise.get();
    }

    @Test(timeOut=20000L)
    void updatingCursorNode() throws Exception {
        MetaStoreImpl store = new MetaStoreImpl((MetadataStore)new ZKMetadataStore((ZooKeeper)this.zkc), (OrderedExecutor)this.executor);
        this.zkc.create("/managed-ledgers/my_test", "".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        final CompletableFuture promise = new CompletableFuture();
        MLDataFormats.ManagedCursorInfo info = MLDataFormats.ManagedCursorInfo.newBuilder().setCursorsLedgerId(1L).build();
        store.asyncUpdateCursorInfo("my_test", "c1", info, null, (MetaStore.MetaStoreCallback)new MetaStore.MetaStoreCallback<Void>((MetaStore)store){
            final /* synthetic */ MetaStore val$store;
            {
                this.val$store = metaStore;
            }

            public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                promise.completeExceptionally((Throwable)e);
            }

            public void operationComplete(Void result, Stat version) {
                MetaStoreImplTest.this.zkc.failConditional(KeeperException.Code.CONNECTIONLOSS, (op, path) -> op == MockZooKeeper.Op.SET && path.contains("my_test") && path.contains("c1"));
                MLDataFormats.ManagedCursorInfo info = MLDataFormats.ManagedCursorInfo.newBuilder().setCursorsLedgerId(2L).build();
                this.val$store.asyncUpdateCursorInfo("my_test", "c1", info, version, (MetaStore.MetaStoreCallback)new MetaStore.MetaStoreCallback<Void>(){

                    public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                        promise.complete(null);
                    }

                    public void operationComplete(Void result, Stat version) {
                        promise.completeExceptionally(new Exception("should have failed"));
                    }
                });
            }
        });
        promise.get();
    }

    @Test(timeOut=20000L)
    void updatingMLNode() throws Exception {
        MetaStoreImpl store = new MetaStoreImpl((MetadataStore)new ZKMetadataStore((ZooKeeper)this.zkc), (OrderedExecutor)this.executor);
        this.zkc.create("/managed-ledgers/my_test", "".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        final CompletableFuture promise = new CompletableFuture();
        store.getManagedLedgerInfo("my_test", false, (MetaStore.MetaStoreCallback)new MetaStore.MetaStoreCallback<MLDataFormats.ManagedLedgerInfo>((MetaStore)store){
            final /* synthetic */ MetaStore val$store;
            {
                this.val$store = metaStore;
            }

            public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                promise.completeExceptionally((Throwable)e);
            }

            public void operationComplete(MLDataFormats.ManagedLedgerInfo mlInfo, Stat version) {
                MetaStoreImplTest.this.zkc.failConditional(KeeperException.Code.BADVERSION, (op, path) -> op == MockZooKeeper.Op.SET && path.contains("my_test"));
                this.val$store.asyncUpdateLedgerIds("my_test", mlInfo, version, (MetaStore.MetaStoreCallback)new MetaStore.MetaStoreCallback<Void>(){

                    public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                        promise.complete(null);
                    }

                    public void operationComplete(Void result, Stat version) {
                        promise.completeExceptionally(new Exception("should have failed"));
                    }
                });
            }
        });
        promise.get();
    }
}

