/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.test;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.bookkeeper.zookeeper.ZooKeeperClient;
import org.apache.commons.io.FileUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.test.ClientBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;

public class ZooKeeperUtil {
    static final Logger LOG = LoggerFactory.getLogger(ZooKeeperUtil.class);
    protected int zooKeeperPort;
    private InetSocketAddress zkaddr;
    protected ZooKeeperServer zks;
    protected ZooKeeper zkc;
    protected NIOServerCnxnFactory serverFactory;
    protected File ZkTmpDir;
    private String connectString;

    public ZooKeeper getZooKeeperClient() {
        return this.zkc;
    }

    public String getZooKeeperConnectString() {
        return this.connectString;
    }

    public void startServer() throws Exception {
        LOG.debug("Running ZK server");
        ClientBase.setupTestEnv();
        this.ZkTmpDir = File.createTempFile("zookeeper", "test");
        this.ZkTmpDir.delete();
        this.ZkTmpDir.mkdir();
        this.zks = new ZooKeeperServer(this.ZkTmpDir, this.ZkTmpDir, 3000);
        this.serverFactory = new NIOServerCnxnFactory();
        this.serverFactory.configure(this.zkaddr, 100);
        this.serverFactory.startup(this.zks);
        this.zooKeeperPort = this.serverFactory.getLocalPort();
        this.zkaddr = new InetSocketAddress(this.zooKeeperPort);
        this.connectString = "localhost:" + this.zooKeeperPort;
        boolean b = ClientBase.waitForServerUp((String)this.getZooKeeperConnectString(), (long)ClientBase.CONNECTION_TIMEOUT);
        LOG.debug("Server up: " + b);
        LOG.debug("Instantiate ZK Client");
        this.zkc = ZooKeeperClient.newBuilder().connectString(this.getZooKeeperConnectString()).build();
        this.zkc.create("/ledgers", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zkc.create("/ledgers/available", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
    }

    public void startServer(String path) throws Exception {
        LOG.debug("Running ZK server");
        ClientBase.setupTestEnv();
        this.ZkTmpDir = File.createTempFile("zookeeper", "test");
        this.ZkTmpDir.delete();
        this.ZkTmpDir.mkdir();
        this.zks = new ZooKeeperServer(this.ZkTmpDir, this.ZkTmpDir, 3000);
        this.serverFactory = new NIOServerCnxnFactory();
        this.serverFactory.configure(this.zkaddr, 100);
        this.serverFactory.startup(this.zks);
        this.zooKeeperPort = this.serverFactory.getLocalPort();
        this.connectString = "localhost:" + this.zooKeeperPort;
        boolean b = ClientBase.waitForServerUp((String)this.getZooKeeperConnectString(), (long)ClientBase.CONNECTION_TIMEOUT);
        LOG.debug("Server up: " + b);
        LOG.debug("Instantiate ZK Client");
        this.zkc = ZooKeeperClient.newBuilder().connectString(this.getZooKeeperConnectString()).build();
        if (!"".equals(path)) {
            this.zkc.create(path, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        this.zkc.create(path + "/ledgers", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.zkc.create(path + "/ledgers/available", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
    }

    public void sleepServer(int seconds, CountDownLatch l) throws InterruptedException, IOException {
        Thread[] allthreads = new Thread[Thread.activeCount()];
        Thread.enumerate(allthreads);
        for (Thread t : allthreads) {
            if (!t.getName().contains("SyncThread:0")) continue;
            Thread sleeper = new Thread(() -> {
                try {
                    t.suspend();
                    l.countDown();
                    Thread.sleep(seconds * 1000);
                    t.resume();
                }
                catch (Exception e) {
                    LOG.error("Error suspending thread", (Throwable)e);
                }
            });
            sleeper.start();
            return;
        }
        throw new IOException("ZooKeeper thread not found");
    }

    public void killServer() throws Exception {
        if (this.zkc != null) {
            this.zkc.close();
        }
        if (this.serverFactory != null) {
            this.serverFactory.shutdown();
            Assert.assertTrue((boolean)ClientBase.waitForServerDown((String)this.getZooKeeperConnectString(), (long)ClientBase.CONNECTION_TIMEOUT), (String)"waiting for server down");
        }
        if (this.zks != null) {
            this.zks.getTxnLogFactory().close();
        }
        FileUtils.deleteDirectory((File)this.ZkTmpDir);
    }
}

