/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.test;

import java.lang.reflect.Method;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.PulsarMockBookKeeper;
import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerFactoryImpl;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.pulsar.metadata.impl.FaultInjectionMetadataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;

public abstract class MockedBookKeeperTestCase {
    static final Logger LOG = LoggerFactory.getLogger(MockedBookKeeperTestCase.class);
    protected PulsarMockBookKeeper bkc;
    protected int numBookies;
    protected ManagedLedgerFactoryImpl factory;
    protected OrderedScheduler executor;
    protected ExecutorService cachedExecutor;
    protected FaultInjectionMetadataStore metadataStore;

    public MockedBookKeeperTestCase() {
        this(3);
    }

    public MockedBookKeeperTestCase(int numBookies) {
        this.numBookies = numBookies;
    }

    @BeforeMethod(alwaysRun=true)
    public final void setUp(Method method) throws Exception {
        LOG.info(">>>>>> starting {}", (Object)method);
        this.metadataStore = new FaultInjectionMetadataStore(MetadataStoreExtended.create((String)"memory:local", (MetadataStoreConfig)MetadataStoreConfig.builder().build()));
        try {
            this.startBookKeeper();
        }
        catch (Exception e) {
            LOG.error("Error setting up", (Throwable)e);
            throw e;
        }
        this.factory = new ManagedLedgerFactoryImpl((MetadataStoreExtended)this.metadataStore, (BookKeeper)this.bkc);
        this.setUpTestCase();
    }

    protected void setUpTestCase() throws Exception {
    }

    @AfterMethod(alwaysRun=true)
    public final void tearDown(Method method) {
        try {
            this.cleanUpTestCase();
        }
        catch (Exception e) {
            LOG.error("tearDown Error", (Throwable)e);
        }
        try {
            LOG.info("@@@@@@@@@ stopping " + method);
            this.factory.shutdown();
            this.factory = null;
            this.stopBookKeeper();
            LOG.info("--------- stopped {}", (Object)method);
        }
        catch (Exception e) {
            LOG.error("tearDown Error", (Throwable)e);
        }
    }

    protected void cleanUpTestCase() throws Exception {
    }

    @BeforeClass(alwaysRun=true)
    public final void setUpClass() {
        this.executor = (OrderedScheduler)OrderedScheduler.newSchedulerBuilder().numThreads(2).name("test").build();
        this.cachedExecutor = Executors.newCachedThreadPool();
    }

    @AfterClass(alwaysRun=true)
    public final void tearDownClass() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        if (this.cachedExecutor != null) {
            this.cachedExecutor.shutdownNow();
        }
    }

    protected void startBookKeeper() throws Exception {
        for (int i = 0; i < this.numBookies; ++i) {
            this.metadataStore.put("/ledgers/available/192.168.1.1:" + (5000 + i), new byte[0], Optional.empty()).join();
        }
        this.metadataStore.put("/ledgers/LAYOUT", "1\nflat:1".getBytes(), Optional.empty()).join();
        this.bkc = new PulsarMockBookKeeper((OrderedExecutor)this.executor);
    }

    protected void stopBookKeeper() {
        this.bkc.shutdown();
    }

    protected void stopMetadataStore() {
        this.metadataStore.setAlwaysFail(new MetadataStoreException("failed"));
    }
}

