/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.bookkeeper.mledger.ManagedLedgerConfig;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.ReadOnlyCursor;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerFactoryImpl;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.bookkeeper.mledger.proto.MLDataFormats;
import org.apache.pulsar.metadata.api.GetResult;
import org.apache.pulsar.metadata.api.Stat;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ManagedLedgerFactoryShutdownTest {
    private static final Logger log = LoggerFactory.getLogger(ManagedLedgerFactoryShutdownTest.class);
    private final String ledgerName = UUID.randomUUID().toString();
    private final CountDownLatch slowZk = new CountDownLatch(1);
    private MetadataStoreExtended metadataStore;
    private BookKeeper bookKeeper;

    @BeforeMethod
    private void setup() {
        long version = 0L;
        long createTimeMillis = System.currentTimeMillis();
        this.metadataStore = (MetadataStoreExtended)Mockito.mock(MetadataStoreExtended.class);
        this.bookKeeper = (BookKeeper)Mockito.mock(BookKeeper.class);
        BDDMockito.given((Object)this.metadataStore.get((String)ArgumentMatchers.any())).willAnswer(inv -> {
            String path = (String)inv.getArgument(0, String.class);
            if (path == null) {
                throw new IllegalArgumentException("Path is null.");
            }
            if (path.endsWith(this.ledgerName)) {
                MLDataFormats.ManagedLedgerInfo.Builder mli = MLDataFormats.ManagedLedgerInfo.newBuilder().addLedgerInfo(0, MLDataFormats.ManagedLedgerInfo.LedgerInfo.newBuilder().setLedgerId(0L).setEntries(0L).setTimestamp(System.currentTimeMillis()));
                Stat stat = new Stat(path, 0L, createTimeMillis, createTimeMillis, false, false);
                return CompletableFuture.supplyAsync(() -> {
                    try {
                        this.slowZk.await();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    MLDataFormats.ManagedLedgerInfo managedLedgerInfo = mli.build();
                    log.info("metadataStore.get({}) returned,managedLedgerInfo={},stat={}", new Object[]{path, managedLedgerInfo, stat});
                    return Optional.of(new GetResult(managedLedgerInfo.toByteArray(), stat));
                });
            }
            if (path.contains(this.ledgerName)) {
                MLDataFormats.ManagedCursorInfo.Builder mci = MLDataFormats.ManagedCursorInfo.newBuilder().setCursorsLedgerId(-1L).setMarkDeleteLedgerId(0L).setMarkDeleteLedgerId(-1L);
                Stat stat = new Stat(path, 0L, createTimeMillis, createTimeMillis, false, false);
                return CompletableFuture.supplyAsync(() -> {
                    try {
                        this.slowZk.await();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    MLDataFormats.ManagedCursorInfo managedCursorInfo = mci.build();
                    log.info("metadataStore.get({}) returned:managedCursorInfo={},stat={}", new Object[]{path, managedCursorInfo, stat});
                    return Optional.of(new GetResult(managedCursorInfo.toByteArray(), stat));
                });
            }
            throw new IllegalArgumentException("Invalid path: " + path);
        });
        BDDMockito.given((Object)this.metadataStore.put(ArgumentMatchers.anyString(), (byte[])ArgumentMatchers.any(), (Optional)ArgumentMatchers.any())).willAnswer(inv -> {
            Optional expectedVersion = (Optional)inv.getArgument(2, Optional.class);
            return CompletableFuture.supplyAsync(() -> new Stat((String)inv.getArgument(0, String.class), expectedVersion.orElse(0L) + 1L, createTimeMillis, System.currentTimeMillis(), false, false));
        });
        BDDMockito.given((Object)this.metadataStore.getChildren(ArgumentMatchers.anyString())).willAnswer(inv -> CompletableFuture.supplyAsync(() -> Collections.singletonList("cursor")));
        LedgerHandle ledgerHandle = (LedgerHandle)Mockito.mock(LedgerHandle.class);
        LedgerHandle newLedgerHandle = (LedgerHandle)Mockito.mock(LedgerHandle.class);
        OrderedExecutor executor = OrderedExecutor.newBuilder().name("Test").build();
        BDDMockito.given((Object)this.bookKeeper.getMainWorkerPool()).willReturn((Object)executor);
        ((BookKeeper)Mockito.doAnswer(inv -> {
            AsyncCallback.OpenCallback cb = (AsyncCallback.OpenCallback)inv.getArgument(3, AsyncCallback.OpenCallback.class);
            cb.openComplete(0, ledgerHandle, inv.getArgument(4, Object.class));
            return null;
        }).when((Object)this.bookKeeper)).asyncOpenLedger(ArgumentMatchers.anyLong(), (BookKeeper.DigestType)ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (AsyncCallback.OpenCallback)ArgumentMatchers.any(), ArgumentMatchers.any());
        ((BookKeeper)Mockito.doAnswer(inv -> {
            AsyncCallback.CreateCallback cb = (AsyncCallback.CreateCallback)inv.getArgument(5, AsyncCallback.CreateCallback.class);
            cb.createComplete(0, newLedgerHandle, inv.getArgument(6, Object.class));
            return null;
        }).when((Object)this.bookKeeper)).asyncCreateLedger(ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), (BookKeeper.DigestType)ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (AsyncCallback.CreateCallback)ArgumentMatchers.any(), ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
    }

    @Test(timeOut=5000L)
    public void openEncounteredShutdown() throws Exception {
        ManagedLedgerFactoryImpl factory = new ManagedLedgerFactoryImpl(this.metadataStore, this.bookKeeper);
        final CountDownLatch callbackInvoked = new CountDownLatch(2);
        factory.asyncOpen(this.ledgerName, new AsyncCallbacks.OpenLedgerCallback(){

            public void openLedgerComplete(ManagedLedger ledger, Object ctx) {
                callbackInvoked.countDown();
            }

            public void openLedgerFailed(ManagedLedgerException exception, Object ctx) {
                callbackInvoked.countDown();
            }
        }, null);
        factory.asyncOpenReadOnlyCursor(this.ledgerName, (Position)PositionImpl.EARLIEST, new ManagedLedgerConfig(), new AsyncCallbacks.OpenReadOnlyCursorCallback(){

            public void openReadOnlyCursorComplete(ReadOnlyCursor cursor, Object ctx) {
                callbackInvoked.countDown();
            }

            public void openReadOnlyCursorFailed(ManagedLedgerException exception, Object ctx) {
                log.info("openReadOnlyCursorFailed");
                callbackInvoked.countDown();
            }
        }, null);
        log.info("Shutdown factory...");
        factory.shutdownAsync().get();
        this.slowZk.countDown();
        Assert.assertTrue((boolean)callbackInvoked.await(5L, TimeUnit.SECONDS));
        Assert.assertThrows(ManagedLedgerException.ManagedLedgerFactoryClosedException.class, () -> factory.open(this.ledgerName));
        Assert.assertThrows(ManagedLedgerException.ManagedLedgerFactoryClosedException.class, () -> factory.openReadOnlyCursor(this.ledgerName, (Position)PositionImpl.EARLIEST, new ManagedLedgerConfig()));
    }
}

