/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.util;

import org.apache.bookkeeper.mledger.util.StatsBuckets;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestStatsBuckets {
    @Test
    public void testInvalidConstructor() {
        try {
            new StatsBuckets(new long[0]);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testUnorderedBoundaries() {
        try {
            new StatsBuckets(new long[]{2L, 1L});
            Assert.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void test() {
        StatsBuckets stats = new StatsBuckets(new long[]{10L, 20L, 30L});
        Assert.assertEquals((double)stats.getAvg(), (double)Double.NaN);
        Assert.assertEquals((long)stats.getSum(), (long)0L);
        Assert.assertEquals((long)stats.getCount(), (long)0L);
        Assert.assertEquals((long[])stats.getBuckets(), (long[])new long[]{0L, 0L, 0L, 0L});
        stats.addValue(5L);
        Assert.assertEquals((double)stats.getAvg(), (double)Double.NaN);
        Assert.assertEquals((long)stats.getSum(), (long)0L);
        Assert.assertEquals((long)stats.getCount(), (long)0L);
        Assert.assertEquals((long[])stats.getBuckets(), (long[])new long[]{0L, 0L, 0L, 0L});
        stats.refresh();
        Assert.assertEquals((double)stats.getAvg(), (double)5.0);
        Assert.assertEquals((long)stats.getSum(), (long)5L);
        Assert.assertEquals((long)stats.getCount(), (long)1L);
        Assert.assertEquals((long[])stats.getBuckets(), (long[])new long[]{1L, 0L, 0L, 0L});
        stats.addValue(15L);
        Assert.assertEquals((double)stats.getAvg(), (double)5.0);
        Assert.assertEquals((long)stats.getSum(), (long)5L);
        Assert.assertEquals((long)stats.getCount(), (long)1L);
        Assert.assertEquals((long[])stats.getBuckets(), (long[])new long[]{1L, 0L, 0L, 0L});
        stats.refresh();
        Assert.assertEquals((double)stats.getAvg(), (double)15.0);
        Assert.assertEquals((long)stats.getSum(), (long)15L);
        Assert.assertEquals((long)stats.getCount(), (long)1L);
        Assert.assertEquals((long[])stats.getBuckets(), (long[])new long[]{0L, 1L, 0L, 0L});
        stats.addValue(50L);
        Assert.assertEquals((long)stats.getSum(), (long)15L);
        Assert.assertEquals((long)stats.getCount(), (long)1L);
        stats.addValue(10L);
        stats.addValue(30L);
        stats.refresh();
        Assert.assertEquals((double)stats.getAvg(), (double)30.0);
        Assert.assertEquals((long)stats.getSum(), (long)90L);
        Assert.assertEquals((long)stats.getCount(), (long)3L);
        Assert.assertEquals((long[])stats.getBuckets(), (long[])new long[]{1L, 0L, 1L, 1L});
    }

    @Test
    public void testAddAll() {
        StatsBuckets stats = new StatsBuckets(new long[]{10L, 20L, 30L});
        stats.addValue(1L);
        stats.addValue(2L);
        stats.refresh();
        StatsBuckets stats2 = new StatsBuckets(new long[]{10L, 20L, 30L});
        stats2.addAll(stats);
        stats2.refresh();
        Assert.assertEquals((long)stats2.getSum(), (long)3L);
        Assert.assertEquals((long)stats2.getCount(), (long)2L);
    }
}

