/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.client.api.LastConfirmedAndEntry;
import org.apache.bookkeeper.client.api.LedgerEntries;
import org.apache.bookkeeper.client.api.LedgerEntry;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.client.api.ReadHandle;
import org.apache.bookkeeper.client.impl.LedgerEntriesImpl;
import org.apache.bookkeeper.client.impl.LedgerEntryImpl;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.LedgerOffloader;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.ManagedLedgerConfig;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.bookkeeper.mledger.impl.OffloadPrefixTest;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.bookkeeper.mledger.proto.MLDataFormats;
import org.apache.bookkeeper.mledger.util.MockClock;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.test.MockedBookKeeperTestCase;
import org.apache.pulsar.common.policies.data.OffloadPoliciesImpl;
import org.apache.pulsar.common.policies.data.OffloadedReadPriority;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.Assert;
import org.testng.annotations.Test;

public class OffloadPrefixReadTest
extends MockedBookKeeperTestCase {
    @Test
    public void testOffloadRead() throws Exception {
        MockLedgerOffloader offloader = (MockLedgerOffloader)Mockito.spy(MockLedgerOffloader.class);
        ManagedLedgerConfig config = new ManagedLedgerConfig();
        config.setMaxEntriesPerLedger(10);
        config.setMinimumRolloverTime(0, TimeUnit.SECONDS);
        config.setRetentionTime(10, TimeUnit.MINUTES);
        config.setRetentionSizeInMB(10L);
        config.setLedgerOffloader((LedgerOffloader)offloader);
        ManagedLedgerImpl ledger = (ManagedLedgerImpl)this.factory.open("my_test_ledger", config);
        for (int i = 0; i < 25; ++i) {
            String content = "entry-" + i;
            ledger.addEntry(content.getBytes());
        }
        Assert.assertEquals((int)ledger.getLedgersInfoAsList().size(), (int)3);
        ledger.offloadPrefix(ledger.getLastConfirmedEntry());
        Assert.assertEquals((int)ledger.getLedgersInfoAsList().size(), (int)3);
        Assert.assertTrue((boolean)((MLDataFormats.ManagedLedgerInfo.LedgerInfo)ledger.getLedgersInfoAsList().get(0)).getOffloadContext().getComplete());
        Assert.assertTrue((boolean)((MLDataFormats.ManagedLedgerInfo.LedgerInfo)ledger.getLedgersInfoAsList().get(1)).getOffloadContext().getComplete());
        Assert.assertFalse((boolean)((MLDataFormats.ManagedLedgerInfo.LedgerInfo)ledger.getLedgersInfoAsList().get(2)).getOffloadContext().getComplete());
        UUID firstLedgerUUID = new UUID(((MLDataFormats.ManagedLedgerInfo.LedgerInfo)ledger.getLedgersInfoAsList().get(0)).getOffloadContext().getUidMsb(), ((MLDataFormats.ManagedLedgerInfo.LedgerInfo)ledger.getLedgersInfoAsList().get(0)).getOffloadContext().getUidLsb());
        UUID secondLedgerUUID = new UUID(((MLDataFormats.ManagedLedgerInfo.LedgerInfo)ledger.getLedgersInfoAsList().get(1)).getOffloadContext().getUidMsb(), ((MLDataFormats.ManagedLedgerInfo.LedgerInfo)ledger.getLedgersInfoAsList().get(1)).getOffloadContext().getUidLsb());
        ManagedCursor cursor = ledger.newNonDurableCursor((Position)PositionImpl.earliest);
        int i = 0;
        for (Entry e : cursor.readEntries(10)) {
            Assert.assertEquals((String)new String(e.getData()), (String)("entry-" + i++));
        }
        ((MockLedgerOffloader)Mockito.verify((Object)offloader, (VerificationMode)Mockito.times((int)1))).readOffloaded(ArgumentMatchers.anyLong(), (UUID)ArgumentMatchers.any(), ArgumentMatchers.anyMap());
        ((MockLedgerOffloader)Mockito.verify((Object)offloader)).readOffloaded(ArgumentMatchers.anyLong(), (UUID)ArgumentMatchers.eq((Object)firstLedgerUUID), ArgumentMatchers.anyMap());
        for (Entry e : cursor.readEntries(10)) {
            Assert.assertEquals((String)new String(e.getData()), (String)("entry-" + i++));
        }
        ((MockLedgerOffloader)Mockito.verify((Object)offloader, (VerificationMode)Mockito.times((int)2))).readOffloaded(ArgumentMatchers.anyLong(), (UUID)ArgumentMatchers.any(), ArgumentMatchers.anyMap());
        ((MockLedgerOffloader)Mockito.verify((Object)offloader)).readOffloaded(ArgumentMatchers.anyLong(), (UUID)ArgumentMatchers.eq((Object)secondLedgerUUID), ArgumentMatchers.anyMap());
        for (Entry e : cursor.readEntries(5)) {
            Assert.assertEquals((String)new String(e.getData()), (String)("entry-" + i++));
        }
        ((MockLedgerOffloader)Mockito.verify((Object)offloader, (VerificationMode)Mockito.times((int)2))).readOffloaded(ArgumentMatchers.anyLong(), (UUID)ArgumentMatchers.any(), ArgumentMatchers.anyMap());
        ledger.close();
        Assert.assertEquals((int)offloader.openedReadHandles.get(), (int)0);
    }

    @Test
    public void testBookkeeperFirstOffloadRead() throws Exception {
        MockLedgerOffloader offloader = (MockLedgerOffloader)Mockito.spy(MockLedgerOffloader.class);
        MockClock clock = new MockClock();
        offloader.getOffloadPolicies().setManagedLedgerOffloadedReadPriority(OffloadedReadPriority.BOOKKEEPER_FIRST);
        offloader.getOffloadPolicies().setManagedLedgerOffloadDeletionLagInMillis(Long.valueOf(300000L));
        ManagedLedgerConfig config = new ManagedLedgerConfig();
        config.setMaxEntriesPerLedger(10);
        config.setMinimumRolloverTime(0, TimeUnit.SECONDS);
        config.setRetentionTime(10, TimeUnit.MINUTES);
        config.setRetentionSizeInMB(10L);
        config.setLedgerOffloader((LedgerOffloader)offloader);
        config.setClock((Clock)clock);
        ManagedLedgerImpl ledger = (ManagedLedgerImpl)this.factory.open("my_bookkeeper_first_test_ledger", config);
        for (int i = 0; i < 25; ++i) {
            String content = "entry-" + i;
            ledger.addEntry(content.getBytes());
        }
        Assert.assertEquals((int)ledger.getLedgersInfoAsList().size(), (int)3);
        ledger.offloadPrefix(ledger.getLastConfirmedEntry());
        Assert.assertEquals((int)ledger.getLedgersInfoAsList().size(), (int)3);
        Assert.assertEquals((long)ledger.getLedgersInfoAsList().stream().filter(e -> e.getOffloadContext().getComplete()).count(), (long)2L);
        MLDataFormats.ManagedLedgerInfo.LedgerInfo firstLedger = (MLDataFormats.ManagedLedgerInfo.LedgerInfo)ledger.getLedgersInfoAsList().get(0);
        Assert.assertTrue((boolean)firstLedger.getOffloadContext().getComplete());
        MLDataFormats.ManagedLedgerInfo.LedgerInfo secondLedger = (MLDataFormats.ManagedLedgerInfo.LedgerInfo)ledger.getLedgersInfoAsList().get(1);
        Assert.assertTrue((boolean)secondLedger.getOffloadContext().getComplete());
        UUID firstLedgerUUID = new UUID(firstLedger.getOffloadContext().getUidMsb(), firstLedger.getOffloadContext().getUidLsb());
        UUID secondLedgerUUID = new UUID(secondLedger.getOffloadContext().getUidMsb(), secondLedger.getOffloadContext().getUidLsb());
        ManagedCursor cursor = ledger.newNonDurableCursor((Position)PositionImpl.earliest);
        int i = 0;
        for (Entry e2 : cursor.readEntries(10)) {
            Assert.assertEquals((String)new String(e2.getData()), (String)("entry-" + i++));
        }
        ((MockLedgerOffloader)Mockito.verify((Object)offloader, (VerificationMode)Mockito.never())).readOffloaded(ArgumentMatchers.anyLong(), (UUID)ArgumentMatchers.any(), ArgumentMatchers.anyMap());
        OffloadPrefixTest.assertEventuallyTrue(() -> this.bkc.getLedgers().contains(firstLedger.getLedgerId()));
        OffloadPrefixTest.assertEventuallyTrue(() -> this.bkc.getLedgers().contains(secondLedger.getLedgerId()));
        clock.advance(6L, TimeUnit.MINUTES);
        CompletableFuture promise = new CompletableFuture();
        ledger.internalTrimConsumedLedgers(promise);
        promise.join();
        OffloadPrefixTest.assertEventuallyTrue(() -> !this.bkc.getLedgers().contains(firstLedger.getLedgerId()));
        OffloadPrefixTest.assertEventuallyTrue(() -> !this.bkc.getLedgers().contains(secondLedger.getLedgerId()));
        Assert.assertTrue((boolean)((MLDataFormats.ManagedLedgerInfo.LedgerInfo)ledger.getLedgersInfoAsList().get(0)).getOffloadContext().getBookkeeperDeleted());
        Assert.assertTrue((boolean)((MLDataFormats.ManagedLedgerInfo.LedgerInfo)ledger.getLedgersInfoAsList().get(1)).getOffloadContext().getBookkeeperDeleted());
        for (Entry e3 : cursor.readEntries(10)) {
            Assert.assertEquals((String)new String(e3.getData()), (String)("entry-" + i++));
        }
        ((MockLedgerOffloader)Mockito.verify((Object)offloader, (VerificationMode)Mockito.atLeastOnce())).readOffloaded(ArgumentMatchers.anyLong(), (UUID)ArgumentMatchers.any(), ArgumentMatchers.anyMap());
        ((MockLedgerOffloader)Mockito.verify((Object)offloader)).readOffloaded(ArgumentMatchers.anyLong(), (UUID)ArgumentMatchers.eq((Object)secondLedgerUUID), ArgumentMatchers.anyMap());
    }

    static class MockMetadata
    implements LedgerMetadata {
        private final int ensembleSize;
        private final int writeQuorumSize;
        private final int ackQuorumSize;
        private final long lastEntryId;
        private final long length;
        private final DigestType digestType;
        private final long ctime;
        private final boolean isClosed;
        private final int metadataFormatVersion;
        private final LedgerMetadata.State state;
        private final byte[] password;
        private final Map<String, byte[]> customMetadata;
        private final long ledgerId;

        MockMetadata(LedgerMetadata toCopy) {
            this.ledgerId = toCopy.getLedgerId();
            this.ensembleSize = toCopy.getEnsembleSize();
            this.writeQuorumSize = toCopy.getWriteQuorumSize();
            this.ackQuorumSize = toCopy.getAckQuorumSize();
            this.lastEntryId = toCopy.getLastEntryId();
            this.length = toCopy.getLength();
            this.digestType = toCopy.getDigestType();
            this.ctime = toCopy.getCtime();
            this.isClosed = toCopy.isClosed();
            this.metadataFormatVersion = toCopy.getMetadataFormatVersion();
            this.state = toCopy.getState();
            this.password = Arrays.copyOf(toCopy.getPassword(), toCopy.getPassword().length);
            this.customMetadata = ImmutableMap.copyOf((Map)toCopy.getCustomMetadata());
        }

        public long getLedgerId() {
            return this.ledgerId;
        }

        public boolean hasPassword() {
            return true;
        }

        public LedgerMetadata.State getState() {
            return this.state;
        }

        public int getMetadataFormatVersion() {
            return this.metadataFormatVersion;
        }

        public long getCToken() {
            return 0L;
        }

        public int getEnsembleSize() {
            return this.ensembleSize;
        }

        public int getWriteQuorumSize() {
            return this.writeQuorumSize;
        }

        public int getAckQuorumSize() {
            return this.ackQuorumSize;
        }

        public long getLastEntryId() {
            return this.lastEntryId;
        }

        public long getLength() {
            return this.length;
        }

        public DigestType getDigestType() {
            return this.digestType;
        }

        public byte[] getPassword() {
            return this.password;
        }

        public long getCtime() {
            return this.ctime;
        }

        public boolean isClosed() {
            return this.isClosed;
        }

        public Map<String, byte[]> getCustomMetadata() {
            return this.customMetadata;
        }

        public List<BookieId> getEnsembleAt(long entryId) {
            throw new UnsupportedOperationException("Pulsar shouldn't look at this");
        }

        public NavigableMap<Long, ? extends List<BookieId>> getAllEnsembles() {
            throw new UnsupportedOperationException("Pulsar shouldn't look at this");
        }

        public String toSafeString() {
            return this.toString();
        }
    }

    static class MockOffloadReadHandle
    implements ReadHandle {
        final long id;
        final List<ByteBuf> entries = Lists.newArrayList();
        final LedgerMetadata metadata;

        MockOffloadReadHandle(ReadHandle toCopy) throws Exception {
            this.id = toCopy.getId();
            long lac = toCopy.getLastAddConfirmed();
            try (LedgerEntries entries = toCopy.read(0L, lac);){
                for (LedgerEntry e : entries) {
                    this.entries.add(e.getEntryBuffer().retainedSlice());
                }
            }
            this.metadata = new MockMetadata(toCopy.getLedgerMetadata());
        }

        public long getId() {
            return this.id;
        }

        public LedgerMetadata getLedgerMetadata() {
            return this.metadata;
        }

        public CompletableFuture<Void> closeAsync() {
            return CompletableFuture.completedFuture(null);
        }

        public CompletableFuture<LedgerEntries> readAsync(long firstEntry, long lastEntry) {
            ArrayList readEntries = Lists.newArrayList();
            for (long eid = firstEntry; eid <= lastEntry; ++eid) {
                ByteBuf buf = this.entries.get((int)eid).retainedSlice();
                readEntries.add(LedgerEntryImpl.create((long)this.id, (long)eid, (long)buf.readableBytes(), (ByteBuf)buf));
            }
            return CompletableFuture.completedFuture(LedgerEntriesImpl.create((List)readEntries));
        }

        public CompletableFuture<LedgerEntries> readUnconfirmedAsync(long firstEntry, long lastEntry) {
            return this.unsupported();
        }

        public CompletableFuture<Long> readLastAddConfirmedAsync() {
            return this.unsupported();
        }

        public CompletableFuture<Long> tryReadLastAddConfirmedAsync() {
            return this.unsupported();
        }

        public long getLastAddConfirmed() {
            return this.entries.size() - 1;
        }

        public long getLength() {
            return this.metadata.getLength();
        }

        public boolean isClosed() {
            return this.metadata.isClosed();
        }

        public CompletableFuture<LastConfirmedAndEntry> readLastAddConfirmedAndEntryAsync(long entryId, long timeOutInMillis, boolean parallel) {
            return this.unsupported();
        }

        private <T> CompletableFuture<T> unsupported() {
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally(new UnsupportedOperationException());
            return future;
        }
    }

    static class MockLedgerOffloader
    implements LedgerOffloader {
        ConcurrentHashMap<UUID, ReadHandle> offloads = new ConcurrentHashMap();
        OffloadPoliciesImpl offloadPolicies = OffloadPoliciesImpl.create((String)"S3", (String)"", (String)"", (String)"", null, null, null, null, (Integer)0x4000000, (Integer)0x100000, (Long)OffloadPoliciesImpl.DEFAULT_OFFLOAD_THRESHOLD_IN_BYTES, (Long)OffloadPoliciesImpl.DEFAULT_OFFLOAD_DELETION_LAG_IN_MILLIS, (OffloadedReadPriority)OffloadPoliciesImpl.DEFAULT_OFFLOADED_READ_PRIORITY);
        private final AtomicInteger openedReadHandles = new AtomicInteger(0);

        MockLedgerOffloader() {
        }

        public String getOffloadDriverName() {
            return "mock";
        }

        public CompletableFuture<Void> offload(ReadHandle ledger, UUID uuid, Map<String, String> extraMetadata) {
            CompletableFuture<Void> promise = new CompletableFuture<Void>();
            try {
                this.offloads.put(uuid, new MockOffloadReadHandle(ledger));
                promise.complete(null);
            }
            catch (Exception e) {
                promise.completeExceptionally(e);
            }
            return promise;
        }

        public CompletableFuture<ReadHandle> readOffloaded(long ledgerId, UUID uuid, Map<String, String> offloadDriverMetadata) {
            return CompletableFuture.completedFuture(new VerifyClosingReadHandle(this.offloads.get(uuid)));
        }

        public CompletableFuture<Void> deleteOffloaded(long ledgerId, UUID uuid, Map<String, String> offloadDriverMetadata) {
            this.offloads.remove(uuid);
            return CompletableFuture.completedFuture(null);
        }

        public OffloadPoliciesImpl getOffloadPolicies() {
            return this.offloadPolicies;
        }

        public void close() {
        }

        class VerifyClosingReadHandle
        extends MockOffloadReadHandle {
            VerifyClosingReadHandle(ReadHandle toCopy) throws Exception {
                super(toCopy);
                MockLedgerOffloader.this.openedReadHandles.incrementAndGet();
            }

            @Override
            public CompletableFuture<Void> closeAsync() {
                MockLedgerOffloader.this.openedReadHandles.decrementAndGet();
                return super.closeAsync();
            }
        }
    }
}

