/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.util;

import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallbackMutex {
    private Semaphore semaphore = new Semaphore(1, true);
    String owner;
    String position;
    private static final Logger log = LoggerFactory.getLogger(CallbackMutex.class);

    public void lock() {
        this.semaphore.acquireUninterruptibly();
        if (log.isDebugEnabled()) {
            this.owner = Thread.currentThread().getName();
            this.position = Thread.currentThread().getStackTrace()[2].toString();
            log.debug("<<< Lock {} acquired at {}", (Object)this.hashCode(), (Object)this.position);
        }
    }

    public boolean tryLock() {
        if (!this.semaphore.tryAcquire()) {
            return false;
        }
        if (log.isDebugEnabled()) {
            this.owner = Thread.currentThread().getName();
            this.position = Thread.currentThread().getStackTrace()[2].toString();
            log.debug("<<< Lock {} acquired at {}", (Object)this.hashCode(), (Object)this.position);
        }
        return true;
    }

    public void unlock() {
        if (log.isDebugEnabled()) {
            this.owner = null;
            this.position = null;
            log.debug(">>> Lock {} released at {}", (Object)this.hashCode(), (Object)Thread.currentThread().getStackTrace()[2]);
        }
        this.semaphore.release();
    }
}

