/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.test;

import io.netty.buffer.ByteBufAllocator;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.client.BookKeeperTestClient;
import org.apache.bookkeeper.common.allocator.PoolingPolicy;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.discover.BookieServiceInfo;
import org.apache.bookkeeper.metastore.InMemoryMetaStore;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.replication.AutoRecoveryMain;
import org.apache.bookkeeper.test.ZooKeeperUtil;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.pulsar.metadata.impl.FaultInjectionMetadataStore;
import org.apache.zookeeper.KeeperException;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

public abstract class BookKeeperClusterTestCase {
    static final Logger LOG = LoggerFactory.getLogger(BookKeeperClusterTestCase.class);
    protected ZooKeeperUtil zkUtil = new ZooKeeperUtil();
    protected FaultInjectionMetadataStore metadataStore;
    protected List<File> tmpDirs = new LinkedList<File>();
    protected List<BookieServer> bs = new LinkedList<BookieServer>();
    protected List<ServerConfiguration> bsConfs = new LinkedList<ServerConfiguration>();
    protected int numBookies;
    protected BookKeeperTestClient bkc;
    protected ServerConfiguration baseConf = new ServerConfiguration();
    protected ClientConfiguration baseClientConf = new ClientConfiguration();
    private final Map<BookieServer, AutoRecoveryMain> autoRecoveryProcesses = new HashMap<BookieServer, AutoRecoveryMain>();
    private boolean isAutoRecoveryEnabled;
    protected ExecutorService executor;

    public BookKeeperClusterTestCase(int numBookies) {
        this.numBookies = numBookies;
    }

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        System.setProperty("zookeeper.4lw.commands.whitelist", "*");
        this.executor = Executors.newCachedThreadPool();
        InMemoryMetaStore.reset();
        this.setMetastoreImplClass((AbstractConfiguration)this.baseConf);
        this.setMetastoreImplClass((AbstractConfiguration)this.baseClientConf);
        try {
            String zkPath = this.changeLedgerPath();
            this.startZKCluster(zkPath);
            this.startBKCluster(zkPath);
        }
        catch (Exception e) {
            LOG.error("Error setting up", (Throwable)e);
            throw e;
        }
    }

    protected String changeLedgerPath() {
        return "";
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.stopBKCluster();
        this.stopZKCluster();
        this.executor.shutdownNow();
    }

    protected void startZKCluster() throws Exception {
        this.startZKCluster("");
    }

    protected void startZKCluster(String path) throws Exception {
        this.zkUtil.startServer(path);
        this.metadataStore = new FaultInjectionMetadataStore(MetadataStoreExtended.create((String)this.zkUtil.getZooKeeperConnectString(), (MetadataStoreConfig)MetadataStoreConfig.builder().build()));
    }

    protected void stopZKCluster() throws Exception {
        this.zkUtil.killServer();
    }

    protected void startBKCluster(String ledgerPath) throws Exception {
        this.baseClientConf.setMetadataServiceUri("zk://" + this.zkUtil.getZooKeeperConnectString() + ledgerPath + "/ledgers");
        this.baseClientConf.setUseV2WireProtocol(true);
        this.baseClientConf.setEnableDigestTypeAutodetection(true);
        this.baseClientConf.setAllocatorPoolingPolicy(PoolingPolicy.UnpooledHeap);
        if (this.numBookies > 0) {
            this.bkc = new BookKeeperTestClient(this.baseClientConf);
        }
        for (int i = 0; i < this.numBookies; ++i) {
            if (!"".equals(ledgerPath)) {
                ServerConfiguration configuration = this.newServerConfiguration(ledgerPath + "/ledgers");
                this.startBookie(configuration, ledgerPath + "/ledgers");
                continue;
            }
            this.startNewBookie();
        }
    }

    protected void stopBKCluster() throws Exception {
        if (this.bkc != null) {
            this.bkc.close();
        }
        for (BookieServer server : this.bs) {
            server.shutdown();
            AutoRecoveryMain autoRecovery = this.autoRecoveryProcesses.get(server);
            if (autoRecovery == null || !this.isAutoRecoveryEnabled()) continue;
            autoRecovery.shutdown();
            LOG.debug("Shutdown auto recovery for bookieserver:" + server.getLocalAddress());
        }
        this.bs.clear();
        for (File f : this.tmpDirs) {
            FileUtils.deleteDirectory((File)f);
        }
    }

    protected ServerConfiguration newServerConfiguration() throws Exception {
        return this.newServerConfiguration("");
    }

    protected ServerConfiguration newServerConfiguration(String ledgerRootPath) throws Exception {
        File f = File.createTempFile("bookie", "test");
        this.tmpDirs.add(f);
        f.delete();
        f.mkdir();
        int port = 0;
        return this.newServerConfiguration(port, this.zkUtil.getZooKeeperConnectString(), f, new File[]{f}, ledgerRootPath);
    }

    protected ClientConfiguration newClientConfiguration() {
        return new ClientConfiguration((AbstractConfiguration)this.baseConf);
    }

    protected ServerConfiguration newServerConfiguration(int port, String zkServers, File journalDir, File[] ledgerDirs, String ledgerRootPath) {
        ServerConfiguration conf = new ServerConfiguration((AbstractConfiguration)this.baseConf);
        conf.setBookiePort(port);
        if (!"".equals(ledgerRootPath)) {
            conf.setMetadataServiceUri("zk://" + this.zkUtil.getZooKeeperConnectString() + ledgerRootPath);
        } else {
            conf.setZkServers(zkServers);
        }
        conf.setJournalDirName(journalDir.getPath());
        conf.setAllowLoopback(true);
        conf.setFlushInterval(60000);
        conf.setGcWaitTime(60000L);
        conf.setAllocatorPoolingPolicy(PoolingPolicy.UnpooledHeap);
        String[] ledgerDirNames = new String[ledgerDirs.length];
        for (int i = 0; i < ledgerDirs.length; ++i) {
            ledgerDirNames[i] = ledgerDirs[i].getPath();
        }
        conf.setLedgerDirNames(ledgerDirNames);
        conf.setLedgerStorageClass("org.apache.bookkeeper.bookie.storage.ldb.DbLedgerStorage");
        conf.setProperty("dbStorage_writeCacheMaxSizeMb", (Object)4);
        conf.setProperty("dbStorage_readAheadCacheMaxSizeMb", (Object)4);
        return conf;
    }

    public BookieSocketAddress getBookie(int index) throws Exception {
        if (this.bs.size() <= index || index < 0) {
            throw new IllegalArgumentException("Invalid index, there are only " + this.bs.size() + " bookies. Asked for " + index);
        }
        return this.bs.get(index).getLocalAddress();
    }

    public ServerConfiguration killBookie(InetSocketAddress addr) throws Exception {
        BookieServer toRemove = null;
        int toRemoveIndex = 0;
        for (BookieServer server : this.bs) {
            if (server.getLocalAddress().equals((Object)addr)) {
                server.shutdown();
                toRemove = server;
                break;
            }
            ++toRemoveIndex;
        }
        if (toRemove != null) {
            this.stopAutoRecoveryService(toRemove);
            this.bs.remove(toRemove);
            return this.bsConfs.remove(toRemoveIndex);
        }
        return null;
    }

    public ServerConfiguration killBookie(int index) throws Exception {
        if (index >= this.bs.size()) {
            throw new IOException("Bookie does not exist");
        }
        BookieServer server = this.bs.get(index);
        server.shutdown();
        this.stopAutoRecoveryService(server);
        this.bs.remove(server);
        return this.bsConfs.remove(index);
    }

    public CountDownLatch sleepBookie(InetSocketAddress addr, final int seconds) throws Exception {
        for (final BookieServer bookie : this.bs) {
            if (!bookie.getLocalAddress().equals((Object)addr)) continue;
            final CountDownLatch l = new CountDownLatch(1);
            Thread sleeper = new Thread(){

                @Override
                public void run() {
                    try {
                        bookie.suspendProcessing();
                        l.countDown();
                        Thread.sleep(seconds * 1000);
                        bookie.resumeProcessing();
                    }
                    catch (Exception e) {
                        LOG.error("Error suspending bookie", (Throwable)e);
                    }
                }
            };
            sleeper.start();
            return l;
        }
        throw new IOException("Bookie not found");
    }

    public void sleepBookie(InetSocketAddress addr, final CountDownLatch l) throws Exception {
        for (final BookieServer bookie : this.bs) {
            if (!bookie.getLocalAddress().equals((Object)addr)) continue;
            Thread sleeper = new Thread(){

                @Override
                public void run() {
                    try {
                        bookie.suspendProcessing();
                        l.await();
                        bookie.resumeProcessing();
                    }
                    catch (Exception e) {
                        LOG.error("Error suspending bookie", (Throwable)e);
                    }
                }
            };
            sleeper.start();
            return;
        }
        throw new IOException("Bookie not found");
    }

    public void restartBookies() throws Exception {
        this.restartBookies(null);
    }

    public void restartBookies(ServerConfiguration newConf) throws Exception {
        for (BookieServer server : this.bs) {
            server.shutdown();
            this.stopAutoRecoveryService(server);
        }
        this.bs.clear();
        Thread.sleep(1000L);
        ArrayList<ServerConfiguration> bsConfsCopy = new ArrayList<ServerConfiguration>(this.bsConfs);
        this.bsConfs.clear();
        for (ServerConfiguration conf : bsConfsCopy) {
            if (null != newConf) {
                conf.loadConf((CompositeConfiguration)newConf);
            }
            this.startBookie(conf);
        }
    }

    public int startNewBookie() throws Exception {
        ServerConfiguration conf = this.newServerConfiguration();
        this.startBookie(conf);
        return conf.getBookiePort();
    }

    protected BookieServer startBookie(ServerConfiguration conf, String ledgerRootPath) throws Exception {
        BookieServer server = new BookieServer(conf);
        this.bsConfs.add(conf);
        this.bs.add(server);
        server.start();
        if (this.bkc == null) {
            this.bkc = new BookKeeperTestClient(this.baseClientConf);
        }
        int port = conf.getBookiePort();
        Awaitility.await().until(() -> (Boolean)this.metadataStore.exists(ledgerRootPath + "/available/" + InetAddress.getLocalHost().getHostAddress() + ":" + port).join());
        this.bkc.readBookiesBlocking();
        LOG.info("New bookie on port " + port + " has been created.");
        return server;
    }

    protected BookieServer startBookie(ServerConfiguration conf) throws Exception {
        return this.startBookie(conf, "/ledgers");
    }

    protected BookieServer startBookie(ServerConfiguration conf, final Bookie b) throws Exception {
        BookieServer server = new BookieServer(conf){

            protected Bookie newBookie(ServerConfiguration conf, ByteBufAllocator allocator, Supplier<BookieServiceInfo> bookieServiceInfoProvider) throws IOException, KeeperException, InterruptedException, BookieException {
                return b;
            }
        };
        server.start();
        int port = conf.getBookiePort();
        Awaitility.await().until(() -> (Boolean)this.metadataStore.exists("/ledgers/available/" + InetAddress.getLocalHost().getHostAddress() + ":" + port).join());
        this.bkc.readBookiesBlocking();
        LOG.info("New bookie on port " + port + " has been created.");
        return server;
    }

    public void setMetastoreImplClass(AbstractConfiguration conf) {
        conf.setMetastoreImplClass(InMemoryMetaStore.class.getName());
    }

    public void setAutoRecoveryEnabled(boolean isAutoRecoveryEnabled) {
        this.isAutoRecoveryEnabled = isAutoRecoveryEnabled;
    }

    public boolean isAutoRecoveryEnabled() {
        return this.isAutoRecoveryEnabled;
    }

    private void stopAutoRecoveryService(BookieServer toRemove) throws Exception {
        AutoRecoveryMain autoRecoveryMain = this.autoRecoveryProcesses.remove(toRemove);
        if (null != autoRecoveryMain && this.isAutoRecoveryEnabled()) {
            autoRecoveryMain.shutdown();
            LOG.debug("Shutdown auto recovery for bookieserver:" + toRemove.getLocalAddress());
        }
    }

    public void stopReplicationService() throws Exception {
        if (!this.isAutoRecoveryEnabled()) {
            return;
        }
        for (Map.Entry<BookieServer, AutoRecoveryMain> autoRecoveryProcess : this.autoRecoveryProcesses.entrySet()) {
            autoRecoveryProcess.getValue().shutdown();
            LOG.debug("Shutdown Auditor Recovery for the bookie:" + autoRecoveryProcess.getKey().getLocalAddress());
        }
    }
}

