/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerTest;
import org.apache.bookkeeper.mledger.impl.MetaStore;
import org.apache.bookkeeper.mledger.impl.MetaStoreImpl;
import org.apache.bookkeeper.mledger.proto.MLDataFormats;
import org.apache.bookkeeper.test.MockedBookKeeperTestCase;
import org.apache.pulsar.metadata.api.MetadataCache;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.Stat;
import org.apache.pulsar.metadata.impl.FaultInjectionMetadataStore;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MetaStoreImplTest
extends MockedBookKeeperTestCase {
    @Test
    void getMLList() throws Exception {
        MetaStoreImpl store = new MetaStoreImpl((MetadataStore)this.metadataStore, (OrderedExecutor)this.executor);
        this.metadataStore.failConditional(new MetadataStoreException("error"), (op, path) -> op == FaultInjectionMetadataStore.OperationType.GET_CHILDREN && path.equals("/managed-ledgers"));
        try {
            store.getManagedLedgers();
            Assert.fail((String)"should fail in getting the list");
        }
        catch (ManagedLedgerException.MetaStoreException metaStoreException) {
            // empty catch block
        }
    }

    @Test
    void deleteNonExistingML() throws Exception {
        MetaStoreImpl store = new MetaStoreImpl((MetadataStore)this.metadataStore, (OrderedExecutor)this.executor);
        final AtomicReference exception = new AtomicReference();
        final CountDownLatch counter = new CountDownLatch(1);
        store.removeManagedLedger("non-existing", (MetaStore.MetaStoreCallback)new MetaStore.MetaStoreCallback<Void>(){

            public void operationComplete(Void result, Stat version) {
                counter.countDown();
            }

            public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                exception.set(e);
                counter.countDown();
            }
        });
        counter.await();
        Assert.assertNotNull(exception.get());
    }

    @Test(timeOut=20000L)
    void readMalformedML() throws Exception {
        MetaStoreImpl store = new MetaStoreImpl((MetadataStore)this.metadataStore, (OrderedExecutor)this.executor);
        this.metadataStore.put("/managed-ledgers/my_test", "non-valid".getBytes(), Optional.empty()).join();
        final CountDownLatch latch = new CountDownLatch(1);
        store.getManagedLedgerInfo("my_test", false, (MetaStore.MetaStoreCallback)new MetaStore.MetaStoreCallback<MLDataFormats.ManagedLedgerInfo>(){

            public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                latch.countDown();
            }

            public void operationComplete(MLDataFormats.ManagedLedgerInfo result, Stat version) {
                Assert.fail((String)"Operation should have failed");
            }
        });
        latch.await();
    }

    @Test(timeOut=20000L)
    void readMalformedCursorNode() throws Exception {
        MetaStoreImpl store = new MetaStoreImpl((MetadataStore)this.metadataStore, (OrderedExecutor)this.executor);
        this.metadataStore.put("/managed-ledgers/my_test", "".getBytes(), Optional.empty()).join();
        this.metadataStore.put("/managed-ledgers/my_test/c1", "non-valid".getBytes(), Optional.empty()).join();
        final CountDownLatch latch = new CountDownLatch(1);
        store.asyncGetCursorInfo("my_test", "c1", (MetaStore.MetaStoreCallback)new MetaStore.MetaStoreCallback<MLDataFormats.ManagedCursorInfo>(){

            public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                latch.countDown();
            }

            public void operationComplete(MLDataFormats.ManagedCursorInfo result, Stat version) {
                Assert.fail((String)"Operation should have failed");
            }
        });
        latch.await();
    }

    @Test(timeOut=20000L)
    void failInCreatingMLnode() throws Exception {
        MetaStoreImpl store = new MetaStoreImpl((MetadataStore)this.metadataStore, (OrderedExecutor)this.executor);
        final CompletableFuture promise = new CompletableFuture();
        this.metadataStore.failConditional(new MetadataStoreException("error"), (op, path) -> op == FaultInjectionMetadataStore.OperationType.PUT);
        store.getManagedLedgerInfo("my_test", false, (MetaStore.MetaStoreCallback)new MetaStore.MetaStoreCallback<MLDataFormats.ManagedLedgerInfo>(){

            public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                promise.complete(null);
            }

            public void operationComplete(MLDataFormats.ManagedLedgerInfo result, Stat version) {
                promise.completeExceptionally(new Exception("Operation should have failed"));
            }
        });
        promise.get();
    }

    @Test(timeOut=20000L)
    void updatingCursorNode() throws Exception {
        MetaStoreImpl store = new MetaStoreImpl((MetadataStore)this.metadataStore, (OrderedExecutor)this.executor);
        this.metadataStore.put("/managed-ledgers/my_test", "".getBytes(), Optional.empty()).join();
        final CompletableFuture promise = new CompletableFuture();
        MLDataFormats.ManagedCursorInfo info = MLDataFormats.ManagedCursorInfo.newBuilder().setCursorsLedgerId(1L).build();
        store.asyncUpdateCursorInfo("my_test", "c1", info, null, (MetaStore.MetaStoreCallback)new MetaStore.MetaStoreCallback<Void>((MetaStore)store){
            final /* synthetic */ MetaStore val$store;
            {
                this.val$store = metaStore;
            }

            public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                promise.completeExceptionally((Throwable)e);
            }

            public void operationComplete(Void result, Stat version) {
                MetaStoreImplTest.this.metadataStore.failConditional(new MetadataStoreException("error"), (op, path) -> op == FaultInjectionMetadataStore.OperationType.PUT && path.contains("my_test") && path.contains("c1"));
                MLDataFormats.ManagedCursorInfo info = MLDataFormats.ManagedCursorInfo.newBuilder().setCursorsLedgerId(2L).build();
                this.val$store.asyncUpdateCursorInfo("my_test", "c1", info, version, (MetaStore.MetaStoreCallback)new MetaStore.MetaStoreCallback<Void>(){

                    public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                        promise.complete(null);
                    }

                    public void operationComplete(Void result, Stat version) {
                        promise.completeExceptionally(new Exception("should have failed"));
                    }
                });
            }
        });
        promise.get();
    }

    @Test(timeOut=20000L)
    void updatingMLNode() throws Exception {
        MetaStoreImpl store = new MetaStoreImpl((MetadataStore)this.metadataStore, (OrderedExecutor)this.executor);
        this.metadataStore.put("/managed-ledgers/my_test", "".getBytes(), Optional.empty());
        final CompletableFuture promise = new CompletableFuture();
        store.getManagedLedgerInfo("my_test", false, (MetaStore.MetaStoreCallback)new MetaStore.MetaStoreCallback<MLDataFormats.ManagedLedgerInfo>((MetaStore)store){
            final /* synthetic */ MetaStore val$store;
            {
                this.val$store = metaStore;
            }

            public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                promise.completeExceptionally((Throwable)e);
            }

            public void operationComplete(MLDataFormats.ManagedLedgerInfo mlInfo, Stat version) {
                MetaStoreImplTest.this.metadataStore.failConditional((MetadataStoreException)new MetadataStoreException.BadVersionException("error"), (op, path) -> op == FaultInjectionMetadataStore.OperationType.PUT && path.contains("my_test"));
                this.val$store.asyncUpdateLedgerIds("my_test", mlInfo, version, (MetaStore.MetaStoreCallback)new MetaStore.MetaStoreCallback<Void>(){

                    public void operationFailed(ManagedLedgerException.MetaStoreException e) {
                        promise.complete(null);
                    }

                    public void operationComplete(Void result, Stat version) {
                        promise.completeExceptionally(new Exception("should have failed"));
                    }
                });
            }
        });
        promise.get();
    }

    @Test
    public void testGetChildrenWatch() throws Exception {
        MetadataCache objCache1 = this.metadataStore.getMetadataCache(MyClass.class);
        String path = "/managed-ledgers/prop-xyz/ns1/persistent";
        Assert.assertTrue((boolean)((List)objCache1.getChildren(path).get()).isEmpty());
        this.metadataStore.put("/managed-ledgers/prop-xyz/ns1/persistent/t1", "".getBytes(), Optional.empty()).join();
        ManagedLedgerTest.retryStrategically(test -> {
            try {
                return !((List)objCache1.getChildren(path).get()).isEmpty();
            }
            catch (Exception exception) {
                return false;
            }
        }, 5, 1000L);
        Assert.assertFalse((boolean)((List)objCache1.getChildren(path).get()).isEmpty());
    }

    static class MyClass {
        String a;
        int b;

        public String getA() {
            return this.a;
        }

        public int getB() {
            return this.b;
        }

        public void setA(String a) {
            this.a = a;
        }

        public void setB(int b) {
            this.b = b;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MyClass)) {
                return false;
            }
            MyClass other = (MyClass)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getB() != other.getB()) {
                return false;
            }
            String this$a = this.getA();
            String other$a = other.getA();
            return !(this$a == null ? other$a != null : !this$a.equals(other$a));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MyClass;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getB();
            String $a = this.getA();
            result = result * 59 + ($a == null ? 43 : $a.hashCode());
            return result;
        }

        public String toString() {
            return "MetaStoreImplTest.MyClass(a=" + this.getA() + ", b=" + this.getB() + ")";
        }

        public MyClass(String a, int b) {
            this.a = a;
            this.b = b;
        }

        public MyClass() {
        }
    }
}

